// Pagination start

var numberOfItems;
var limitPerPage = 10;
var totalPages;
var currentPage = 1;

var selectedFromGroup = false;
var selectedToGroup = false;

function pagination() {

    numberOfItems = $(".user-list-tr").length;

    totalPages = Math.ceil(numberOfItems / limitPerPage)

    $(".user-list-tr:gt(" + (limitPerPage - 1) + ")").hide();

    var pagination = $(".pagination");

    pagination.append("<li id='prev-page' class='aui-nav-first'><a href='javascript:void(0)'>Prev</a></li>")

    pagination.append("<li class='current aui-nav-truncation aui-nav-selected'><a href='javascript:void(0)'>1</a></li>")

    for (var i = 2; i <= totalPages; i++) {
        pagination.append("<li class='current aui-nav-truncation'><a href='javascript:void(0)'>" + i + "</a></li>")
    }

    pagination.append("<li id='next-page' class='aui-nav-next'><a href='javascript:void(0)'>Next</a></li>")
}


AJS.$(document).on("click", ".pagination li.current", function () {

    if ($(this).hasClass("aui-nav-selected")) {
        return false;
    }

    $(".pagination li").removeClass("aui-nav-selected");
    $(this).addClass("aui-nav-selected")

    currentPage = $(this).index()

    $('.user-list-tr').hide();

    var grandTotal = limitPerPage * currentPage;

    for (var i = grandTotal - limitPerPage; i < grandTotal; i++) {
        $(".user-list-tr:eq(" + i + ")").show();
    }
})

AJS.$(document).on("click", "#prev-page", function () {
    if (currentPage === 1) {
        return false;
    }

    currentPage--;

    changePage()
})

AJS.$(document).on("click", "#next-page", function () {
    if (currentPage === totalPages) {
        return false;
    }

    currentPage++;

    changePage()
})

function changePage() {
    $(".pagination li").removeClass("aui-nav-selected");
    $('.user-list-tr').hide();

    var grandTotal = limitPerPage * currentPage;

    for (var i = grandTotal - limitPerPage; i < grandTotal; i++) {
        $(".user-list-tr:eq(" + i + ")").show();
    }

    $(".pagination li:eq(" + (currentPage) + ")").addClass("aui-nav-selected");
}

AJS.$(document).ready(function () {

    var size = $("#size").val()
    $("#pageSizeSelect option[value=" + size +"]").attr('selected','selected');

    limitPerPage = size

    var listSize = $(".user-list-tr").length;

    if (listSize <= limitPerPage) {
        return false;
    }

    if (listSize > 0) {
        pagination()
    }
})

AJS.$(document).on("change", "#pageSizeSelect", function () {
    var value = $("#pageSizeSelect option:selected").val();

    // $("#pageSizeSelect option[value=" + value +"]").prop("selected", true);

    $("#size").val(value)
    limitPerPage = value;
})

//------------

//Check button filter

AJS.$(document).ready(function () {
    selectedFromGroup = $("#fromgroup option:selected").val() !== "";
    selectedToGroup = $("#togroup option:selected").val() !== ""
    changeButton()
})

AJS.$(document).on("change", "#fromgroup", function () {
    selectedFromGroup = $("#fromgroup option:selected").val() !== "";
    changeButton()
})

AJS.$(document).on("change", "#togroup", function () {
    selectedToGroup = $("#togroup option:selected").val() !== ""
    changeButton();
})

function changeButton() {
    AJS.$("#buttonList").prop('disabled', !(selectedFromGroup && selectedToGroup));
}

//------------
