/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.service.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.enums.LicenseType;
import de.accxia.jira.addon.IUM.service.LicenseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    public LicenseServiceImpl(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public LicenseType getCurrentLicenseType() {
        if (!DAO.getSideLicense().isEmpty()) {
            return LicenseType.SIDE_LICENSED;
        }
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return LicenseType.JIRA_LICENSED;
        }
        return LicenseType.NO_LICENSED;
    }

    @Override
    public void removeSideLicense() {
        DAO.updateSideLicense("");
        ConditionEvaluatorImpl.deleteSideLicense();
    }
}

