/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.model.CurrentUser;
import de.accxia.jira.addon.IUM.saml.SAMLHelper;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import de.accxia.jira.addon.IUM.servlet.filter.AccxiaResponseWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IntelligentUserManagerSAMLFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerSAMLFilter.class);
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @ComponentImport
    private final UserManager userManager = ComponentAccessor.getUserManager();
    private final UserManagementServiceImpl userManagementService;

    public IntelligentUserManagerSAMLFilter(TemplateRenderer templateRenderer, UserManagementServiceImpl userManagementService) {
        this.templateRenderer = templateRenderer;
        this.userManagementService = userManagementService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String samlPar = httpRequest.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser applicationUser = this.userManager.getUserByName(user);
        String myRedirLocation = "/";
        if (applicationUser == null) {
            AccxiaResponseWrapper myWrapper = new AccxiaResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)myWrapper);
            myRedirLocation = myWrapper.getRedirectLocation();
            applicationUser = this.userManager.getUserByName(user);
            UserManagementServiceImpl.moveUserToDisabled(applicationUser);
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (UserManagementServiceImpl.isUserInGroups(applicationUser, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (!UserManagementServiceImpl.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            chain.doFilter(request, response);
            return;
        }
        CurrentUser currentUser = UserManagementServiceImpl.enableUserFromGroup(user, httpRequest);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.getUser();
            if (theUser != null) {
                httpRequest.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                httpResponse.sendRedirect(DAO.getSamlIdp());
            } else {
                this.renderQueueVM(currentUser.getNoOfUsers(), httpRequest, httpResponse);
                return;
            }
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

