/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.controller;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.enums.LicenseStatus;
import de.accxia.jira.addon.IUM.domain.model.LicenseData;
import de.accxia.jira.addon.IUM.domain.model.LicenseDetails;
import de.accxia.jira.addon.IUM.side.VerifyMessage;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Scanned
@Component
@Path(value="/licenseInfo")
public class LicenseInfoRestController {
    @ComponentImport
    private final UserManager userManager;

    @GET
    @Path(value="/")
    public Response getSideLicenseDetails(@Context HttpServletRequest request) {
        UserKey userkey = this.userManager.getRemoteUserKey();
        LicenseData ourSideLicense = ConditionEvaluatorImpl.getSideLicense();
        LicenseStatus licenseStatus = VerifyMessage.getLicenseStatus(ourSideLicense);
        if (userkey == null || !this.userManager.isAdmin(userkey)) {
            return Response.ok((Object)LicenseDetails.builder().licenseStatus(licenseStatus).build()).build();
        }
        LicenseDetails licenseDetails = LicenseDetails.builder().licenseStatus(licenseStatus).users(ourSideLicense.getUsers()).SSN(ourSideLicense.getSSN()).customer(ourSideLicense.getCustomer()).licenseKey(DAO.getSideLicense()).build();
        return Response.ok((Object)licenseDetails).build();
    }

    public LicenseInfoRestController(UserManager userManager) {
        this.userManager = userManager;
    }
}

