/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.eventListener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class UserEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UserEventListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;

    public UserEventListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        ApplicationUser user;
        if (ConditionEvaluatorImpl.isLicenseValid() && (user = logoutEvent.getUser()) != null) {
            UserManagementServiceImpl.moveUserToDisabled(user);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

