/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.service.impl;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.model.CurrentUser;
import de.accxia.jira.addon.IUM.impl.UserDto;
import de.accxia.jira.addon.IUM.service.UserManagementService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserManagementServiceImpl
implements UserManagementService {
    private static final Logger log = LoggerFactory.getLogger(UserManagementServiceImpl.class);
    private static final UserUtil userUtil = ComponentAccessor.getUserUtil();
    private static final UserManager userManagerJira = ComponentAccessor.getUserManager();
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private static final GlobalPermissionManager permissionManager = ComponentAccessor.getGlobalPermissionManager();
    private static final UserIssueHistoryManager historyManager = (UserIssueHistoryManager)ComponentAccessor.getComponent(UserIssueHistoryManager.class);
    private static final UserSearchService userSearchService = (UserSearchService)ComponentAccessor.getComponent(UserSearchService.class);
    private static final CrowdService crowdService = ComponentAccessor.getCrowdService();

    public static void logOutUser(ApplicationUser theUser, HttpServletRequest request, JiraAuthenticationContext jiraAuthContext) {
        log.warn("ACCXIATEST Loggingout user " + theUser.getName());
        request.getSession().setAttribute("seraph_defaultauthenticator_user", null);
        request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", (Object)theUser);
        jiraAuthContext.clearLoggedInUser();
    }

    public static boolean isUserInGroups(ApplicationUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        for (String group : groups.split(",")) {
            if (!groupManager.isUserInGroup(currentUser, group)) continue;
            return true;
        }
        return false;
    }

    public static long getLong(String str) {
        long d = 0L;
        try {
            d = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        return d;
    }

    public static String moveUserFromGroupToGroup(ApplicationUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = groupManager.getGroup(group);
            Group theToGroup = groupManager.getGroup(toGroup);
            UserManagementServiceImpl.disableUserFromGroup(user, theGroup, theToGroup, move);
            theLog.append(user.getUsername()).append("=>").append(theToGroup.getName()).append("</br>\n");
            return theLog.toString();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return "";
        }
    }

    public static String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ApplicationUser user = userManagerJira.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(UserManagementServiceImpl.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return "";
        }
    }

    public static String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (ApplicationUser it : groupManager.getUsersInGroup(group)) {
                ++totalRemoved;
                theLog.append(UserManagementServiceImpl.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return "";
        }
    }

    public static String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(UserManagementServiceImpl.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return "";
        }
    }

    public static void disableUserFromGroup(ApplicationUser user, Group group, Group groupDisabled, boolean move) {
        if (groupManager.isUserInGroup(user, group)) {
            try {
                userUtil.addUserToGroup(groupDisabled, user);
                if (move) {
                    userUtil.removeUserFromGroup(group, user);
                }
            }
            catch (AddException | PermissionException | RemoveException e) {
                log.warn(e.getMessage());
            }
        }
    }

    public static CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ApplicationUser user = userManagerJira.getUserByName(userName);
        return UserManagementServiceImpl.enableUserFromGroup(user, request);
    }

    public static CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request) {
        String currentGroup = "";
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] groups = null;
            String[] groupsDisabled = null;
            String[] queueSizes = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            if (queueSizeTxt != null) {
                queueSizes = queueSizeTxt.split(",");
            }
            CurrentUser resultUser = null;
            for (int i = 0; i < groups.length; ++i) {
                currentGroup = groups[i];
                groupDisabled = groupsDisabled[i];
                int queueSize = Integer.parseInt(queueSizes[i]);
                resultUser = new CurrentUser(null, queueSize);
                if (groupManager.isUserInGroup(user, currentGroup)) {
                    resultUser = new CurrentUser(user, 0);
                    continue;
                }
                if (!groupManager.isUserInGroup(user, groupDisabled)) continue;
                Group theGroup = groupManager.getGroup(currentGroup);
                Group theGroupDisabled = groupManager.getGroup(groupDisabled);
                int noOfUsers = groupManager.getUsersInGroup(theGroup).size();
                if (noOfUsers == 0) {
                    groupManager.addUserToGroup(user, theGroup);
                    userUtil.removeUserFromGroup(theGroupDisabled, user);
                    resultUser = new CurrentUser(user, 0);
                    continue;
                }
                if (queueSize != 0 && noOfUsers >= queueSize && UserManagementServiceImpl.disableOldestUser(theGroup, theGroupDisabled, user).getUser().getKey() == user.getKey()) continue;
                groupManager.addUserToGroup(user, theGroup);
                userUtil.removeUserFromGroup(theGroupDisabled, user);
                resultUser = new CurrentUser(user, 0);
            }
            return resultUser;
        }
        catch (Exception e) {
            log.warn("Error parsing groups " + currentGroup + ":" + e.getMessage());
            return new CurrentUser(null, 0);
        }
    }

    public static UserDto getOldestUser(Group group, ApplicationUser appUser) {
        Collection users = groupManager.getUsersInGroup(group);
        long oldestTS = 4120528639000L;
        ApplicationUser oldestUser = null;
        for (ApplicationUser user : users) {
            long lastTS;
            if (user.getUsername().equals(appUser.getUsername()) || !user.isActive() || (lastTS = UserManagementServiceImpl.getLastViewByUser(user)) >= oldestTS) continue;
            if (lastTS == 0L) {
                return new UserDto(user, 0L);
            }
            oldestTS = lastTS;
            oldestUser = user;
        }
        if (oldestUser == null) {
            log.warn("ACCXIA IUM Oldest User " + oldestUser.getUsername());
        }
        return new UserDto(oldestUser, oldestTS);
    }

    public static UserDto disableOldestUser(Group group, Group groupDisabled, ApplicationUser user) {
        UserDto userDto = UserManagementServiceImpl.getOldestUser(group, user);
        if (userDto != null && userDto.getUser() != null) {
            long now = new Timestamp(System.currentTimeMillis()).getTime();
            long diff = now - userDto.getTs();
            long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
            if (userDto.getTs() == 0L || duration == 0L || diff > duration) {
                UserManagementServiceImpl.disableUserFromGroup(userDto.getUser(), group, groupDisabled, true);
                return userDto;
            }
        }
        return new UserDto(user, 0L);
    }

    public static String getLastViewedForUsersInGroup() {
        List<String> group = Arrays.asList(DAO.getIUMGroups());
        SortedSet users = userUtil.getAllUsersInGroupNames(group);
        StringBuffer res = new StringBuffer();
        for (ApplicationUser user : users) {
            res.append("Login Test:").append(user.getUsername()).append(":").append(UserManagementServiceImpl.getLastViewByUser(user)).append("\n");
        }
        return res.toString();
    }

    private static Long getLongTimestampForIssueAndUser(ApplicationUser user, Long id) {
        List fullHistory = historyManager.getFullIssueHistoryWithoutPermissionChecks(user);
        for (UserHistoryItem historyItem : fullHistory) {
            if (!id.toString().equals(historyItem.getEntityId())) continue;
            return historyItem.getLastViewed();
        }
        return null;
    }

    public static long getLastLoginFromUser(ApplicationUser user) {
        UserWithAttributes theUser = crowdService.getUserWithAttributes(user.getName());
        String lastLoginMillisStr = theUser.getValue("login.lastLoginMillis");
        return UserManagementServiceImpl.getLong(lastLoginMillisStr);
    }

    public static long getLastViewByUser(ApplicationUser user) {
        Issue userCurrentIssue;
        long lastLogin = UserManagementServiceImpl.getLastLoginFromUser(user);
        List theHistory = historyManager.getShortIssueHistory(user);
        Long lastViewed = theHistory.size() == 0 ? Long.valueOf(0L) : ((userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0)) == null ? Long.valueOf(0L) : UserManagementServiceImpl.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId()));
        if (lastViewed > lastLogin) {
            return lastViewed;
        }
        return lastLogin;
    }

    public static long getlastViewByUserPld(ApplicationUser user) {
        List theHistory = historyManager.getShortIssueHistory(user);
        if (theHistory.size() == 0) {
            return 0L;
        }
        Issue userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0);
        if (userCurrentIssue == null) {
            return 0L;
        }
        Long lastViewed = UserManagementServiceImpl.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId());
        return lastViewed;
    }

    private static List<ApplicationUser> getAllUsers() {
        UserSearchParams userSearchParams = new UserSearchParams.Builder().allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(Integer.valueOf(100000)).build();
        return userSearchService.findUsers("", userSearchParams);
    }

    public static List<UserDto> getSortedUserList(int max) {
        List<ApplicationUser> allUsers = UserManagementServiceImpl.getAllUsers();
        ArrayList<UserDto> userList = new ArrayList<UserDto>();
        for (ApplicationUser user : allUsers) {
            long ts = UserManagementServiceImpl.getLastViewByUser(user);
            UserDto oUser = new UserDto(user, ts);
            userList.add(oUser);
        }
        Collections.sort(userList, Comparator.comparing(UserDto::getTs));
        int count = 0;
        for (UserDto o : userList) {
            if (max > 0 && count >= max) {
                userList.remove(count);
            }
            ++count;
        }
        return userList;
    }

    public List<UserDto> getAllSortedUserListFromGroup(String group, String filterGroup) {
        return this.getSortedUserListFromGroup(group, Integer.MAX_VALUE, filterGroup);
    }

    public List<UserDto> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        Collection theUsers;
        Collection allUsers = groupManager.getUserNamesInGroup(group);
        Collection filterUsers = groupManager.getUserNamesInGroup(filtergroup);
        ArrayList<UserDto> userList = new ArrayList<UserDto>();
        int numAll = 0;
        int numFilter = 0;
        if (allUsers == null) {
            return userList;
        }
        if ("".equals(filtergroup)) {
            theUsers = allUsers;
        } else {
            numAll = allUsers.size();
            if (filterUsers != null) {
                numFilter = filterUsers.size();
            }
            if (numFilter == 0 || numAll == 0) {
                return userList;
            }
            theUsers = numFilter > numAll ? groupManager.filterUsersInAllGroupsDirect(allUsers, Collections.singletonList(filtergroup)) : groupManager.filterUsersInAllGroupsDirect(filterUsers, Collections.singletonList(group));
        }
        ArrayList<UserDto> tmpUserList = new ArrayList<UserDto>();
        for (String userName : theUsers) {
            ApplicationUser user = userManagerJira.getUserByName(userName);
            if (!user.isActive()) continue;
            long ts = UserManagementServiceImpl.getLastViewByUser(user);
            UserDto oUser = new UserDto(user, ts);
            tmpUserList.add(oUser);
        }
        Collections.sort(tmpUserList, Comparator.comparing(UserDto::getTs));
        int count = 0;
        for (UserDto o : tmpUserList) {
            if (max == 0 || count < max) {
                userList.add(o);
            }
            ++count;
        }
        return userList;
    }

    public static void moveUserToDisabled(ApplicationUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!groupManager.isUserInGroup(user, groups[i])) continue;
            Group theGroup = groupManager.getGroup(groups[i]);
            Group thetoGroup = groupManager.getGroup(groupsDisabled[i]);
            if (theGroup == null || thetoGroup == null) continue;
            UserManagementServiceImpl.disableUserFromGroup(user, theGroup, thetoGroup, true);
        }
    }
}

