/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Maps;
import de.accxia.jira.addon.IUM.config.DAO;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LicenseServlet.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @ComponentImport
    private final WebSudoManager webSudoManager;

    public LicenseServlet(PluginLicenseManager pluginLicenseManager, TemplateRenderer templateRenderer, WebSudoManager webSudoManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.templateRenderer = templateRenderer;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.webSudoManager.willExecuteWebSudoRequest(request);
        String jiraLicense = "";
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            jiraLicense = ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getRawLicense();
        }
        HashMap attributes = Maps.newHashMap();
        attributes.put("sideLicense", DAO.getSideLicense());
        attributes.put("jiraLicense", jiraLicense);
        attributes.put("showSideLicense", !DAO.getSideLicense().isEmpty());
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("templates/license_entry_page.vm", (Map)attributes, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = this.getParameter(request, "licenseType").toLowerCase();
        super.doPost(request, response);
    }

    private String getParameter(HttpServletRequest request, String parameter) {
        return request.getParameter(parameter) != null ? request.getParameter(parameter) : "";
    }
}

