/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Scanned
@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
public class IUMListener
implements InitializingBean,
DisposableBean {
    @ComponentImport
    private final EventPublisher eventPublisher;

    @Inject
    public IUMListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        ApplicationUser user;
        if (ConditionEvaluatorImpl.isLicenseValid() && (user = logoutEvent.getUser()) != null) {
            IntelligentUserManagerHelper.moveUserToDisabled(user);
        }
    }
}

