/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IntelligentUserManagerManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623574103725530973L;
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerManagementServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private String fromgroup = null;
    private String togroup = null;
    private String filtergroup = null;
    private String noof = null;

    @Inject
    public IntelligentUserManagerManagementServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, WebSudoManager webSudoManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.webSudoManager = webSudoManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String action = request.getParameter("action");
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, false);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ("list".equals(action)) {
                String fromGroup = "";
                if (request.getParameter("fromgroup") != null) {
                    fromGroup = request.getParameter("fromgroup");
                }
                String toGroup = "";
                if (request.getParameter("togroup") != null) {
                    toGroup = request.getParameter("togroup");
                }
                String filterGroup = "";
                if (request.getParameter("filtergroup") != null) {
                    filterGroup = request.getParameter("filtergroup");
                }
                int noof = 10;
                try {
                    if (request.getParameter("noof") != null) {
                        noof = Integer.parseInt(request.getParameter("noof"));
                    }
                }
                catch (Exception e) {
                    noof = 10;
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.togroup = this.setValue("togroup", toGroup);
                this.filtergroup = this.setValue("filtergroup", filterGroup);
                this.noof = this.setValue("noof", "" + noof);
                List<OldestUser> users = IntelligentUserManagerHelper.getSortedUserListFromGroup(this.fromgroup, noof, this.filtergroup);
                map.put("fromgroup", fromGroup);
                map.put("togroup", toGroup);
                map.put("filtergroup", filterGroup);
                map.put("noof", this.getValue("noof", "" + noof));
                map.put("users", users);
                this.renderUserVM(response, map);
                return;
            }
            if ("move".equals(action) || "copy".equals(action)) {
                String[] selectedUsers = null;
                String fromGroup = "";
                if (request.getParameter("fromgroup") != null) {
                    fromGroup = request.getParameter("fromgroup");
                }
                String toGroup = "";
                if (request.getParameter("togroup") != null) {
                    toGroup = request.getParameter("togroup");
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.togroup = this.setValue("togroup", toGroup);
                String res = "";
                if (request.getParameter("selUser") != null) {
                    selectedUsers = request.getParameterValues("selUser");
                    res = IntelligentUserManagerHelper.moveUsersInListFromGroupToGroup(selectedUsers, fromGroup, toGroup, "move".equals(action));
                }
                map.put("fromgroup", this.getValue("fromgroup", fromGroup));
                map.put("togroup", this.getValue("togroup", toGroup));
                map.put("noof", this.getValue("noof", this.noof));
                map.put("message", res);
                this.renderUserVM(response, map);
                return;
            }
            this.renderUserVM(response, map);
        }
        catch (WebSudoSessionException wes) {
            response.sendError(403);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            boolean bl = showSideLicense = request.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(response);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                if (request.getParameter("oldest") != null) {
                    UserKey currentUserKey = this.userManager.getRemoteUserKey();
                    ApplicationUser currentUser = userUtil.getUserByKey(currentUserKey.getStringValue());
                    String theGroup = this.getValue("fromgroup", null);
                    Group testGroup = groupManager.getGroup(theGroup);
                    OldestUser oldestUser = IntelligentUserManagerHelper.getOldestUser(testGroup, currentUser);
                    response.setContentType("text/plain");
                    long lastLogin = IntelligentUserManagerHelper.getLastLoginFromUser(currentUser);
                    if (oldestUser != null && oldestUser.getUser() != null) {
                        response.getWriter().write("Oldest User for Group " + theGroup + " =" + oldestUser.getUser().getUsername() + " last login was " + lastLogin + " oldestTs=" + oldestUser.getTs());
                    } else {
                        response.getWriter().write("No Oldest User found for Group " + theGroup);
                    }
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fromgroup", this.getValue("fromgroup", this.fromgroup));
                map.put("togroup", this.getValue("togroup", this.togroup));
                map.put("filtergroup", this.getValue("filtergroup", this.filtergroup));
                map.put("noof", this.getValue("noof", this.noof));
                this.renderUserVM(response, map);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderUserVM(HttpServletResponse response, Map<String, Object> context) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/user_IUM.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap context = new HashMap();
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValue(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }
}

