/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IntelligentUserManagerServletFilter2
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerServletFilter2.class);
    @ComponentImport
    private static PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private static ApplicationProperties applicationProperties;
    @ComponentImport
    private static TemplateRenderer renderer;
    private final JiraAuthenticationContext jiraAuthContext = ComponentAccessor.getJiraAuthenticationContext();
    private final String jiraServerAddress = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");

    @Inject
    public IntelligentUserManagerServletFilter2(PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties, TemplateRenderer renderer) {
        IntelligentUserManagerServletFilter2.pluginLicenseManager = pluginLicenseManager;
        IntelligentUserManagerServletFilter2.applicationProperties = applicationProperties;
        IntelligentUserManagerServletFilter2.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser user = this.jiraAuthContext.getLoggedInUser();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
            chain.doFilter(request, response);
            return;
        }
        if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (!IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            chain.doFilter(request, response);
            return;
        }
        if (user.getName().equals(httpRequest.getSession().getAttribute("IUMUSER"))) {
            IntelligentUserManagerHelper.logOutUser(user, httpRequest, this.jiraAuthContext);
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/secure/Dashboard.jspa");
            return;
        }
        CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user.getName(), httpRequest);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.user;
            if (theUser != null) {
                httpRequest.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                httpResponse.sendRedirect(this.jiraServerAddress);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("isServiceDesk", "yes");
        response.setContentType("text/html;charset=utf-8");
        renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

