/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.impl;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.ImmutableSet;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelligentUserManagerHelper {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerHelper.class);
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private static final GlobalPermissionManager permissionManager = ComponentAccessor.getGlobalPermissionManager();
    private static final UserIssueHistoryManager historyManager = (UserIssueHistoryManager)ComponentAccessor.getComponent(UserIssueHistoryManager.class);
    private static final UserSearchService userSearchService = (UserSearchService)ComponentAccessor.getComponent(UserSearchService.class);
    private static CrowdService crowdService = ComponentAccessor.getCrowdService();
    private static HashMap<String, Long> ourUsers = new HashMap();

    public static void logOutUser(ApplicationUser theUser, HttpServletRequest request, JiraAuthenticationContext jiraAuthContext) {
        log.warn("ACCXIATEST Loggingout user " + theUser.getName());
        request.getSession().setAttribute("seraph_defaultauthenticator_user", null);
        request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", (Object)theUser);
        jiraAuthContext.clearLoggedInUser();
    }

    public static long getUserTS(String user) {
        return ourUsers.getOrDefault(user, 0L);
    }

    public static void setUserTS(String user, Long ts) {
        ourUsers.put(user, ts);
    }

    public static String listUsers() {
        StringBuffer res = new StringBuffer();
        for (String key : ourUsers.keySet()) {
            res.append("\n" + key + ":" + IntelligentUserManagerHelper.getUserTS(key));
        }
        return res.toString();
    }

    public static boolean isUserInGroups(ApplicationUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        for (String group : groups.split(",")) {
            if (!groupManager.isUserInGroup(currentUser, group)) continue;
            return true;
        }
        return false;
    }

    public static long getLong(String str) {
        long d = 0L;
        try {
            d = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        return d;
    }

    public static String moveUserFromGroupToGroup(ApplicationUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = groupManager.getGroup(group);
            Group thetoGroup = groupManager.getGroup(toGroup);
            IntelligentUserManagerHelper.disableUserFromGroup(user, theGroup, thetoGroup, move);
            theLog.append(user.getUsername() + "=>" + thetoGroup.getName() + "</br>\n");
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ApplicationUser user = userManagerJira.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(IntelligentUserManagerHelper.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (ApplicationUser it : groupManager.getUsersInGroup(group)) {
                ++totalRemoved;
                theLog.append(IntelligentUserManagerHelper.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(IntelligentUserManagerHelper.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void disableUserFromGroup(ApplicationUser user, Group group, Group groupDisabled, boolean move) {
        if (groupManager.isUserInGroup(user, group)) {
            try {
                userUtil.addUserToGroup(groupDisabled, user);
                if (move) {
                    userUtil.removeUserFromGroup(group, user);
                }
            }
            catch (AddException | PermissionException | RemoveException throwable) {
                // empty catch block
            }
        }
    }

    public static CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ApplicationUser user = userManagerJira.getUserByName(userName);
        return IntelligentUserManagerHelper.enableUserFromGroup(user, request);
    }

    public static CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request) {
        String currentGroup = "";
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] groups = null;
            String[] groupsDisabled = null;
            String[] queueSizes = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            if (queueSizeTxt != null) {
                queueSizes = queueSizeTxt.split(",");
            }
            CurrentUser resultUser = null;
            for (int i = 0; i < groups.length; ++i) {
                currentGroup = groups[i];
                groupDisabled = groupsDisabled[i];
                int queueSize = Integer.parseInt(queueSizes[i]);
                resultUser = new CurrentUser(null, queueSize);
                if (groupManager.isUserInGroup(user, currentGroup)) {
                    resultUser = new CurrentUser(user, 0);
                    continue;
                }
                if (!groupManager.isUserInGroup(user, groupDisabled)) continue;
                Group theGroup = groupManager.getGroup(currentGroup);
                Group theGroupDisabled = groupManager.getGroup(groupDisabled);
                int noOfUsers = groupManager.getUsersInGroup(theGroup).size();
                if (noOfUsers == 0) {
                    groupManager.addUserToGroup(user, theGroup);
                    userUtil.removeUserFromGroup(theGroupDisabled, user);
                    resultUser = new CurrentUser(user, 0);
                    continue;
                }
                if (queueSize != 0 && noOfUsers >= queueSize && IntelligentUserManagerHelper.disableOldestUser((Group)theGroup, (Group)theGroupDisabled, (ApplicationUser)user).user.getKey() == user.getKey()) continue;
                groupManager.addUserToGroup(user, theGroup);
                userUtil.removeUserFromGroup(theGroupDisabled, user);
                resultUser = new CurrentUser(user, 0);
            }
            return resultUser;
        }
        catch (Exception e) {
            log.warn("Error parsing groups " + currentGroup + ":" + e.getMessage());
            return new CurrentUser(null, 0);
        }
    }

    public static OldestUser getOldestUser(Group group, ApplicationUser appUser) {
        Collection users = groupManager.getUsersInGroup(group);
        long oldestTS = 4120528639000L;
        ApplicationUser oldestUser = null;
        for (ApplicationUser user : users) {
            long lastTS;
            if (user.getUsername().equals(appUser.getUsername()) || !user.isActive() || (lastTS = IntelligentUserManagerHelper.getlastViewByUser(user)) >= oldestTS) continue;
            if (lastTS == 0L) {
                return new OldestUser(user, 0L);
            }
            oldestTS = lastTS;
            oldestUser = user;
        }
        if (oldestUser == null) {
            log.warn("ACCXIA IUM Oldest User " + oldestUser.getUsername());
        }
        return new OldestUser(oldestUser, oldestTS);
    }

    public static OldestUser disableOldestUser(Group group, Group groupDisabled, ApplicationUser user) {
        OldestUser oldestUser = IntelligentUserManagerHelper.getOldestUser(group, user);
        if (oldestUser != null && oldestUser.user != null) {
            long now = new Timestamp(System.currentTimeMillis()).getTime();
            long diff = now - oldestUser.ts;
            long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
            if (oldestUser.ts == 0L || duration == 0L || diff > duration) {
                IntelligentUserManagerHelper.disableUserFromGroup(oldestUser.user, group, groupDisabled, true);
                return oldestUser;
            }
        }
        return new OldestUser(user, 0L);
    }

    public static String getLastViewedForUsersInGroup() {
        List<String> group = Arrays.asList(DAO.getIUMGroups());
        SortedSet users = userUtil.getAllUsersInGroupNames(group);
        StringBuffer res = new StringBuffer();
        for (ApplicationUser user : users) {
            res.append("Login Test:" + user.getUsername() + ":" + IntelligentUserManagerHelper.getlastViewByUser(user) + "\n");
        }
        return res.toString();
    }

    private static Long getLongTimestampForIssueAndUser(ApplicationUser user, Long id) {
        List fullHistory = historyManager.getFullIssueHistoryWithoutPermissionChecks(user);
        for (UserHistoryItem historyItem : fullHistory) {
            if (!id.toString().equals(historyItem.getEntityId())) continue;
            return historyItem.getLastViewed();
        }
        return null;
    }

    public static long getLastLoginFromUser(ApplicationUser user) {
        UserWithAttributes theUser = crowdService.getUserWithAttributes(user.getName());
        String lastLoginMillisStr = theUser.getValue("login.lastLoginMillis");
        return IntelligentUserManagerHelper.getLong(lastLoginMillisStr);
    }

    public static long getlastViewByUser(ApplicationUser user) {
        Issue userCurrentIssue;
        List theHistory;
        Long lastViewed = 0L;
        long lastLogin = IntelligentUserManagerHelper.getUserTS(user.getName());
        if (lastLogin == 0L) {
            lastLogin = IntelligentUserManagerHelper.getLastLoginFromUser(user);
        }
        if ((lastViewed = (theHistory = historyManager.getShortIssueHistory(user)).size() == 0 ? Long.valueOf(0L) : ((userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0)) == null ? Long.valueOf(0L) : IntelligentUserManagerHelper.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId()))) > lastLogin) {
            return lastViewed;
        }
        return lastLogin;
    }

    public static long getlastViewByUserPld(ApplicationUser user) {
        List theHistory = historyManager.getShortIssueHistory(user);
        if (theHistory.size() == 0) {
            return 0L;
        }
        Issue userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0);
        if (userCurrentIssue == null) {
            return 0L;
        }
        Long lastViewed = IntelligentUserManagerHelper.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId());
        return lastViewed;
    }

    private static List<ApplicationUser> getAllUsers() {
        UserSearchParams userSearchParams = new UserSearchParams.Builder().allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(Integer.valueOf(100000)).build();
        return userSearchService.findUsers("", userSearchParams);
    }

    public static List<OldestUser> getSortedUserList(int max) {
        List<ApplicationUser> allUsers = IntelligentUserManagerHelper.getAllUsers();
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        for (ApplicationUser user : allUsers) {
            long ts = IntelligentUserManagerHelper.getlastViewByUser(user);
            OldestUser oUser = new OldestUser(user, ts);
            userList.add(oUser);
        }
        Collections.sort(userList, new Comparator<OldestUser>(){

            @Override
            public int compare(OldestUser o1, OldestUser o2) {
                return o1.ts.compareTo(o2.ts);
            }
        });
        int count = 0;
        for (OldestUser o : userList) {
            if (max > 0 && count >= max) {
                userList.remove(count);
            }
            ++count;
        }
        return userList;
    }

    public static List<OldestUser> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        Collection theUsers;
        Collection allUsers = groupManager.getUserNamesInGroup(group);
        Collection filterUsers = groupManager.getUserNamesInGroup(filtergroup);
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        int numAll = 0;
        int numFilter = 0;
        if (allUsers == null) {
            return userList;
        }
        if ("".equals(filtergroup)) {
            theUsers = allUsers;
        } else {
            numAll = allUsers.size();
            if (filterUsers != null) {
                numFilter = filterUsers.size();
            }
            if (numFilter == 0 || numAll == 0) {
                return userList;
            }
            theUsers = numAll > 0 && numFilter > numAll ? groupManager.filterUsersInAllGroupsDirect(allUsers, Arrays.asList(filtergroup)) : groupManager.filterUsersInAllGroupsDirect(filterUsers, Arrays.asList(group));
        }
        ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
        for (String userName : theUsers) {
            ApplicationUser user = userManagerJira.getUserByName(userName);
            if (!user.isActive()) continue;
            long ts = IntelligentUserManagerHelper.getlastViewByUser(user);
            OldestUser oUser = new OldestUser(user, ts);
            tmpUserList.add(oUser);
        }
        Collections.sort(tmpUserList, new Comparator<OldestUser>(){

            @Override
            public int compare(OldestUser o1, OldestUser o2) {
                return o1.ts.compareTo(o2.ts);
            }
        });
        int count = 0;
        for (OldestUser o : tmpUserList) {
            if (max == 0 || count < max) {
                userList.add(o);
            }
            ++count;
        }
        return userList;
    }

    public static void moveUserToDisabled(ApplicationUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!groupManager.isUserInGroup(user, groups[i])) continue;
            Group theGroup = groupManager.getGroup(groups[i]);
            Group thetoGroup = groupManager.getGroup(groupsDisabled[i]);
            if (theGroup == null || thetoGroup == null) continue;
            IntelligentUserManagerHelper.disableUserFromGroup(user, theGroup, thetoGroup, true);
        }
    }

    public static boolean simulateUserToEnabledGroup(ApplicationUser user) {
        String groupEnabled = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        if (groupEnabled == null || groupDisabled == null) {
            return false;
        }
        String[] groupsEnabled = groupEnabled.split(",");
        String[] groupsDisabled = groupDisabled.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (!groupManager.isUserInGroup(user, groupsDisabled[i])) continue;
            Group theEnabledGroup = groupManager.getGroup(groupsEnabled[i]);
            Group theDisableGroup = groupManager.getGroup(groupsDisabled[i]);
            Field field = null;
            try {
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroups", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroups = (RequestCache)field.get(groupManager);
                ImmutableSet grp1 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroups.get((Object)user.getUsername())).add((Object)theEnabledGroup).build();
                usernameToGroups.remove((Object)user.getUsername());
                usernameToGroups.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$0((Set)grp1));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNames", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNames = (RequestCache)field.get(groupManager);
                ImmutableSet grp2 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNames.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName()).build();
                usernameToGroupNames.remove((Object)user.getUsername());
                usernameToGroupNames.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$1((Set)grp2));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNamesInLowerCase", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNamesInLowerCase = (RequestCache)field.get(groupManager);
                ImmutableSet grp3 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNamesInLowerCase.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName().toLowerCase()).build();
                usernameToGroupNamesInLowerCase.remove((Object)user.getUsername());
                usernameToGroupNamesInLowerCase.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$2((Set)grp3));
            }
            catch (IllegalAccessException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
            log.info("Move " + user.getUsername() + " IUM_Enabled -->" + IntelligentUserManagerHelper.isUserInGroups(user, "IUM_Enabled"));
            log.info("Move " + user.getUsername() + " IUM_Disabled -->" + IntelligentUserManagerHelper.isUserInGroups(user, "IUM_Disabled"));
            return true;
        }
        return false;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$2(Set grp3) {
        return grp3;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$1(Set grp2) {
        return grp2;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$0(Set grp1) {
        return grp1;
    }
}

