/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import com.atlassian.audit.entity.EffectiveCoverageLevel;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class IntelligentUserManagerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623574103725530973L;
    public static final String AUDIT_USER_MANAGEMENT = "com.atlassian.audit.plugin:audit-config:coverage:user_management";
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    private String IUMGroup = null;
    private String IUMGroupDIS = null;
    private String duration = null;
    private String queueSize = null;
    private String sideLicense = null;
    private String samlIdp = null;
    private String samlMapping = null;
    private String audit = null;
    private String urlLogo = null;

    @Inject
    public IntelligentUserManagerConfigServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, WebSudoManager webSudoManager, JiraAuthenticationContext jiraAuthenticationContext, PluginSettingsFactory pluginSettingsFactory) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.webSudoManager = webSudoManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String save = request.getParameter("Save");
            String action = request.getParameter("action");
            boolean bl = showSideLicense = request.getParameter("sl") != null;
            if (showSideLicense) {
                String sideLicense = request.getParameter("sideLicense");
                if (sideLicense == null || "".equals(sideLicense)) {
                    this.deleteSideLicense();
                    ConditionEvaluatorImpl.deleteSideLicense();
                }
                DAO.updateSideLicense(sideLicense);
                this.setSideLicense(sideLicense);
                ConditionEvaluatorImpl.setSideLicense();
                this.renderSideLicenseVM(response);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                if ("remove".equals(action)) {
                    String res = IntelligentUserManagerHelper.disabelAllUsersFromTheEnabledGroups(request.getParameter("groupName"));
                    this.renderAdminVM(response, res, showSideLicense);
                    return;
                }
                if ("saml".equals(action)) {
                    String samlIdp = "";
                    if (request.getParameterValues("samlIdp") != null) {
                        samlIdp = request.getParameter("samlIdp");
                    }
                    this.samlIdp = this.setValue("samlIdp", samlIdp);
                    String samlMapping = "";
                    if (request.getParameterValues("samlMapping") != null) {
                        samlMapping = request.getParameter("samlMapping");
                    }
                    this.samlMapping = this.setValue("samlMapping", samlMapping);
                    this.renderSamlVM(response, "");
                    return;
                }
                if (this.getI18nSave().equals(save)) {
                    String reportGroups = "";
                    if (request.getParameterValues("IUMGroup") != null) {
                        reportGroups = String.join((CharSequence)",", request.getParameterValues("IUMGroup"));
                    }
                    String reportGroupsDIS = "";
                    if (request.getParameterValues("IUMGroupDIS") != null) {
                        reportGroupsDIS = String.join((CharSequence)",", request.getParameterValues("IUMGroupDIS"));
                    }
                    String queueSize = "10";
                    if (request.getParameterValues("queueSize") != null) {
                        queueSize = String.join((CharSequence)",", request.getParameterValues("queueSize"));
                    }
                    this.IUMGroup = this.setValue("IUMGroup", reportGroups);
                    this.IUMGroupDIS = this.setValue("IUMGroupDIS", reportGroupsDIS);
                    this.queueSize = this.setValue("queueSize", queueSize);
                    this.duration = request.getParameter("duration");
                    this.duration = this.setValue("duration", this.duration);
                    this.audit = request.getParameter("audit");
                    if (this.audit != null && "on".equalsIgnoreCase(this.audit)) {
                        this.setAuditUserManagement(EffectiveCoverageLevel.BASE);
                    } else {
                        this.setAuditUserManagement(EffectiveCoverageLevel.OFF);
                    }
                    this.urlLogo = request.getParameter("urlLogo");
                    this.urlLogo = this.setValue("urlLogo", this.urlLogo);
                }
                this.renderAdminVM(response, "", showSideLicense);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String action = request.getParameter("action");
            boolean bl = showSideLicense = request.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(response);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                if ("saml".equals(action)) {
                    this.renderSamlVM(response, "");
                    return;
                }
                this.renderAdminVM(response, "", showSideLicense);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, String message, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String wvg = this.getValue("IUMGroup", this.IUMGroup);
        context.put("IUMGroupArray", wvg.isEmpty() ? "" : wvg.split(","));
        wvg = this.getValue("IUMGroupDIS", this.IUMGroupDIS);
        context.put("IUMGroupDISArray", wvg.isEmpty() ? "" : wvg.split(","));
        context.put("showSideLicense", showSideLicense);
        wvg = this.getValue("queueSize", this.queueSize);
        context.put("queueSizeArray", wvg.isEmpty() ? "" : wvg.split(","));
        this.duration = this.getValue("duration", this.duration);
        context.put("duration", this.duration.isEmpty() ? "24" : this.duration);
        context.put("message", message);
        if (ConditionEvaluatorImpl.getSideLicense() != null) {
            context.put("enhanced", ConditionEvaluatorImpl.getSideLicense().getAppKey().contains("Enhanced"));
        }
        context.put("audit", EffectiveCoverageLevel.OFF.getKey().equalsIgnoreCase(this.getAuditUserManagement()) ? Boolean.FALSE : Boolean.TRUE);
        this.urlLogo = this.getValue("urlLogo", this.urlLogo);
        context.put("urlLogo", this.urlLogo.isEmpty() ? "" : this.urlLogo);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/admin_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderSamlVM(HttpServletResponse response, String message) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        this.samlIdp = DAO.getSamlIdp();
        this.samlMapping = DAO.getSamlMapping();
        context.put("samlIdp", this.samlIdp);
        context.put("samlMapping", this.samlMapping);
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private String getI18nSave() {
        try {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            I18nHelper instance = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            return instance.getText("common.words.save");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", this.getSideLicense());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValue(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }

    public String getSideLicense() {
        if (this.sideLicense == null || this.sideLicense.isEmpty()) {
            this.sideLicense = DAO.getSideLicense();
        }
        return this.sideLicense;
    }

    public void setSideLicense(String sideLicense) {
        this.sideLicense = sideLicense;
    }

    public void deleteSideLicense() {
        this.sideLicense = "";
    }

    private String getAuditUserManagement() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)settings.get(AUDIT_USER_MANAGEMENT);
    }

    private void setAuditUserManagement(EffectiveCoverageLevel effectiveCoverageLevel) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(AUDIT_USER_MANAGEMENT, (Object)effectiveCoverageLevel.getKey());
    }
}

