/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    @ComponentImport
    private static PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private static ApplicationProperties applicationProperties;
    @ComponentImport
    private static TemplateRenderer renderer;
    private static com.atlassian.sal.api.user.UserManager userManager;
    private static UserManager userManagerJira;
    private static UserUtil userUtil;
    private static JiraAuthenticationContext jiraAuthenticationContext;
    private static AuthenticationContext authenticationContext;

    @Inject
    public IntelligentUserManagerCerberosFilter(PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties, TemplateRenderer renderer) {
        IntelligentUserManagerCerberosFilter.pluginLicenseManager = pluginLicenseManager;
        IntelligentUserManagerCerberosFilter.applicationProperties = applicationProperties;
        IntelligentUserManagerCerberosFilter.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (!jiraAuthenticationContext.isLoggedInUser()) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
        if (user != null && user.isActive()) {
            if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (!IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, httpRequest);
            if (currentUser != null && currentUser.user != null) {
                IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
                httpRequest.getSession().setAttribute("IUMUSER", (Object)user.getUsername());
                chain.doFilter(request, response);
                return;
            }
            if (httpRequest.getServletPath() != null && httpRequest.getServletPath().contains("/servicedesk") && "POST".equalsIgnoreCase(httpRequest.getMethod())) {
                chain.doFilter(request, response);
            } else {
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void renderLoginVM(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("os_username");
        String pass = request.getParameter("os_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        response.setContentType("text/html;charset=utf-8");
        renderer.render("templates/login_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean isServiceDesk = request.getServletPath() != null && request.getServletPath().contains("/servicedesk") ? Boolean.TRUE : Boolean.FALSE;
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (isServiceDesk != null && isServiceDesk.booleanValue()) {
            context.put("isServiceDesk", "YES");
            context.put("redirUrl", "/servicedesk/");
        } else {
            context.put("redirUrl", "/secure/Dashboard.jspa");
        }
        context.put("queueSize", noOfUsers);
        context.put("duration", DAO.getDuration());
        context.put("urlLogo", DAO.getUrlLogo());
        response.setContentType("text/html;charset=utf-8");
        renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    static {
        userManager = (com.atlassian.sal.api.user.UserManager)ComponentAccessor.getOSGiComponentInstanceOfType(com.atlassian.sal.api.user.UserManager.class);
        userManagerJira = ComponentAccessor.getUserManager();
        userUtil = ComponentAccessor.getUserUtil();
        jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        authenticationContext = (AuthenticationContext)ComponentAccessor.getComponent(AuthenticationContext.class);
    }
}

