/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.JiraMultipartRequestWrapper;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.servlet.filter.ResettableStreamHttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.Configuration;

public class IUMAssignIssueFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMAssignIssueFilter.class);
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
            String[] unames = null;
            if (request.getContentType() != null && request.getContentType().indexOf("multipart/form-data") != -1) {
                ResettableStreamHttpServletRequest resettableStreamHttpServletRequest = new ResettableStreamHttpServletRequest((HttpServletRequest)httpRequest);
                String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
                JiraMultipartRequestWrapper jiraMultipartRequestWrapper = new JiraMultipartRequestWrapper((HttpServletRequest)resettableStreamHttpServletRequest, ((File)request.getServletContext().getAttribute("javax.servlet.context.tempdir")).getAbsolutePath(), Integer.parseInt(maxSizeStr));
                resettableStreamHttpServletRequest.resetInputStream();
                unames = jiraMultipartRequestWrapper.getParameterValues("assignee");
                LOG.info(unames != null ? unames.toString() : "");
                httpRequest = resettableStreamHttpServletRequest;
                request = httpRequest;
            } else {
                unames = request.getParameterValues("assignee");
            }
            if (unames == null || unames.length == 0) {
                chain.doFilter(request, response);
                return;
            }
            ApplicationUser user = userManagerJira.getUserByName(unames[0]);
            if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (!IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                try {
                    boolean success = IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
                    LOG.info("Simulation " + user.getUsername() + " " + success);
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
                chain.doFilter(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

