/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import com.atlassian.audit.entity.EffectiveCoverageLevel;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.config.RestRoute;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class IntelligentUserManagerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623574103725530973L;
    public static final String AUDIT_USER_MANAGEMENT = "com.atlassian.audit.plugin:audit-config:coverage:user_management";
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    private String IUMGroup = null;
    private String IUMGroupDIS = null;
    private String duration = null;
    private String queueSize = null;
    private String sideLicense = null;
    private String samlIdp = null;
    private String samlMapping = null;
    private String audit = null;
    private String urlLogo = null;
    private String urlRest = null;

    @Inject
    public IntelligentUserManagerConfigServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, WebSudoManager webSudoManager, JiraAuthenticationContext jiraAuthenticationContext, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.webSudoManager = webSudoManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.applicationProperties = applicationProperties;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRequest, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRequest);
            String pageId = xssRequest.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                String sideLicense = xssRequest.getParameter("sideLicense");
                if (sideLicense == null || "".equals(sideLicense)) {
                    this.deleteSideLicense();
                    ConditionEvaluatorImpl.deleteSideLicense();
                }
                DAO.updateSideLicense(sideLicense);
                this.setSideLicense(sideLicense);
                ConditionEvaluatorImpl.setSideLicense();
                this.renderSideLicenseVM(response);
            } else {
                boolean showSideLicense;
                boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                String save = xssRequest.getParameter("Save");
                String action = xssRequest.getParameter("action");
                if ("remove".equals(action)) {
                    String res = IntelligentUserManagerHelper.disabelAllUsersFromTheEnabledGroups(xssRequest.getParameter("groupName"));
                    this.renderAdminVM(response, res, Page.PageUserManagement, showSideLicense);
                    return;
                }
                switch (page) {
                    case PageSAMLSSO: {
                        String samlIdp = "";
                        if (xssRequest.getParameterValues("samlIdp") != null) {
                            samlIdp = xssRequest.getParameter("samlIdp");
                        }
                        this.samlIdp = this.setValue("samlIdp", samlIdp);
                        String samlMapping = "";
                        if (xssRequest.getParameterValues("samlMapping") != null) {
                            samlMapping = xssRequest.getParameter("samlMapping");
                        }
                        this.samlMapping = this.setValue("samlMapping", samlMapping);
                        this.renderSamlVM(response, "");
                        return;
                    }
                    case PageGroupSettings: {
                        String reportGroups = "";
                        if (xssRequest.getParameterValues("IUMGroup") != null) {
                            reportGroups = String.join((CharSequence)",", xssRequest.getParameterValues("IUMGroup"));
                        }
                        String reportGroupsDIS = "";
                        if (xssRequest.getParameterValues("IUMGroupDIS") != null) {
                            reportGroupsDIS = String.join((CharSequence)",", xssRequest.getParameterValues("IUMGroupDIS"));
                        }
                        String queueSize = "10";
                        if (xssRequest.getParameterValues("queueSize") != null) {
                            queueSize = String.join((CharSequence)",", xssRequest.getParameterValues("queueSize"));
                        }
                        this.IUMGroup = this.setValue("IUMGroup", reportGroups);
                        this.IUMGroupDIS = this.setValue("IUMGroupDIS", reportGroupsDIS);
                        this.queueSize = this.setValue("queueSize", queueSize);
                        this.duration = xssRequest.getParameter("duration");
                        this.duration = this.setValue("duration", this.duration);
                        this.renderAdminVM(response, "", page, showSideLicense);
                        return;
                    }
                    case PageRest: {
                        this.urlRest = xssRequest.getParameter("urlRest");
                        this.urlRest = this.setValue("urlRest", this.urlRest);
                        RestRoute.getInstance().updateRestRoute(this.urlRest);
                        this.renderAdminVM(response, "", page, showSideLicense);
                        return;
                    }
                    case PageDesign: {
                        this.urlLogo = xssRequest.getParameter("urlLogo");
                        this.urlLogo = this.setValue("urlLogo", this.urlLogo);
                        this.renderAdminVM(response, "", page, showSideLicense);
                        return;
                    }
                    case PageLogging: {
                        this.audit = xssRequest.getParameter("audit");
                        if (this.audit != null && "on".equalsIgnoreCase(this.audit)) {
                            this.setAuditUserManagement(EffectiveCoverageLevel.BASE);
                        } else {
                            this.setAuditUserManagement(EffectiveCoverageLevel.OFF);
                        }
                        this.renderAdminVM(response, "", page, showSideLicense);
                        return;
                    }
                }
                this.renderAdminVM(response, "", page, showSideLicense);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRequest, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRequest);
            String pageId = xssRequest.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                this.renderSideLicenseVM(response);
            } else {
                boolean showSideLicense;
                boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                switch (page) {
                    case PageGroupSettings: 
                    case PageRest: 
                    case PageDesign: 
                    case PageLicense: {
                        this.renderAdminVM(response, "", page, showSideLicense);
                        return;
                    }
                    case PageSAMLSSO: {
                        this.renderSamlVM(response, "");
                        return;
                    }
                }
                this.renderAdminVM(response, "", page, showSideLicense);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, String message, Page page, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String wvg = this.getValue("IUMGroup", this.IUMGroup);
        context.put("IUMGroupArray", wvg.isEmpty() ? "" : wvg.split(","));
        wvg = this.getValue("IUMGroupDIS", this.IUMGroupDIS);
        context.put("IUMGroupDISArray", wvg.isEmpty() ? "" : wvg.split(","));
        context.put("showSideLicense", showSideLicense);
        wvg = this.getValue("queueSize", this.queueSize);
        context.put("queueSizeArray", wvg.isEmpty() ? "" : wvg.split(","));
        this.duration = this.getValue("duration", this.duration);
        context.put("duration", this.duration.isEmpty() ? "24" : this.duration);
        context.put("message", message);
        if (ConditionEvaluatorImpl.getSideLicense() != null) {
            context.put("enhanced", ConditionEvaluatorImpl.getSideLicense().getAppKey().contains("Enhanced"));
        }
        context.put("audit", EffectiveCoverageLevel.OFF.getKey().equalsIgnoreCase(this.getAuditUserManagement()) ? Boolean.FALSE : Boolean.TRUE);
        this.urlLogo = this.getValue("urlLogo", this.urlLogo);
        context.put("urlLogo", this.urlLogo.isEmpty() ? "" : this.urlLogo);
        this.urlRest = this.getValue("urlRest", this.urlRest);
        context.put("urlRest", this.urlRest.isEmpty() ? "" : this.urlRest);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/" + page.pageName, context, (Writer)response.getWriter());
    }

    private void renderSamlVM(HttpServletResponse response, String message) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        this.samlIdp = DAO.getSamlIdp();
        this.samlMapping = DAO.getSamlMapping();
        context.put("samlIdp", this.samlIdp);
        context.put("samlMapping", this.samlMapping);
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private String getI18nSave() {
        try {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            I18nHelper instance = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            return instance.getText("common.words.save");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", this.getSideLicense());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValue(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }

    public String getSideLicense() {
        if (this.sideLicense == null || this.sideLicense.isEmpty()) {
            this.sideLicense = DAO.getSideLicense();
        }
        return this.sideLicense;
    }

    public void setSideLicense(String sideLicense) {
        this.sideLicense = sideLicense;
    }

    public void deleteSideLicense() {
        this.sideLicense = "";
    }

    private String getAuditUserManagement() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)settings.get(AUDIT_USER_MANAGEMENT);
    }

    private void setAuditUserManagement(EffectiveCoverageLevel effectiveCoverageLevel) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(AUDIT_USER_MANAGEMENT, (Object)effectiveCoverageLevel.getKey());
    }

    static enum Page {
        None("", "empty.vm"),
        PageGroupSettings("group", "admin_group_IUM.vm"),
        PageDesign("design", "admin_design_IUM.vm"),
        PageRest("rest", "admin_rest_IUM.vm"),
        PageLogging("logging", "admin_logging_IUM.vm"),
        PageUserManagement("user", "user_IUM.vm"),
        PageLicense("sl", "sidelicense_IUM.vm"),
        PageSAMLSSO("saml", "SAML_IUM.vm");

        String pageId;
        String pageName;

        private Page(String pageId, String pageName) {
            this.pageId = pageId;
            this.pageName = pageName;
        }

        public static Page getPage(String pageId) {
            if (pageId == null) {
                return PageGroupSettings;
            }
            for (Page p : Page.values()) {
                if (!p.pageId.equals(pageId)) continue;
                return p;
            }
            return None;
        }
    }
}

