/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.saml.SAMLHelper;
import de.accxia.jira.addon.IUM.servlet.filter.AccxiaResponseWrapper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IntelligentUserManagerSAMLFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerSAMLFilter.class);
    @ComponentImport
    private static PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private static ApplicationProperties applicationProperties;
    @ComponentImport
    private static TemplateRenderer renderer;
    private static UserManager userManagerJira;

    @Inject
    public IntelligentUserManagerSAMLFilter(PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties, TemplateRenderer renderer) {
        IntelligentUserManagerSAMLFilter.pluginLicenseManager = pluginLicenseManager;
        IntelligentUserManagerSAMLFilter.applicationProperties = applicationProperties;
        IntelligentUserManagerSAMLFilter.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            chain.doFilter(request, response);
            return;
        }
        XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper((HttpServletRequest)request);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String samlPar = xssRequest.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        ApplicationUser applicationUser = userManagerJira.getUserByName(user);
        String myRedirLocation = "/";
        if (applicationUser == null) {
            AccxiaResponseWrapper myWrapper = new AccxiaResponseWrapper(httpResponse);
            chain.doFilter((ServletRequest)xssRequest, (ServletResponse)myWrapper);
            myRedirLocation = myWrapper.getRedirectLocation();
            applicationUser = userManagerJira.getUserByName(user);
            IntelligentUserManagerHelper.moveUserToDisabled(applicationUser);
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroups())) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (!IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, (HttpServletRequest)xssRequest);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.user;
            if (theUser != null) {
                xssRequest.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                httpResponse.sendRedirect(DAO.getSamlIdp());
            } else {
                this.renderQueueVM(currentUser.noOfUsers, (HttpServletRequest)xssRequest, httpResponse);
                return;
            }
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        context.put("urlLogo", DAO.getUrlLogo());
        response.setContentType("text/html;charset=utf-8");
        renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    static {
        userManagerJira = ComponentAccessor.getUserManager();
    }
}

