var IUMLogout = new function() {
	var self=this;
	var theTimer;
	var theLastUserName;
	var logout=function(force){
		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.$("#header-details-user-fullname").attr("data-username");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='loggedInUser']").attr('content');}
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			// self.ajaxGetCall(AJS.contextPath() + "/rest/api/2/user?username="+userName+"&expand=applicationRoles");
			self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps?username="+userName);
		}	
	}
	
	this.startLogoutWatcher=function(){
		theTimer=setInterval(checkApplicationAccess, 15000);
	}
	var callLogout=function(force){
		clearInterval(theTimer);
		logout(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				// console.warn("data="+ JSON.stringify(data));
				if (Object.keys(data).length==0){
					callLogout();
				}

				//1. service desk | software
				if(!data["jira-servicedesk"] && !data["jira-software"] && !data["jira-core"] ){
					callLogout();
				}

				/*
				if(document.location.href.indexOf("/servicedesk")!=-1){
					if(!data["jira-servicedesk"]){
						callLogout();
					}
					return;
				}

				if(!data["jira-software"]){
					callLogout();
				}
				*/
			},
			error :function (xhr, textStatus, errorThrown ) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callLogout(true);
						return;
					}

					callLogout();
				}
			}
		});
	};
};
AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();
});

/*
var IUMLogoutCallback ={
	awayCallback: function(){
		console.log(new Date().toTimeString() + ": away");
	},
	awayBackCallback : function(){
		console.log(new Date().toTimeString() + ": back");
	},
	onVisibleCallback : function(){
		console.log(new Date().toTimeString() + ": now looking at page");
	},
	onHiddenCallback : function(){
		console.log(new Date().toTimeString() + ": not looking at page");
	}
}

AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();
	//this is another way of using it
	var idle = new Idle({
		onHidden:IUMLogoutCallback.onHiddenCallback,
		onVisible: IUMLogoutCallback.onVisibleCallback,
		onAway: IUMLogoutCallback.awayCallback,
		onAwayBack: IUMLogoutCallback.awayBackCallback,
		awayTimeout: 5000 //away with 5 seconds of inactivity
	}).start();
});
 */