 //be aware that it is namespaced.

var IUMLicense = new function() {
	var self=this;
	var licenseRestCounter=0;
	this.licenseDetails=null;
	this.loadLicenseDetails =function(callback){
		if (licenseRestCounter>20){
			return;
		}
		licenseRestCounter++;
		if (self.licenseDetails==null){
			self.licenseDetails=self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/1.0/sidelicense", callback);	
			callback();
		}
		else {
			callback();
		}
	}

	this.ajaxGetCall = function(url) {
		var returnValue = null;
		jQuery.ajax({
			url : url,
			dataType : 'json',
			async : false,
			success : function(data) {
				returnValue = data;
			},
			error : function() {
				console.error("[ajaxGetCall] failed", url);
			}
		});
		return returnValue;
	};
	
	var renderSideLicenseDetails=function(){
		var res="";
		try{
			
			if ((self.licenseDetails==null)||(self.licenseDetails.users==0)){
				return("<div class='aui-message aui-message-error'><p class='title'>IUM: Invalid Side License String</p></div>");
			}
			res+= "<table class='aui aui-table-rowhover'>";
			if (self.licenseDetails.licenseStatus!="LICENSE_OK"){
				res+= "<tr><td>License Status:</td><td><span class='aui-lozenge aui-lozenge-error'>"+self.licenseDetails.licenseStatus+"</span></td></tr>";
			} else {		
				res+= "<tr><td>License Status:</td><td><span class='aui-lozenge aui-lozenge-success'>"+self.licenseDetails.licenseStatus+"</span></td></tr>";
			}
			
			res+= "<tr><td>Users:</td><td>"+self.licenseDetails.users+"</td></tr>";
			res+= "<tr><td>Expires:</td><td>"+self.licenseDetails.expires+"</td></tr>";
			res+= "<tr><td>SSN:</td><td>"+self.licenseDetails.SSN+"</td></tr>";
			res+= "<tr><td>Customer:</td><td>"+self.licenseDetails.customer+"</td></tr>";
			res+= "</table>";
			res+= "<img src='//atlassian.accxia.com/1pixel.png?SSN="+self.licenseDetails.SSN+",Customer="+self.licenseDetails.customer+"'>";
			return(res);
		} catch(e){
			  return("Error rendering side license");
		}		
	}
	
	
	this.showSideLicenseDetails=function(){
		AJS.$("#IUMSideLicenseDetails").html(renderSideLicenseDetails);
	}
	
	var showSideLicensedOld=function(){
		if ((self.licenseDetails==null)||(self.licenseDetails.users==0)){
			return;
		}
		setTimeout(function(){ 
			var $theEle=AJS.$(".upm-plugin-name:contains(Intelligent User Manager)");
			if ($theEle.size()==0){
				return;
			}
			try{
				if (!($theEle.hasClass("accxiaSideLicense"))) {
					$theEle.addClass("accxiaSideLicense");
					if ((self.licenseDetails==null)||(self.licenseDetails.users==0)){
						return;
					}
					
					if (self.licenseDetails.licenseStatus=="LICENSE_OK"){
						AJS.$('<span class="aui-lozenge aui-lozenge-complete">Side Licensed</span>').insertAfter($theEle);
					} else if (self.licenseDetails.licenseStatus=="LICENSE_MISSING"){
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License missing</span>').insertAfter($theEle);
					} else if (self.licenseDetails.licenseStatus=="LICENSE_EXPIRED"){
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License expired</span>').insertAfter($theEle);
					} else {
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License invalid</span>').insertAfter($theEle);
					}	
				}

				$theEle.parent().parent().find(".upm-plugin-action-description").html("Side Licensed by Accxia. To buy or renew, <a href='mailto:appsupport@accxia.com?subject="+self.licenseDetails.customer+"("+self.licenseDetails.SSN+")'>contact us.</a>");
				$theEle.parent().parent().find("[data-action=BUY]").remove();
				$theEle.parent().parent().find("[data-action=RENEW_CONTACT]").remove();
				
				var ld=self.licenseDetails.users+" Users, License expires "+self.licenseDetails.expires+"<br>"+self.licenseDetails.licenseStatus;
				$theEle.parent().next().find(".upm-plugin-license-info").html(ld);
				$theEle.parent().next().find(".upm-plugin-license-status-div ").remove();
				$theEle.parent().next().find(".upm-plugin-license-sen-label").html("Accxia SSN");
				$theEle.parent().next().find(".upm-plugin-license-sen").html(self.licenseDetails.SSN);
				
				// reenable the configure button
				$theEle.parent().parent().find("[data-action=CONFIGURE]").attr("aria-disabled",false);
				$theEle.parent().parent().find("[data-action=CONFIGURE]").removeClass("disabled");
				
				//remove the "trial" button
				$theEle.parent().parent().find("[data-action=TRY]").remove();
				
				//show side license key
				$theEle.parent().parent().find(".edit-license-key").val(self.licenseDetails.licenseKey);
				IUMLicenseInput.enterLicense();
			} catch(e){}	
		}, 1200);
	}
	
	this.showSideLicensed=function(){
		setTimeout(function(){ 
			var $theEle=AJS.$(".upm-plugin-name:contains(Intelligent User Manager)");
			if ($theEle.size()==0){
				return;
			}

			try{
				if (!($theEle.hasClass("accxiaSideLicense"))) {
					if ((self.licenseDetails == null) || (self.licenseDetails.users == 0)) {
						return;
					}
					$theEle.addClass("accxiaSideLicense");

					if (self.licenseDetails.licenseStatus == "LICENSE_OK") {
						AJS.$('<span class="aui-lozenge aui-lozenge-complete">Side Licensed</span>').insertAfter($theEle);
						AJS.$("div[data-key='de.accxia.jira.addon.IUM.IntelligentUserManager']").find(".upm-plugin-action-description .description-text").text(AJS.I18n.getText('de.accxia.apps.jira.IUM.sideLicense.info'));

					} else if (self.licenseDetails.licenseStatus == "LICENSE_MISSING") {
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License missing</span>').insertAfter($theEle);
					} else if (self.licenseDetails.licenseStatus == "LICENSE_EXPIRED") {
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License expired</span>').insertAfter($theEle);
					} else {
						AJS.$('<span class="aui-lozenge aui-lozenge-error">Side License invalid</span>').insertAfter($theEle);
					}
				}

				if(AJS.$("div[data-key='de.accxia.jira.addon.IUM.IntelligentUserManager']").find(".upm-plugin-action-description .description-text:not('accxiaSideLicense')").length>0){
						var $theDesc = AJS.$("div[data-key='de.accxia.jira.addon.IUM.IntelligentUserManager']").find(".upm-plugin-action-description .description-text");
						$theDesc.text(AJS.I18n.getText('de.accxia.apps.jira.IUM.sideLicense.info')).addClass("accxiaSideLicense");
				}

				//$theEle.parent().parent().find(".upm-plugin-license-container").html("<a href='"+AJS.contextPath()+"/plugins/servlet/ium-config?sl='>Manage License</a>");
				
			} catch(e){}	
		}, 1200);
	}
}


AJS.$( document ).ready(function() {
	try{
		if (AJS.$("#upm-container").size()==0){
			return;
		}
		
		if (typeof JIRA != "undefined")
		{
			JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, $ctx) {
				IUMLicense.loadLicenseDetails(IUMLicense.showSideLicensed);
			});
		}	

		IUMLicense.loadLicenseDetails(IUMLicense.showSideLicensed);
			
		//intercept jquery, dojo, etc. ajax requests to trigger app 
		(function (send) {
		    XMLHttpRequest.prototype.send = function (data) {
		        send.call(this, data);
		        IUMLicense.loadLicenseDetails(IUMLicense.showSideLicensed);
		    };
		})(XMLHttpRequest.prototype.send);
	} catch(e){
	};	
});


