var JobSyncX = {
    initGroupPickers: function () {
        var $groupFields = AJS.$(".agroup");
        for (i = 0; i < $groupFields.length; i++) {
            new AJS.SingleSelect({
                element: $groupFields[i],
                width: '400px',
                itemAttrDisplayed: "label",
                showDropdownButton: true,
                errorMessage: "",
                allowClear: true,
                placeholder: AJS.I18n.getText('IUM-placeholder.text'),
                ajaxOptions: {
                    url: contextPath + "/rest/api/2/groups/picker",
                    query: true, // keep going back to the sever for each keystroke
                    formatResponse: JIRA.GroupPickerUtil.formatResponse
                }
            });
        }
    },
        createGroupPickerConfig:function(placeholder,  exclude){
                 return   {
                        delay: 250,
                        placeholder: placeholder || 'Select Groups',
                        width: '90%',
                        multiple: true,
                        initSelection: function (element, callback) {
                            var list = [];
                            var data = JSON.parse(element.val());
                            element.val(null);
                            for (idx in data) {
                                list.push({
                                    id: data[idx],
                                    text: data[idx]
                                });
                            }
                            callback(list);
                        },
                        ajax: {
                            type: 'GET',
                            url: AJS.contextPath() + '/rest/api/2/groups/picker',
                            dataType: 'json',
                            params: {
                                contentType:'application/json'
                            },
                            data: function(term) {
                                return {
                                    query: (term? term : ''),
                                    exclude:exclude||'',
                                    maxResults: 1000
                                };
                            },
                            results: function(data, params) {
                                var list = [];
                                if (data && data.groups && data.groups.length) {
                                    var src = data.groups;
                                    for (var i = 0; i < src.length; i++) {
                                        list.push({
                                            id: src[i].name,
                                            text: src[i].name
                                        });
                                    }
                                }
                                return {
                                    results: list
                                };
                            }
                        }
                    }
            },

        initSelect2 : function(ele,defValue,exclude) {

            var pickerName=ele+"-groupsPicker";
            var elemName=ele+"-groups";
            listValues = defValue ? defValue.split(";") : new Array();


            var localGroupPickerConfig=this.createGroupPickerConfig("Select Goups", exclude)
            AJS.$("#" + pickerName).auiSelect2(localGroupPickerConfig);
            AJS.$("#" + pickerName).on('change:select2', function (e) {
                var list = AJS.$("#" + pickerName).select2('val');
                $("#"+elemName).val(JSON.stringify(list));
            });
            AJS.$("#" + pickerName).on('change.select2', function (e) {
                var list = AJS.$("#" + pickerName).select2('val');
                if(list){
                    $("#"+elemName).val(list.join(";"));
                }

            });
            if(defValue){
                var values = defValue.split(";")
                AJS.$("#" + pickerName).val(JSON.stringify(values));
                AJS.$("#" + pickerName).trigger('change');
            }
        },
}

var JobSync = {
    initSelectStatic : function(ele,defValue,preload_data ) {
        var preload= preload_data ? preload_data.split(",") : new Array();
        var pickerName=ele+"-groupsPicker";
        var elemName=ele+"-groups";
        listValues = defValue ? defValue.split(";") : new Array();
        AJS.$("#" + pickerName).auiSelect2({
            multiple: true,
            initSelection: function (element, callback) {
                let list = [];
                if(element && element.val()){
                    var data = JSON.parse(element.val());
                    element.val(null);
                    for (idx in data) {
                        list.push({id: data[idx],text: data[idx]});
                    }
                }
                callback(list);
            }
            ,query: function (query){
                var data = {results: []};

                $.each(preload, function(){
                    if(query.term.length == 0 || this.toUpperCase().indexOf(query.term.toUpperCase()) >= 0 ){
                        data.results.push({id: this, text: this });
                    }
                });

                query.callback(data);
            }
        });

        AJS.$("#" + pickerName).on('change:select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(JSON.stringify(list));
        });
        AJS.$("#" + pickerName).on('change.select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            if(list){
                $("#"+elemName).val(list.join(";"));
            }

        });
        if(defValue){
            var values = defValue.split(";")
            AJS.$("#" + pickerName).val(JSON.stringify(values));
            AJS.$("#" + pickerName).trigger('change');
        }
    },
    initSelectStatic2 : function(ele,defValue,preload_data ) {
        var preload= preload_data ? preload_data.split(",") : new Array();
        var pickerName=ele+"-groupsPicker";
        var elemName=ele+"-groups";
        listValues = defValue ? defValue.split(";") : new Array();

        AJS.$("#" + pickerName).auiSelect2({
            multiple: false,
            allowClear: true,
            initSelection: function (element, callback) {
                var defData =null;
                if(element && element.val()){
                    defData={id:element.val(),text:element.val()};
                }
                callback(defData);
            }
            ,query: function (query){
                var data = {results: []};

                $.each(preload, function(){
                    if(query.term.length == 0 || this.toUpperCase().indexOf(query.term.toUpperCase()) >= 0 ){
                        data.results.push({id: this, text: this });
                    }
                });

                query.callback(data);
            }
        });

        AJS.$("#" + pickerName).on('change:select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(JSON.stringify(list));
        });
        AJS.$("#" + pickerName).on('change.select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(list);
        });

        if(defValue){
            var values = defValue.split(";")
            AJS.$("#" + pickerName).val(defValue);
            AJS.$("#" + pickerName).trigger('change');
        }
    },
    doSubmit: function(){

        var $elems=AJS.$(".services");
        $elems.find('.error').val("");
        var hasIssues = false;


        for (var i = 0; i < $elems.length; i ++) {
            var $elem=$($elems[i]);
            var srcSelection= $elem.find('.src-selection');
            var targetSelection= $elem.find('.target-selection');
            var errorMessage= $elem.parent().find('.error');

            if(targetSelection.val() && !srcSelection.val()) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
            if(!targetSelection.val() && srcSelection.val()) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
        }

        if(hasIssues){
            AJS.dialog2("#demo-dialog").show();
            AJS.$("#dialog-submit-button").click(function (e) {
                e.preventDefault();
                AJS.dialog2("#demo-dialog").hide();
                hasIssues=false;

            });
            AJS.$("#dialog-close-button").click(function (e) {
                e.preventDefault();
                AJS.dialog2("#demo-dialog").hide();
            });
        }
        return !hasIssues;
    }
}
/*
        var allFilled=true;
        for (var i = 0; i < $elems.length; i += 3) {
            if ($eles[i].value!=""){
                if (($eles[i+1].value=="")|| ($eles[i+2].value=="")){
                    allFilled=false;
                } else if ($eles[i].value==$eles[i+1].value){
                    allFilled=false;
                }
            } else {
                $eles[i].closest("tr").remove();
            }
        }

        if (allFilled) {
            AJS.$("#error").text("");
            return(true);
        }
        AJS.$("#error").text(AJS.I18n.getText('IUM-error.empty'));
  */


