var IUMLogout = new function() {
	var self=this;
	var theTimer;
	const INTERVAL=15000;
	var theLastUserName;
	//cache latest permission to compare with current
	var theApplicationAccess4UserName={};

	var logout=function(force){
		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.$("#header-details-user-fullname").attr("data-username");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='loggedInUser']").attr('content');}
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			//self.ajaxGetCall(AJS.contextPath() + "/rest/api/2/user?username="+userName+"&expand=applicationRoles");
			self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps?username="+userName);
		}	
	}
	
	this.startLogoutWatcher=function(){
		theTimer=setInterval(checkApplicationAccess, INTERVAL);
	}
	var callLogout=function(force){
		clearInterval(theTimer);
		logout(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				// console.warn("data="+ JSON.stringify(data));
				if (Object.keys(data).length==0){
					callLogout();
					return;
				}

				//1. service desk | software
				if(!data["jira-servicedesk"] && !data["jira-software"] && !data["jira-core"] ){
					callLogout();
					return;
				}

				var msg = "";
				if(theApplicationAccess4UserName["jira-software"] &&  !data["jira-software"] ){
					msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-software ");
				}

				if(theApplicationAccess4UserName["jira-servicedesk"] &&  !data["jira-servicedesk"] ){
					msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-servicedesk ");
				}

				if(theApplicationAccess4UserName["jira-core"] &&  !data["jira-core"] ){
					msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-core ");
				}

				if(msg) {
					debugger;
					doPopupPartialPermission(msg,theApplicationAccess4UserName);
				}
				theApplicationAccess4UserName=data;
			},
			error :function (xhr, textStatus, errorThrown ) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callLogout(true);
						return;
					}

					callLogout();
				}
			}
		});
	};


	var doPopupPartialPermission=function(message){
		IUMLogin.doClosePopupFlag();

		IUMLogin.login_flag = AJS.flag({
			type: 'warning',
			title:'Intelligent User Manager (IUM)',
			body:message +
				'<ul class="aui-nav-actions-list">' +
				'<li><a class="aui-button aui-button-link" onclick="IUMLogout.doCloseAndRetryFlag()" href="#">Retry</a></li>' +
				'</ul>'
		});
	};

	this.updateApplicationAccess=function(data){
		theApplicationAccess4UserName=data
	}

};

IUMLogout.doCloseAndRetryFlag=function(){

	jQuery.ajax({
		url : AJS.contextPath() + "/rest/IUM/latest/retry",
		dataType : 'json',
		contentType: "application/json; charset=utf-8",
		success : function(data) {
			if(data && data.warningMessage){
				IUMLogin.doUpdateCookie(data.warningMessage);
				IUMLogin.startIUMLoginWatcher();
			}else{

				IUMLogin.doCleanRemindFlag();
				IUMLogin.doPopupFullPermission()
			}
		},
		error :function (xhr, textStatus, errorThrown ) {
			if ((xhr && xhr.status >= 400) || errorThrown ) {
				console.error(xhr);
			}
		}
	});

	return false;
}

AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();
});

/*
var IUMLogoutCallback ={
	awayCallback: function(){
		console.log(new Date().toTimeString() + ": away");
	},
	awayBackCallback : function(){
		console.log(new Date().toTimeString() + ": back");
	},
	onVisibleCallback : function(){
		console.log(new Date().toTimeString() + ": now looking at page");
	},
	onHiddenCallback : function(){
		console.log(new Date().toTimeString() + ": not looking at page");
	}
}

AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();
	//this is another way of using it
	var idle = new Idle({
		onHidden:IUMLogoutCallback.onHiddenCallback,
		onVisible: IUMLogoutCallback.onVisibleCallback,
		onAway: IUMLogoutCallback.awayCallback,
		onAwayBack: IUMLogoutCallback.awayBackCallback,
		awayTimeout: 5000 //away with 5 seconds of inactivity
	}).start();
});
 */