var JobSync = {
    initSelectStaticSrc : function(ele,defValue,preload_data ) {
        var preload= preload_data ? preload_data.split(",") : new Array();
        var pickerName=ele+"-groupsPicker";
        var elemName=ele+"-groups";
        listValues = defValue ? defValue.split(";") : new Array();
        AJS.$("#" + pickerName).auiSelect2({
            multiple: true,
            initSelection: function (element, callback) {
                let list = [];
                if(element && element.val()){
                    var data = JSON.parse(element.val());
                    element.val(null);
                    for (idx in data) {
                        list.push({id: data[idx],text: data[idx]});
                    }
                }
                callback(list);
            }
            ,query: function (query){
                var data = {results: []};

                $.each(preload, function(){
                    if(query.term.length == 0 || this.toUpperCase().indexOf(query.term.toUpperCase()) >= 0 ){
                        data.results.push({id: this, text: this });
                    }
                });

                query.callback(data);
            }
        });

        AJS.$("#" + pickerName).on('change:select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(JSON.stringify(list));
        });
        AJS.$("#" + pickerName).on('change.select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            if(list){
                $("#"+elemName).val(list.join(";"));
            }

        });
        if(defValue){
            var values = defValue.split(";")
            AJS.$("#" + pickerName).val(JSON.stringify(values));
            AJS.$("#" + pickerName).trigger('change');
        }
    },

    initSelectStaticTarget : function(ele,defValue,preload_data ) {
        var preload= preload_data ? preload_data.split(",") : new Array();
        var pickerName=ele+"-groupsPicker";
        var elemName=ele+"-groups";
        listValues = defValue ? defValue.split(";") : new Array();

        AJS.$("#" + pickerName).auiSelect2({
            multiple: false,
            allowClear: true,
            initSelection: function (element, callback) {
                var defData =null;
                if(element && element.val()){
                    defData={id:element.val(),text:element.val()};
                }
                callback(defData);
            }
            ,query: function (query){
                var data = {results: []};

                $.each(preload, function(){
                    if(query.term.length == 0 || this.toUpperCase().indexOf(query.term.toUpperCase()) >= 0 ){
                        data.results.push({id: this, text: this });
                    }
                });

                query.callback(data);
            }
        });

        AJS.$("#" + pickerName).on('change:select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(JSON.stringify(list));
        });
        AJS.$("#" + pickerName).on('change.select2', function (e) {
            var list = AJS.$("#" + pickerName).select2('val');
            $("#"+elemName).val(list);
        });

        if(defValue){
            var values = defValue.split(";")
            AJS.$("#" + pickerName).val(defValue);
            AJS.$("#" + pickerName).trigger('change');
        }
    },

    doSubmit: function(){

        var $elems=AJS.$(".services");
        $elems.find('.error').val("");
        var hasIssues = false;


        for (var i = 0; i < $elems.length; i ++) {
            var $elem=$($elems[i]);
            var srcSelection= $elem.find('.src-selection');
            var targetSelection= $elem.find('.target-selection');
            var errorMessage= $elem.parent().find('.error');

            if(targetSelection.val() && !srcSelection.val()) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
            if(!targetSelection.val() && srcSelection.val()) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
        }

        if(hasIssues){
            AJS.dialog2("#rule-dialog").show();
            AJS.$("#rule-dialog-submit-button").click(function (e) {
                //e.preventDefault();
                AJS.dialog2("#rule-dialog").hide();
                $('#IUM-config').removeAttr('onsubmit').submit();

            });
            AJS.$("#rule-dialog-close-button").click(function (e) {
                e.preventDefault();
                AJS.dialog2("#rule-dialog").hide();
            });
        }

        return !hasIssues;
    }
}
