var IUMLogout = new function() {
	var self=this;
	var theTimer;
	const INTERVAL=15000;
	const IUM_CHECK_ACCESS_PING='ium_check_access_ping'
	var theLastUserName;
	//cache latest permission to compare with current
	var theApplicationAccess4UserName={};

	var logout=function(force){
		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.$("#header-details-user-fullname").attr("data-username");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='loggedInUser']").attr('content');}
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			//self.ajaxGetCall(AJS.contextPath() + "/rest/api/2/user?username="+userName+"&expand=applicationRoles");

			var dateStr=window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
			try{
				var dateRef = JSON.parse(dateStr) ;
				if((Date.now() - dateRef.timestamp<INTERVAL) && (dateRef.username === userName)){
					doProcessData(dateRef,false);
					return;
				}
			} catch (error) {
				console.error(error);
			}

			self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps?username="+userName);
		}	
	}
	
	this.startLogoutWatcher=function(){
		theTimer=setInterval(checkApplicationAccess, INTERVAL);
	}

	var callLogout=function(force){
		clearInterval(theTimer);
		logout(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	var doProcessData=function(data,withSaving){
		// console.warn("data="+ JSON.stringify(data));
		if (Object.keys(data).length==0){
			callLogout();
			return;
		}

		//1. service desk | software
		if(!data["jira-servicedesk"] && !data["jira-software"] && !data["jira-core"] ){
			callLogout();
			return;
		}

		var msg = "";
		if(data["could-has-software"] &&  !data["jira-software"] ){
			msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-software ");
		}

		if(data["could-has-service"] &&  !data["jira-servicedesk"] ){
			msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-servicedesk ");
		}

		if(data["could-has-core"] &&  !data["jira-core"] ){
			msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-core ");
		}

		if(msg) {
			doPopupPartialPermission(msg);
		}

		if(withSaving){
			data.timestamp = Date.now();
			window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
		}
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				doProcessData(data,true)
			},
			error :function (xhr, textStatus, errorThrown ) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callLogout(true);
						return;
					}

					callLogout();
				}
			}
		});
	};


	var doPopupPartialPermission=function(message){
		if(!IUMLogin.login_flag_hide){
			IUMLogin.doClosePopupFlag();

			IUMLogin.login_flag = AJS.flag({
				type: 'warning',
				title:'Intelligent User Manager (IUM)',
				body:message +
					'<ul class="aui-nav-actions-list">' +
					'<li><a class="aui-button aui-button-link" onclick="IUMLogout.doCloseAndRetryFlag()" href="#">Retry</a></li>' +
					'</ul>'
			});
			IUMLogin.login_flag_hide=false;
		}

	};


};

IUMLogout.doCloseAndRetryFlag=function(){

	jQuery.ajax({
		url : AJS.contextPath() + "/rest/IUM/latest/retry",
		dataType : 'json',
		contentType: "application/json; charset=utf-8",
		success : function(data) {
			if(data && data.warningMessage){
				IUMLogin.doUpdateCookie(data.warningMessage);
				IUMLogin.startIUMLoginWatcher();
			}else{

				IUMLogin.doCleanRemindFlag();
				IUMLogin.doPopupFullPermission()
			}
		},
		error :function (xhr, textStatus, errorThrown ) {
			if ((xhr && xhr.status >= 400) || errorThrown ) {
				console.error(xhr);
			}
		}
	});

	return false;
}

AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();

	document.addEventListener('aui-flag-close', function(e) {
		if(IUMLogin.login_flag && IUMLogin.login_flag == IUMLogin.login_flag){
			IUMLogin.login_flag_hide=true;
		}
	});

});
