var IUMCheck = new function() {
    var self=this;
    var theTimer;
    const INTERVAL=15000;
    const IUM_CHECK_SLOT_PING='ium_check_slot_ping'
    var logout=function(force){
        if(!force && self.theLastUserName){
            document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
        }else {
            document.location.href = AJS.contextPath() + "/secure/Dashboard.jspa";
        }
    }

    var doRetry=function(){
       if(document.forms['retry']){
           document.forms['retry'].submit();
           return;
       }
        //document.location.href="/secure/restore?username="+self.theLastUserName;
        document.location.href = AJS.contextPath() + "/secure/Dashboard.jspa";
    }

    var checkApplicationAccess=function(){
        //pass 15 sec
        self.duration=self.duration-INTERVAL;
        console.log("checkApplicationAccess self.duration= "+self.duration);

        if(self.duration>0){
            var dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
            try{
                var dateRef = JSON.parse(dateStr) ;
                if((Date.now() - dateRef.timestamp<INTERVAL) && (dateRef.username === self.theLastUserName)){
                    doProcessData(dateRef,false);
                    return;
                }
            } catch (error) {
                console.error(error);
            }

            self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/check?username="+self.theLastUserName);
        }else{
            callRetry();
        }
    }

    var doProcessData=function(data,withSaving){
        console.warn("data="+ JSON.stringify(data));
        if(data.freeSlots){
            doRetry()
        }

        if(withSaving){
            data.timestamp = Date.now();
            localStorage.setItem(IUM_CHECK_SLOT_PING,JSON.stringify(data));
        }
    }

    this.startCheckWatcher=function(){
        //1. retrive input.hidden
        var userName=AJS.$("#username").val();
        var duration=AJS.$("#duration").val();
        self.duration = duration ? duration : 1;

        //convert to milliseconds
        self.duration=self.duration * 60 * 1000;

        if (typeof (userName)!="undefined"){
            self.theLastUserName=userName;
            theTimer=setInterval(checkApplicationAccess, INTERVAL);
        }
    }

    var callRetry=function(){
        clearInterval(theTimer);
        doRetry();
    }
    var callLogout=function(force){
        clearInterval(theTimer);
        logout(force);
        console.log("ACCXIA IUM: User has been logged out");
    }
    this.ajaxGetCall = function(url) {
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                doProcessData(data,true)

            },
            error :function (xhr, textStatus, errorThrown ) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    if(xhr.status==401){
                        callLogout(true);
                        return;
                    }

                    callLogout();
                }
            }
        });
    };
};

AJS.$( document ).ready(function() {
    IUMCheck.startCheckWatcher();
});
