package de.accxia.jira.addon.IUM.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import de.accxia.jira.addon.IUM.cache.AccxiaCachePropertySet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.HashMap;
import java.util.Map;


/**
 * DAO - Data Access Object
 * 
 * Required to store persistent configuration Data in DAO Objects, values are
 * stored as Key/Value Pairs
 */
@ExportAsService({DAO.class})
@Named ("DAO")
public class DAO {
	private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
	public static final String REST_ROUTE = "urlRest";
	public static final String REST_INIT = "initRest";

	public static final String  INACTIVITY_DURATION="inactivityDuration";
	public static final String  REPEAT_INTERVAL="interval";
	public static final String  STARTING_AT="startingAt";
	public static final String  STARTING_FROM="startingFrom";


	public static final String WORKING_JOB="workingJob";

	public static final String IUMGroup="IUMGroup";
	public static final String IUMGroupDIS="IUMGroupDIS";

	public static final String  SYNC_REPEAT_INTERVAL="syncRepeatInterval";
	public static final String  SYNC_STARTING_AT="syncStartingAt";
	public static final String  SYNC_STARTING_FROM="syncStartingFrom";
	public static final String  SYNC_SOFTWARE_SRC_GROUP="syncSoftwareSrcGroup";
	public static final String  SYNC_SOFTWARE_TARGET_GROUP="syncSoftwareTargetGroup";
	public static final String  SYNC_SERVICE_DESK_SRC_GROUP="syncSDeskSrcGroup";
	public static final String  SYNC_SERVICE_DESK_TARGET_GROUP="syncSDeskTargetGroup";

	public static final String WORKING_SYNC_JOB="workingSyncJob";

	public static final String  DAILY_STARTING_FROM="dailyStartingFrom";
	public static final String  DAILY_REPEAT_INTERVAL="dailyRepeatInterval";
	public static final String  WORKING_DAILY_JOB="workingDailyJob";
	public static final String  LOGGER="logger";
	public static final String LOGGER_KEY= "de.accxia.jira.addon.IUM";
	private static final String PLUGIN_STORAGE_KEY = "de.accxia.jira.addons.usermanager";

	private static PluginSettingsFactory pluginSettingsFactory = (PluginSettingsFactory)  ComponentAccessor.getOSGiComponentInstanceOfType(PluginSettingsFactory.class);
	private static PluginSettings pluginSettings;
	private static AccxiaCachePropertySet accxiaCachePropertySet;

	@Inject
	public DAO(AccxiaCachePropertySet accxiaCachePropertySet) {
		DAO.pluginSettings = pluginSettingsFactory.createGlobalSettings();
		DAO.accxiaCachePropertySet=accxiaCachePropertySet;
	}

	public static PluginSettings getPluginSettings() {
		if (pluginSettings == null) {
			pluginSettings = pluginSettingsFactory.createGlobalSettings();
		}
		return pluginSettings;
	}
	private static String emptyValueFromNull(String value){
			if(value == null){
				return "";
			}
			return value;
	}
	public static String getValue(String field) {
		//added caching
		PluginSettings pluginSettings = DAO.getPluginSettings();

		if (DAO.accxiaCachePropertySet==null){
			if(LOG.isDebugEnabled()){
				LOG.debug("DAO.accxiaCachePropertySet is NULL");
			}
			Object value = pluginSettings.get(PLUGIN_STORAGE_KEY + "." + field);

			if (value == null || "null".equals(value)) {
				if(LOG.isDebugEnabled()){
					LOG.debug("pluginSettings find field={} value=NULL ==> \"\"" ,new Object[]{field});
				}
				pluginSettings.put(PLUGIN_STORAGE_KEY + "." + field, value = "");
				return "";
			}

			String res=String.valueOf(value);
			if(LOG.isDebugEnabled()){
				LOG.debug("from pluginSettings accxiaCachePropertySet=NULL field={} value={}",new Object[]{field,res});
			}

			return emptyValueFromNull(res);
		}

		if(DAO.accxiaCachePropertySet.hasKey(field)){
			String ourVal=	DAO.accxiaCachePropertySet.getValue(field);
			if(LOG.isTraceEnabled()){
				LOG.trace("DAO.accxiaCachePropertySet field={} value={}",new Object[]{field,ourVal});
			}
			return emptyValueFromNull(ourVal);
		}else{
			Object value = pluginSettings.get(PLUGIN_STORAGE_KEY + "." + field);
			if (value == null || "null".equals(value)) {
				return "";
			}

			String res=String.valueOf(value);
			if(LOG.isTraceEnabled()){
				LOG.trace("from pluginSettings field={} value={}", new Object[]{field, res});
			}
			DAO.accxiaCachePropertySet.setValue(field,res);

			return emptyValueFromNull(res);
		}
	}

	public static void setValue(String field, String value) {
		PluginSettings pluginSettings = DAO.getPluginSettings();
		pluginSettings.put(PLUGIN_STORAGE_KEY + "." + field, value);

		if (DAO.accxiaCachePropertySet!=null){
			DAO.accxiaCachePropertySet.setValue(field,value);
		}
	}

	//Testing
	public static String getValueX(String field) {
		//added caching
		PluginSettings pluginSettings = DAO.getPluginSettings();

		Object value = pluginSettings.get(PLUGIN_STORAGE_KEY + "." + field);

		if (value == null || "null".equals(value)) {
			if(LOG.isDebugEnabled()){
				LOG.debug("pluginSettings find field={} value=NULL ==> \"\"" ,new Object[]{field});
			}
			pluginSettings.put(PLUGIN_STORAGE_KEY + "." + field, value = "");
			return "";
		}

		String res=String.valueOf(value);
		if(LOG.isDebugEnabled()){
			LOG.debug("from pluginSettings accxiaCachePropertySet=NULL field={} value={}",new Object[]{field,res});
		}

		return emptyValueFromNull(res);
	}

	//Testing
	public static void setValueX(String field, String value) {
		PluginSettings pluginSettings = DAO.getPluginSettings();
		pluginSettings.put(PLUGIN_STORAGE_KEY + "." + field, value);

	}

	public static void updateIUMGroup(String value) {
		setValue(IUMGroup, value);
	}
	public static String getIUMGroups() {
		String value=getValue(IUMGroup);
		return value;
	}
	public static void updateIUMGroupDisabled(String value) {
		setValue(IUMGroupDIS, value);
	}
	public static String getIUMGroupsDisabled() {
		String value=getValue(IUMGroupDIS);
		return value;
	}
	public static String getIUMSoftGroupsDisabled() {
		String groups=getIUMGroupsDisabled();
		if(StringUtils.isEmpty(groups)){return "";}


		String group[]=groups.split(",");
		//JiraGroupSoftware,JiraServiceDesk,JiraCore,
		if(group.length>0){
			return group[0];
		}

		return "";

	}
	public static String getIUMSDeskGroupsDisabled() {
		String groups=getIUMGroupsDisabled();
		if(StringUtils.isEmpty(groups)){return "";}


		String group[]=groups.split(",");
		//JiraGroupSoftware,JiraServiceDesk,JiraCore,
		if(group.length>1){
			return group[1];
		}

		return "";

	}

	
	public static void updateDuration(String value) {
		setValue("duration", value);
	}
	public static String getDuration() {
		String duration= getValue("duration");
		return duration;
	}

	public static void updateQueueSize(String value) {
		setValue("queueSize", value);
	}
	public static String getQueueSize() {
		String queueSize= getValue("queueSize");
		return queueSize;

	}

	public static void updateUrlLogo(String value) {
		setValue("urlLogo", value);
	}
	public static String getUrlLogo() {
		String urlLogo= getValue("urlLogo");
		return urlLogo;
	}

	public static void updateQueueMessage(String value) {
		setValue("queueMessage", value);
	}
	public static String getQueueMessage() {
		String queueMessage= getValue("queueMessage");
		return queueMessage;
	}


	public static void updateUrlRest(String value) {
		setValue("urlRest", value);
	}
	public static String getUrlRest() {
		String urlRest= getValue("urlRest");
		return urlRest;
	}

	public static void updateSamlIdp(String value) {
		setValue("samlIdp", value);
	}
	public static String getSamlIdp() {
		String samlIdp= getValue("samlIdp");
		return samlIdp;
	}
	
	public static void updateSamlMapping(String value) {
		setValue("samlMapping", value);
	}
	public static String getSamlMapping() {
		String samlMapping= getValue("samlMapping");
		return samlMapping;
	}


	public static void updateSideLicense(String value) {
		setValue("sideLicense", value);
	}

	public static String getSideLicense() {
		String sideLicense = getValue("sideLicense");
		return sideLicense == null ? "" : sideLicense;
	}

	public static String getInactivityDuration() {
		String inactivityDuration = getValue(INACTIVITY_DURATION);
		if(inactivityDuration==null || "" .equals(inactivityDuration)){
			inactivityDuration="5";
			updateInactivityDuration(inactivityDuration);

		}
		return inactivityDuration;
	}

	public static void updateInactivityDuration(String value) {
		setValue(INACTIVITY_DURATION, value);
	}
	public static String getRepeatInterval() {
		String repeatInterval= getValue(REPEAT_INTERVAL);
		return repeatInterval;
	}

	public static void updateRepeatInterval(String value) {
		setValue(REPEAT_INTERVAL, value);
	}
	public static void updateStartingAt(String value) {
		setValue(STARTING_AT, value);
	}

	public static String getStartingAt() {
		return getValue(STARTING_AT);
	}

	public static void updateStartingFrom(String value) {
		setValue(STARTING_FROM, value);
	}

	public static String getStartingFrom() {
		return getValue(STARTING_FROM);
	}

	public static void updateWorkingJob(String value) {
		setValue(WORKING_JOB, value);
	}

	public static String getWorkingJob() {
		return getValue(WORKING_JOB);
	}

	//=============Sync ======================/


	public static void updateSyncSoftwareSrcGoups(String value) {
		setValue(DAO.SYNC_SOFTWARE_SRC_GROUP, value);
	}
	public static String getSyncSoftwareSrcGoups() {
		String group=getValue(DAO.SYNC_SOFTWARE_SRC_GROUP);
		return group;
	}
	public static void updateSyncSoftwareTargetGoups(String value) {
		setValue(DAO.SYNC_SOFTWARE_TARGET_GROUP, value);
	}
	public static String getSyncSoftwareTargetGoups() {
		String group=getValue(DAO.SYNC_SOFTWARE_TARGET_GROUP);
		return group;
	}
	public static void updateSyncSDeskSrcGoups(String value) {
		setValue(DAO.SYNC_SERVICE_DESK_SRC_GROUP, value);
	}
	public static String getSyncSDeskSrcGoups() {
		String group=getValue(DAO.SYNC_SERVICE_DESK_SRC_GROUP);
		return group;
	}
	public static void updateSyncSDeskTargetGoups(String value) {
		setValue(DAO.SYNC_SERVICE_DESK_TARGET_GROUP, value);
	}
	public static String getSyncSDeskTargetGoups() {
		String group=getValue(DAO.SYNC_SERVICE_DESK_TARGET_GROUP);
		return group;
	}

	//
	public static String getSyncRepeatInterval() {
		String repeatInterval= getValue(SYNC_REPEAT_INTERVAL);
		return repeatInterval;
	}

	public static void updateSyncRepeatInterval(String value) {
		setValue(SYNC_REPEAT_INTERVAL, value);
	}
	public static void updateSyncStartingAt(String value) {
		setValue(SYNC_STARTING_AT, value);
	}

	public static String getSyncStartingAt() {
		return getValue(SYNC_STARTING_AT);
	}

	public static void updateSyncStartingFrom(String value) {
		setValue(SYNC_STARTING_FROM, value);
	}

	public static String getSyncStartingFrom() {
		return getValue(SYNC_STARTING_FROM);
	}

	public static void updateSyncWorkingJob(String value) {
		setValue(WORKING_SYNC_JOB, value);
	}

	public static String getSyncWorkingJob() {
		return getValue(WORKING_SYNC_JOB);
	}

	//=============Sync ======================/
	//=============Daily ======================/
	public static String getDailyRepeatInterval() {
		String repeatInterval= getValue(DAILY_REPEAT_INTERVAL);
		return repeatInterval;
	}
	public static void updateDailyRepeatInterval(String value) {
		setValue(DAILY_REPEAT_INTERVAL, value);
	}
	public static String getDailyStartingFrom() {
		String repeatInterval= getValue(DAILY_STARTING_FROM);
		return repeatInterval;
	}
	public static void updateDailyStartingFrom(String value) {
		setValue(DAILY_STARTING_FROM, value);
	}

	public static void updateDailyWorkingJob(String value) {
		setValue(WORKING_DAILY_JOB, value);
	}

	//=============Daily ======================/

	public static Boolean getLoggerLevel(){
		String logger= getValue(LOGGER);
		return (logger!=null ? Boolean.valueOf(logger): Boolean.FALSE);
	}
    public static void updateLoggerLevel(boolean value) {
		setValue(LOGGER,String.valueOf(value)); }

	public static Map<String, String> getValues() {
		Map<String,String> map = new HashMap();
		map.put("IUMGroups",DAO.getIUMGroups());
		map.put("IUMGroupsDisabled",DAO.getIUMGroupsDisabled());
		map.put("duration",DAO.getDuration());
		map.put("queueSize",DAO.getQueueSize());
		map.put("urlLogo",DAO.getUrlLogo());
		map.put("queueMessage",DAO.getQueueMessage());
		map.put("urlRest",DAO.getUrlRest());
		map.put("samlIdp",DAO.getSamlIdp());
		map.put("samlMapping",DAO.getSamlMapping());
		map.put("sideLicense",DAO.getSideLicense());
		map.put("inactivityDuration",DAO.getInactivityDuration());
		map.put("repeatInterval",DAO.getRepeatInterval());
		map.put("startingAt",DAO.getStartingAt());
		map.put("startingFrom",DAO.getStartingFrom());
		map.put("workingJob",DAO.getWorkingJob());
		map.put("loggerLevel",String.valueOf(DAO.getLoggerLevel()));
		return  map;
	}

	public static void cleanPluginSettings() {

		DAO.setValue("startingFrom",null);


		DAO.setValue("samlIdp",null);
		DAO.setValue("samlMapping",null);
		DAO.setValue("togroup",null);
		DAO.setValue("noof",null);
		DAO.setValue("urlRest",null);
		DAO.setValue("filtergroup",null);
		DAO.setValue("initRest",null);
		DAO.setValue("interval",null);
		DAO.setValue("userMap",null);
		DAO.setValue("inactivity",null);
		DAO.setValue("fromgroup",null);
		DAO.setValue("startingAt",null);
		DAO.setValue("inactivityDuration",null);
		DAO.setValue("urlLogo",null);
		DAO.setValue("workingJob",null);
		DAO.setValue(IUMGroup,null);
		DAO.setValue(IUMGroupDIS,null);
		DAO.setValue("logger",null);
		DAO.setValue("queueSize",null);
		DAO.setValue("duration",null);
		DAO.setValue("queueMessage",null);
		DAO.setValue("sideLicense",null);


		if(DAO.accxiaCachePropertySet!=null){
			DAO.accxiaCachePropertySet.clean();
		}
	}


}