package de.accxia.jira.addon.IUM.impl;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.ImmutableSet;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.*;

public class IntelligentUserManagerHelper {
	private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerHelper.class);

	private static UserUtil userUtil = ComponentAccessor.getUserUtil();
	private static com.atlassian.jira.user.util.UserManager userManagerJira=ComponentAccessor.getUserManager();
	
	private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
	private static final UserIssueHistoryManager historyManager = ComponentAccessor.getComponent(UserIssueHistoryManager.class);
	private static final UserSearchService userSearchService = ComponentAccessor.getComponent(UserSearchService.class);
	private static CrowdService crowdService = ComponentAccessor.getCrowdService();

	private static ApplicationRoleManager applicationRoleManager=ComponentAccessor.getComponent(ApplicationRoleManager.class);

	private  static ApplicationAuthorizationService applicationAuthorizationService=ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
	private static HashMap<String, Long> ourUsers = new HashMap<String, Long>();

	//control moving operation from ium_disable -> ium_enable
	public static final boolean MOVE_USER = false;

	public static void logOutUser(ApplicationUser theUser, HttpServletRequest request,JiraAuthenticationContext jiraAuthContext) {
		if(log.isDebugEnabled()){
			log.debug("Logging out user " +theUser.getName() + " for request "+(request.getServletPath()!=null ? request.getServletPath():"N/A"));
		}
		//TODO it's necessary
		IntelligentUserManagerHelper.moveUserToDisabled(theUser);
		/*
		request.getSession().setAttribute(DefaultAuthenticator.LOGGED_IN_KEY, null);
		request.getSession().setAttribute(DefaultAuthenticator.LOGGED_OUT_KEY, theUser);
		jiraAuthContext.clearLoggedInUser();
		 */
	}
	
	public static long getUserTS(String user) {
		return(ourUsers.getOrDefault(user, 0L));
	}
	
	public static void setUserTS(String user, Long ts) {
		ourUsers.put(user, ts);
	}
	
	public static String listUsers() {
		StringBuffer res=new StringBuffer();
		for (String key : ourUsers.keySet()) {
		   res.append("\n"+key+":"+getUserTS(key));
		}
		return(res.toString());
	}

	public static boolean isUserInGroups(ApplicationUser currentUser, String groups) {
		// return if no group has been selected => pass all
		
		if (groups == null || "".equals(groups))
			return true;

		// Check if user is assigned to group
		for (String group : groups.split(",")) {
			if (groupManager.isUserInGroup(currentUser, group)) {
				return true;
			}
		}

		return false;
	}

	public static boolean isUserInJiraAndSDGroups(ApplicationUser currentUser, String groups) {
		// return if no group has been selected => pass all

		if (groups == null || "".equals(groups))
			return true;

		String appGroups[] =  groups.split(",");
		// Check if user is assigned to group

		if(appGroups.length>=1 && !groupManager.isUserInGroup(currentUser, appGroups[0])){
			return false;
		}

		if(appGroups.length>=2 && !groupManager.isUserInGroup(currentUser, appGroups[1])){
			return false;
		}

		return true;
	}

	public static boolean isUserInGroups(String username, String groups) {
		// return if no group has been selected => pass all

		if (groups == null || "".equals(groups))
			return true;

		// Check if user is assigned to group
		for (String group : groups.split(",")) {
			if (groupManager.isUserInGroup(username, group)) {
				return true;
			}
		}

		return false;
	}
	public static long getLong(String str) {
		long d = 0;
		try {
			d = Long.parseLong(str);
		} catch (NumberFormatException nfe) {
			return 0;
		}
		return d;
	}

	//Web operation
	public static String moveUserFromGroupToGroup(ApplicationUser user, String group, String toGroup, boolean move) {
		if (group.equals(toGroup)) {
			return ("");
		}
		try {
			if ((group==null)||("".equals(group))) {
				return null;
			}
			if ((toGroup==null)||("".equals(toGroup))) {
				return "";
			}
			StringBuffer theLog= new StringBuffer();
			Group theGroup = groupManager.getGroup(group);
			Group thetoGroup = groupManager.getGroup(toGroup);

			disableUserFromGroup(user, theGroup, thetoGroup, move,true);
			theLog.append(user.getUsername()+"=>"+thetoGroup.getName()+"</br>\n");
			return(theLog.toString());
		} catch (Exception e) {
			log.error("Exception: " + e.getMessage(),e);
		}
		return("");
	}

	//Web operation
	public static String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
		if ((group==null)||(toGroup==null) || (group.equals(toGroup))) {
			return ("");
		}
		try {
			int totalRemoved=0;
			if ((group==null)||("".equals(group))) {
				return null;
			}
			if ((toGroup==null)||("".equals(toGroup))) {
				return "";
			}
			StringBuffer theLog= new StringBuffer();
			
			for (String it : selectedUsersList) {
				ApplicationUser user=userManagerJira.getUserByName(it);
				if (user!=null) {
					totalRemoved++;
					theLog.append(moveUserFromGroupToGroup(user, group, toGroup, move));
				}	
			}
			String action="Copied";
			if (move) {
				action="Moved";
			}
			return("<b>"+action+" "+totalRemoved+ " Users</b> form Group <b>"+group+"</b> to Group <b>"+toGroup+"</b></br></br>\n"+theLog.toString());
		} catch (Exception e) {
			log.error("Exception: " + e.getMessage(),e);
		}
		return("");
	}

	//Web operation
	public static String moveAllUsersFromGroupToGroup(String group, String toGroup) {
		if ((group==null)||(toGroup==null) || (group.equals(toGroup))) {
			return ("");
		}
		try {
			int totalRemoved=0;
			if ((group==null)||("".equals(group))) {
				return null;
			}
			if ((toGroup==null)||("".equals(toGroup))) {
				return "";
			}
			StringBuffer theLog= new StringBuffer();
			
			for (ApplicationUser it : groupManager.getUsersInGroup(group)) {
				totalRemoved++;
				theLog.append(moveUserFromGroupToGroup(it, group, toGroup, true));
			}
			return("<b>Moved "+totalRemoved+ " Users</b> form Group <b>"+group+"</b> to Group <b>"+toGroup+"</b></br></br>\n"+theLog.toString());
			
		} catch (Exception e) {
			log.error("Exception: " + e.getMessage(),e);
		}
		return("");
	}

	//Web operation
	public static String disabelAllUsersFromTheEnabledGroups(String movegroup) {
		try {
			
			String group = DAO.getIUMGroups();
			String groupDisabled = DAO.getIUMGroupsDisabled();
			
			String[] groups=null;
			String[] groupsDisabled=null;
			
			if (group!=null) {
				groups = group.split(",");
			}
			if (groupDisabled!=null) {
				groupsDisabled = groupDisabled.split(",");
			}
			StringBuffer theLog= new StringBuffer();
			
			for (int i=0; i<groups.length;i++) {
				group=groups[i];
				if (group.equals(movegroup)){
					theLog.append(moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
				}
			}  	
			return(theLog.toString());
		} catch (Exception e) {
		}
		return("");
	}


	public static boolean disableUserFromGroup(ApplicationUser user, Group groupEnabled, Group groupDisabled, boolean move) {
		return  disableUserFromGroup(user, groupEnabled, groupDisabled, move, false);
	}
	public static boolean disableUserFromGroup(ApplicationUser user, Group groupEnabled, Group groupDisabled, boolean move, boolean isWeb) {
		if (groupManager.isUserInGroup(user, groupEnabled)) {
			try {
				if(MOVE_USER || isWeb){
					if (!groupManager.isUserInGroup(user, groupDisabled)) {
						try {
							userUtil.addUserToGroup(groupDisabled, user);
							log.info("Add user={} to group={}", new Object[]{user.getUsername(),groupDisabled.getName()});
							if(log.isDebugEnabled()){
								log.debug("Add user={} to group={}", new Object[]{user.getUsername(),groupDisabled.getName()});
							}
						} catch (Exception e) {
							//TODO - fix it
							// Exception[addUserToGroup]: org.ofbiz.core.entity.GenericEntityException: while inserting: [GenericEntity:Membership][lowerChildName,mklucher][membershipType,GROUP_USER][parentName,ium_access][childName,mklucher][directoryId,10000][id,2009282][childId,10619][lowerParentName,ium_access][parentId,277448] (SQL Exception while executing the following:INSERT INTO public.cwd_membership (ID, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) (ERROR: duplicate key value violates unique constraint "uk_mem_dir_parent_child"
							//      Detail: Key (lower_parent_name, lower_child_name, membership_type, directory_id)=(ium_access, mklucher, GROUP_USER, 10000) already exists.))
							if (e.getMessage() != null && e.getMessage().indexOf("uk_mem_dir_parent_child") == -1) {
								log.debug("Exception[addUserToGroup]: " + e.getMessage(), e);
							}
						}
					}
				}

				if (move) {
					try {
						userUtil.removeUserFromGroup(groupEnabled, user);
						log.warn("Remove user={} from group={}", new Object[]{user.getUsername(), groupEnabled.getName()});
						/*
						if (log.isDebugEnabled()) {
							log.debug("Remove user={} from group={}", new Object[]{user.getUsername(), groupEnabled.getName()});
						}
						 */
					} catch (Exception e) {
						//TODO - fix it
						log.debug("Exception[removeUserFromGroup]: " + e.getMessage(), e);
						return false;
					}
				}

			} catch (Exception e) {
				log.error("Exception[disableUserFromGroup]: " + e.getMessage(), e);
				return false;
			}
		}

		return true;
	}

	
	public static synchronized CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
		ApplicationUser user = userManagerJira.getUserByName(userName);
		return(enableUserFromGroup(user, request));
	}

	public static CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request) {

		String groupEnableFound="";
		CurrentUser currentUser = new CurrentUser(null,0);
		Set<ApplicationRole> allowApplicationRoleSet = new HashSet<>();
		Set<ApplicationRole> unallowedApplicationRoleSet = new HashSet<>();

		try {
			String group = DAO.getIUMGroups();
			String groupDisabled = DAO.getIUMGroupsDisabled();
			String queueSizeTxt = DAO.getQueueSize();

			String[] enableGroupNames = group != null ? group.split(",") : null;
			String[] disableGroupNames = groupDisabled != null ? groupDisabled.split(",") : null;
			String[] queueSizes = queueSizeTxt != null ? queueSizeTxt.split(",") : null;

			if(enableGroupNames == null || disableGroupNames == null || queueSizes==null){
				return new CurrentUser(null,0);
			}

			Group[] enableGroups=new Group[enableGroupNames.length];
			Group[] disableGroups=new Group[enableGroupNames.length];

			//pre-processing
			for (int i=0; i<enableGroupNames.length;i++) {
				enableGroups[i] = groupManager.getGroup(enableGroupNames[i]);
				disableGroups[i] = groupManager.getGroup(disableGroupNames[i]);
			}


			for (int i=0; i<enableGroupNames.length;i++) {
				if(queueSizes[i]==null || queueSizes[i].length()==0){
					continue;
				}
				int queueSize = Integer.parseInt(queueSizes[i]);
				OldestUser oldestUserFound=null;

				boolean isInsideDisableGroup=groupManager.isUserInGroup(user, disableGroups[i]);
				if(!isInsideDisableGroup){
					if(log.isDebugEnabled()) {
						log.debug("User {} not belong disableGroups={}  ", new Object[]{user.getName(),disableGroups[i]});
					}
					continue;
				}

				boolean isInsideEnableGroups=groupManager.isUserInGroup(user, enableGroups[i]);
				//isInsideDisableGroup=true, isInsideEnableGroups=true/false

				//case 1. isInsideDisableGroup=true && isInsideEnableGroups=true
				if(isInsideEnableGroups){
					if(currentUser.user == null ){
						currentUser.user = user;
						currentUser.noOfUsers=queueSize;
					}
					allowApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));
					continue;
				}

				//case 2. isInsideDisableGroup=true && isInsideEnableGroups=false
				int noOfUsers = groupManager.getUsersInGroupCount(enableGroups[i]);
				if(log.isDebugEnabled()) {
					log.debug("Group Analyse {} noOfUsers={}  ", new Object[]{enableGroups[i].getName(),noOfUsers});
				}

				if ((queueSize != 0) && (noOfUsers >= queueSize)) {
					OldestUser oldestUser = disableOldestUser(enableGroups[i], disableGroups[i], user);
					//TODO couldn't be the same user because we search in different groups
					oldestUserFound = isDifferentUser(oldestUser, user);
				}
				if (currentUser.noOfUsers == 0) {
					currentUser.noOfUsers = queueSize;
				}

				if ((queueSize == 0) || (noOfUsers < queueSize) || (noOfUsers == queueSize && oldestUserFound!=null) ){
					boolean guard = true;
					try {
						if (!groupManager.isUserInGroup(user, enableGroups[i])) {
							try {
								userUtil.addUserToGroup( enableGroups[i],user);
								log.info("Add user={} to group={}  ", new Object[]{user.getUsername(),enableGroups[i].getName()});
								/*
								if(log.isDebugEnabled()) {
									log.debug("Add user={} to group={}  ", new Object[]{user.getUsername(),enableGroups[i].getName()});
								}
								*/
							} catch (Exception e) {
								//TODO - fix it
								// Exception[addUserToGroup]: org.ofbiz.core.entity.GenericEntityException: while inserting: [GenericEntity:Membership][lowerChildName,mklucher][membershipType,GROUP_USER][parentName,ium_access][childName,mklucher][directoryId,10000][id,2009282][childId,10619][lowerParentName,ium_access][parentId,277448] (SQL Exception while executing the following:INSERT INTO public.cwd_membership (ID, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) (ERROR: duplicate key value violates unique constraint "uk_mem_dir_parent_child"
								//      Detail: Key (lower_parent_name, lower_child_name, membership_type, directory_id)=(ium_access, mklucher, GROUP_USER, 10000) already exists.))
								if (e.getMessage() != null && e.getMessage().indexOf("uk_mem_dir_parent_child") == -1) {
									log.debug("Exception[addUserToGroup]: " + e.getMessage(), e);
								}
							}

						}
						groupEnableFound=enableGroupNames[i];

						if (MOVE_USER) {
							if (groupManager.isUserInGroup(user, disableGroups[i])) {
								try {
									userUtil.removeUserFromGroup(disableGroups[i], user);
									log.info("Remove user={} to group={}  ", new Object[]{user.getUsername(),disableGroups[i].getName()});
									/*
									if(log.isDebugEnabled()) {
										log.debug("Remove user={} to group={}  ", new Object[]{user.getUsername(),disableGroups[i].getName()});
									}
									*/
								} catch (Exception e) {
									log.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
								}
							}
						}

						allowApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));

						/////////////////applicationRoleManager.
						//should remove this user from ALL enable groups
						//if(oldestUserFound!=null && oldestUserFound.user!=null){
						//	doRemoveOldestUserForAllGroups(oldestUserFound.user,enableGroups);
						//}

					} catch (Exception e) {
						log.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
						guard = false;
					}

					if(currentUser.user == null){
						currentUser.user = guard ? user : null;
						currentUser.noOfUsers = queueSize;
					}

					if (log.isDebugEnabled()) {
						log.debug("Add user {} from group {} to group {} noOfUsers={} queueSize={}", new Object[]{user.getUsername(), disableGroups[i].getName(), enableGroups[i].getName(), noOfUsers, queueSize});
						if (MOVE_USER) {
							log.debug("Remove user {} from group {} noOfUsers={} queueSize={}", new Object[]{user.getUsername(), disableGroups[i].getName(), noOfUsers, queueSize});
						}
					}


				}
			}

			//try to add currentUser to all the groups that belong
			if(currentUser.user !=null){
				for (int i=0; i<enableGroups.length;i++) {
					if(queueSizes[i]==null || queueSizes[i].length()==0){
						continue;
					}
					if (groupManager.isUserInGroup(user,  disableGroups[i]) && !groupManager.isUserInGroup(user,  enableGroups[i])) {
						int queueSize = Integer.parseInt(queueSizes[i]);
						if (groupManager.getUsersInGroupCount(enableGroups[i]) < queueSize) {
							try {
								userUtil.addUserToGroup(enableGroups[i], user);
								if(log.isDebugEnabled()) {
									log.debug("AddEx user={} to group={}  ", new Object[]{user.getUsername(),enableGroups[i].getName()});
								}
							} catch (Exception e) {
								//TODO - fix it
								// Exception[addUserToGroup]: org.ofbiz.core.entity.GenericEntityException: while inserting: [GenericEntity:Membership][lowerChildName,mklucher][membershipType,GROUP_USER][parentName,ium_access][childName,mklucher][directoryId,10000][id,2009282][childId,10619][lowerParentName,ium_access][parentId,277448] (SQL Exception while executing the following:INSERT INTO public.cwd_membership (ID, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) (ERROR: duplicate key value violates unique constraint "uk_mem_dir_parent_child"
								//      Detail: Key (lower_parent_name, lower_child_name, membership_type, directory_id)=(ium_access, mklucher, GROUP_USER, 10000) already exists.))
								if (e.getMessage() != null && e.getMessage().indexOf("uk_mem_dir_parent_child") == -1) {
									log.debug("Exception[addUserToGroup]: " + e.getMessage(), e);
								}
							}

							if (MOVE_USER) {
								try {
									userUtil.removeUserFromGroup(disableGroups[i], user);
									if(log.isDebugEnabled()) {
										log.debug("RemoveEx user={} to group={}  ", new Object[]{user.getUsername(),disableGroups[i].getName()});
									}
								} catch (Exception e) {
									log.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
								}
							}
						} else {
							unallowedApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));
						}
					}
				}

				unallowedApplicationRoleSet.removeAll(allowApplicationRoleSet);
				currentUser.warningMessage = String.join(",", checkMissingRole(unallowedApplicationRoleSet));

			}

			return  currentUser;

		} catch (Exception e) {
			log.error("Error on processing group: "+groupEnableFound+":"+e.getMessage(),e);
		}

		//only on exception
		currentUser.user = null;
		return(new CurrentUser(null,0));
	}

	private static void doRemoveOldestUserForAllGroups(ApplicationUser user, Group[] groups) {
		for (int i=0; i<groups.length;i++) {

			if (groupManager.isUserInGroup(user, groups[i])) {
				try {
					userUtil.removeUserFromGroup(groups[i], user);
					if(log.isDebugEnabled()) {
						log.debug("Remove user={} to group={}  ", new Object[]{user.getUsername(),groups[i].getName()});
					}
				} catch (Exception e) {
					log.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
				}
			}
		}
	}

	private static OldestUser isDifferentUser(OldestUser oldestUserFound, ApplicationUser user) {
		if( (oldestUserFound == null) || oldestUserFound.user == null || oldestUserFound.user.getKey().equalsIgnoreCase(user.getKey())){
			return null;
		}

		return oldestUserFound;
	}

	private static List<String> checkMissingRole(Set<ApplicationRole> applicationRoleSet){
		List<String> roles= new ArrayList<>();
		long cnt=0;
		cnt= applicationRoleSet.stream().filter(applicationRole -> ApplicationKeys.SOFTWARE.equals(applicationRole.getKey())).count();
		if (cnt > 0) {
			roles.add(ApplicationKeys.SOFTWARE.value());
		}

		cnt= applicationRoleSet.stream().filter(applicationRole -> ApplicationKeys.SERVICE_DESK.equals(applicationRole.getKey())).count();
		if (cnt > 0) {
			roles.add(ApplicationKeys.SERVICE_DESK.value());
		}

		return roles;

	}

	@Deprecated
	private static List<String> checkMissingRole(ApplicationUser user){
		List<String> roles= new ArrayList<>();
		if(applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SOFTWARE)){
			roles.add(ApplicationKeys.SOFTWARE.value());
		}
		if(applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SERVICE_DESK)){
			roles.add(ApplicationKeys.SERVICE_DESK.value());
		}
		if(applicationAuthorizationService.canUseApplication(user,ApplicationKeys.CORE)){
			roles.add(ApplicationKeys.CORE.value());
		}

		return roles;

	}

	// Get oldest users from NavUser table regarding to given time reference
	public static List<OldestUser> getOldestUser(Group group, ApplicationUser appUser,Timestamp refTime,int cnt) {
		List<OldestUser> oldestUserList = new ArrayList<>();
		PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
		if(pocketRepository!=null) {
			List<NavUserDTO> navUsers = pocketRepository.getNavUserActiveForGroupLtTime(group.getName(), refTime, 0, cnt);

			for (NavUserDTO navUser:navUsers){

				if(navUser.getID()!=null){
					oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserName()),navUser.getLastAccessTime().getTime()));
				}else if(navUser.getUserNameEx()!=null){
					oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserNameEx()),0));
				}

				if(oldestUserList.size()>cnt){
					break;
				}
			}

		}
		Collections.sort(oldestUserList, OldestUser.TIME_ASC_COMPARATOR);
		return oldestUserList;
	}

	// Get oldest users from NavUser table
	public static List<OldestUser> getOldestUser(Group group, ApplicationUser appUser,int cnt) {
		List<OldestUser> oldestUserList = new ArrayList<>();

		PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

		if(pocketRepository!=null){
			List<NavUserDTO> navUsers=pocketRepository.getOldestUsers(group.getName(),0,cnt);

			for (NavUserDTO navUser:navUsers){
				if(navUser.getID()!=null){
					oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserName()),navUser.getLastAccessTime().getTime()));
				}else if(navUser.getUserNameEx()!=null){
					oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserNameEx()),0));
				}

				if(oldestUserList.size()>cnt){
					break;
				}
			}
		}
		Collections.sort(oldestUserList, OldestUser.TIME_ASC_COMPARATOR);
		return oldestUserList;
	}


	public static OldestUser disableOldestUser(Group groupEnabled, Group groupDisabled, ApplicationUser user) {
		long duration = Long.parseLong(DAO.getDuration()) * 1000 * 60;
		Timestamp refTime = new Timestamp(System.currentTimeMillis()-duration);
		long now = new Timestamp(System.currentTimeMillis()).getTime();

		List<OldestUser> oldestUserList = getOldestUser(groupEnabled, user, refTime, 10);

		if(oldestUserList.size()>0) {
			for (OldestUser oldestUser : oldestUserList) {
				if ((oldestUser != null) && (oldestUser.user != null)) {
					long diff = (now - oldestUser.ts); //diff in milliseconds

					if ((oldestUser.ts == 0L) || (duration == 0L) || (diff > duration)) {
						if (log.isDebugEnabled()) {
							log.debug("disableOldestUser oldestUser={}  diff={} duration={}", new Object[]{oldestUser.user.getUsername(), diff, duration});
						}
						if (disableUserFromGroup(oldestUser.user, groupEnabled, groupDisabled, true)) {
							return (oldestUser);
						}
					}
				}
			}
		}
		if (log.isDebugEnabled()) {
			log.debug("disableOldestUser NO oldest user that {} ", new Object[]{user.getUsername()});
		}
		return (new OldestUser(user,0));// return user himself
	}

	@Deprecated
	public static String getLastViewedForUsersInGroup() {
		List<String> group = Arrays.asList(DAO.getIUMGroups());
		SortedSet<ApplicationUser> users = userUtil.getAllUsersInGroupNames(group);
		StringBuffer res = new StringBuffer();

		for (ApplicationUser user : users) {
			res.append("Login Test:" + user.getUsername() + ":" + getlastViewByUser(user) + "\n");

		}
		return (res.toString());
	}

	private static Long getLongTimestampForIssueAndUser(ApplicationUser user, Long id) {
		// This should be in memory all ready so shouldn't be expensive
		final List<UserHistoryItem> fullHistory = historyManager.getFullIssueHistoryWithoutPermissionChecks(user);
		for (UserHistoryItem historyItem : fullHistory) {
			if (id.toString().equals(historyItem.getEntityId())) {
				return historyItem.getLastViewed();
			}
		}
		return null;
	}

	
	public static long getLastLoginFromUser(ApplicationUser user) {
		UserWithAttributes theUser = crowdService.getUserWithAttributes(user.getName());
		String lastLoginMillisStr = theUser.getValue("login.lastLoginMillis");
		return(getLong(lastLoginMillisStr));
	}

	public static long getlastViewByUser(ApplicationUser user) {
		Long lastViewed =0L;
		long lastLogin=getUserTS(user.getName()); // added 15.12.2021 by Heiko Gerlach to be able to tack usage properly
		if (lastLogin==0L) {
			lastLogin=getLastLoginFromUser(user);
		}
		
		// add last login in case there is no last viewed issue
		
		// For better performance this will become 2 step. First get the last viewed
		// issue, than look for the details,
		
		List<Issue> theHistory = historyManager.getShortIssueHistory(user);
		if (theHistory.size() == 0) {
			lastViewed=0L;
		} else {
				Issue userCurrentIssue = historyManager.getShortIssueHistory(user).get(0);
				if (userCurrentIssue == null) {
					lastViewed=0L;
				} else {
					lastViewed = getLongTimestampForIssueAndUser(user, userCurrentIssue.getId());
				}
		}		
		if (lastViewed>lastLogin) {
			return (lastViewed);
		} else {
			return (lastLogin);	
		}
	}
	
	public static long getlastViewByUserPld(ApplicationUser user) {

		// For better performance this will become 2 step. First get the last viewed
		// issue, than look for the details,
		
		List<Issue> theHistory = historyManager.getShortIssueHistory(user);
		if (theHistory.size() == 0) {
			return (0L);
		}

		Issue userCurrentIssue = historyManager.getShortIssueHistory(user).get(0);
		if (userCurrentIssue == null) {
			return (0l);
		}	
		Long lastViewed = getLongTimestampForIssueAndUser(user, userCurrentIssue.getId());
		return (lastViewed);
	}
	
	private static List<ApplicationUser> getAllUsers() {
		UserSearchParams userSearchParams = (new UserSearchParams.Builder()).allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(100000).build();
		return(userSearchService.findUsers("", userSearchParams));
	}

	@Deprecated
	public static List<OldestUser> getSortedUserList(int max) {
		List<ApplicationUser> allUsers=getAllUsers();
		final List<OldestUser> userList = new ArrayList<OldestUser>();
		
		for (ApplicationUser user: allUsers) {
			long ts=getlastViewByUser(user);
			OldestUser oUser=new OldestUser(user, ts);
			userList.add(oUser);
		}
		Collections.sort(userList, new Comparator<OldestUser>() {
		    @Override
		    public int compare(OldestUser o1, OldestUser o2) {
		        return o1.ts.compareTo(o2.ts);
		    }
		});
		int count=0;
		for (OldestUser o: userList) {
			if ((max>0) && (count>=max)) {
				userList.remove(count);
			}
			count++;
		}
		return(userList);
	}
	
	@Deprecated
	public static List<OldestUser> getSortedUserListFromGroup(String group, int offset,int cnt, String filtergroup) {

		PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

		List<NavUserDTO> navUserList =  pocketRepository.getOldestUsers(group,filtergroup, offset, cnt );
		final List<OldestUser> tmpUserList = new ArrayList<OldestUser>();

		for (NavUserDTO navUser: navUserList) {

			ApplicationUser user=userManagerJira.getUserByName(navUser.getUserNameEx()!=null ? navUser.getUserNameEx():navUser.getUserName());
			if (user!=null && user.isActive()) {
				OldestUser oUser=new OldestUser(user, navUser.getLastAccessTime() == null ? 0 : navUser.getLastAccessTime().getTime());
				tmpUserList.add(oUser);
			}
			if(tmpUserList.size()>cnt){
				break;
			}
		}

		return(tmpUserList);

	}

	@Deprecated
	public static List<OldestUser> _getSortedUserListFromGroup(String group, int max, String filtergroup) {
		Collection<String> allUsers = groupManager.getUserNamesInGroup(group);
		Collection<String> filterUsers = groupManager.getUserNamesInGroup(filtergroup);

		final List<OldestUser> userList = new ArrayList<OldestUser>();

		int numAll=0;
		int numFilter=0;

		if (allUsers==null){
			return(userList);
		}
		Collection<String> theUsers;
		if ("".equals(filtergroup)){
			theUsers=allUsers;
		} else {
			numAll=allUsers.size();

			if (filterUsers!=null){
				numFilter=filterUsers.size();
			}
			if ((numFilter==0) || (numAll==0)) {
				return(userList); // no match since group is empty
			} else 	if ((numAll>0) && (numFilter>numAll)) { // selected smaller group for better performance
				theUsers=groupManager.filterUsersInAllGroupsDirect(allUsers, Arrays.asList(filtergroup));
			} else {
				theUsers=groupManager.filterUsersInAllGroupsDirect(filterUsers, Arrays.asList(group));
			}
		}

		final List<OldestUser> tmpUserList = new ArrayList<OldestUser>();

		for (String userName: theUsers) {
			ApplicationUser user=userManagerJira.getUserByName(userName);
			if (user.isActive()) {
				long ts=getlastViewByUser(user);
				OldestUser oUser=new OldestUser(user, ts);
				tmpUserList.add(oUser);
			}
		}
		Collections.sort(tmpUserList, new Comparator<OldestUser>() {
			@Override
			public int compare(OldestUser o1, OldestUser o2) {
				return o1.ts.compareTo(o2.ts);
			}
		});
		int count=0;
		for (OldestUser o: tmpUserList) {
			if ((max==0) ||  (count<max)) {
				userList.add(o);
			}
			count++;
		}
		return(userList);
	}

	public static void moveUserToDisabled(ApplicationUser user) {
		String group = DAO.getIUMGroups();
		String groupDisabled = DAO.getIUMGroupsDisabled();
		
		String[] groups=null;
		String[] groupsDisabled=null;
		
		if (group!=null) {
			groups = group.split(",");
		}
		if (groupDisabled!=null) {
			groupsDisabled = groupDisabled.split(",");
		}
		// the user is originally in the 
		for (int i=0; i<groups.length;i++) {
			if (groupManager.isUserInGroup(user, groups[i])) {
				Group theGroup = groupManager.getGroup(groups[i]);
				Group theGroupDisabled = groupManager.getGroup(groupsDisabled[i]);
				if ((theGroup!=null) && (theGroupDisabled!=null)) {
					// remove user from ium_enable + add ium_disable
					disableUserFromGroup(user, theGroup, theGroupDisabled, true);
				}	
			}
		}  	
	}

	/*
	* return true if put user in the groupManager cache structure
	**/
	public static boolean simulateUserToEnabledGroup(ApplicationUser user) {
		String groupEnabled = DAO.getIUMGroups();
		String groupDisabled = DAO.getIUMGroupsDisabled();

		if (groupEnabled ==null || groupDisabled ==null ) {
			return false;
		}
		boolean retVal = false;
		String[] groupsEnabled=groupEnabled.split(",");
		String[] groupsDisabled=groupDisabled.split(",");

		// the user is originally in the
		for (int i=0; i<groupsDisabled.length;i++) {
			if (groupManager.isUserInGroup(user, groupsDisabled[i])) {
				Group theEnabledGroup = groupManager.getGroup(groupsEnabled[i]);
				Group theDisableGroup = groupManager.getGroup(groupsDisabled[i]);

				Field field=null;

				try {
					//1. usernameToGroups = usernameToGroups + theEnabledGroup
					//  private final RequestCache<String, Set<Group>> usernameToGroups;
					field = FieldUtils.getField(groupManager.getClass(),"usernameToGroups",true);
					field.setAccessible(true);
					RequestCache<String, Set<Group>> usernameToGroups=(RequestCache<String, Set<Group>>)field.get(groupManager);

					Set<Group> grp1 = new ImmutableSet.Builder<Group>()
							.addAll(usernameToGroups.get(user.getUsername()))
							.add(theEnabledGroup)
							.build();

					usernameToGroups.remove(user.getUsername());
					usernameToGroups.get(user.getUsername(),() -> grp1);

					//2. usernameToGroupNames = usernameToGroupNames + theEnabledGroup
					//private final RequestCache<String, Set<String>> usernameToGroupNames;
					field = FieldUtils.getField(groupManager.getClass(),"usernameToGroupNames",true);
					field.setAccessible(true);
					RequestCache<String, Set<String>> usernameToGroupNames=(RequestCache<String, Set<String>>)field.get(groupManager);

					Set<String> grp2 = new ImmutableSet.Builder<String>()
							.addAll(usernameToGroupNames.get(user.getUsername()))
							.add(theEnabledGroup.getName())
							.build();

					usernameToGroupNames.remove(user.getUsername());
					usernameToGroupNames.get(user.getUsername(),() -> grp2);

					//3. usernameToGroupNamesInLowerCase = usernameToGroupNamesInLowerCase + LowerCase(theEnabledGroup)
					//private final RequestCache<String, Set<String>> usernameToGroupNamesInLowerCase;
					field = FieldUtils.getField(groupManager.getClass(),"usernameToGroupNamesInLowerCase",true);
					field.setAccessible(true);
					RequestCache<String, Set<String>> usernameToGroupNamesInLowerCase=(RequestCache<String, Set<String>>)field.get(groupManager);

					Set<String> grp3 = new ImmutableSet.Builder<String>()
							.addAll(usernameToGroupNamesInLowerCase.get(user.getUsername()))
							.add(theEnabledGroup.getName().toLowerCase())
							.build();

					usernameToGroupNamesInLowerCase.remove(user.getUsername());
					usernameToGroupNamesInLowerCase.get(user.getUsername(),() -> grp3);
					retVal= true;
				} catch (IllegalAccessException e) {
					log.error("Exception "+e.getMessage(),e);
					return false;
				}
				if(log.isDebugEnabled()) {
					log.debug("Verify Move[simulate] {} isIumEnabled={}  isIumDisabled={} ", new Object[]{user.getUsername(),
							IntelligentUserManagerHelper.isUserInGroups(user, groupsEnabled[i]),
							IntelligentUserManagerHelper.isUserInGroups(user, groupsDisabled[i])});
				}

			}


		}
		return retVal;
	}
	public static Quota getQuotaForGroupOfUsername(String username) {
		int quota=0;
		String groupDisabled = DAO.getIUMGroupsDisabled();
		String queueSizeTxt = DAO.getQueueSize();
		String groupEnabled = DAO.getIUMGroups();


		if (groupEnabled ==null ||  groupDisabled==null || queueSizeTxt==null) {
			return Quota.Empty;
		}

		String[] groupsDisabled=groupDisabled.split(",");
		String[] groupsEnabled =groupEnabled.split(",");
		String[] queueSizes = queueSizeTxt.split(",");

		for (int i=0; i<groupsDisabled.length;i++) {
			if(queueSizes[i]==null || queueSizes[i].length()==0){
				continue;
			}

			if (groupManager.isUserInGroup(username, groupsDisabled[i])) {
				return new Quota(Integer.parseInt(queueSizes[i]),groupManager.getUsersInGroupCount(groupsEnabled[i]));
			}
		}

		return Quota.Empty;

	}
	public static Quota checkCanGetFreeSlots(String username) {
		String groupDisabled = DAO.getIUMGroupsDisabled();
		String queueSizeTxt = DAO.getQueueSize();
		String groupEnabled = DAO.getIUMGroups();


		if (groupEnabled ==null ||  groupDisabled==null || queueSizeTxt==null) {
			return Quota.Empty;
		}

		String[] groupsDisabled=groupDisabled.split(",");
		String[] groupsEnabled =groupEnabled.split(",");
		String[] queueSizes = queueSizeTxt.split(",");

		for (int i=0; i<groupsDisabled.length;i++) {
			if(queueSizes[i]==null || queueSizes[i].length()==0){
				continue;
			}
			int qs = Integer.parseInt(queueSizes[i]);
			int queue=0;
			if (groupManager.isUserInGroup(username, groupsDisabled[i]) &&
					( (queue=groupManager.getUsersInGroupCount(groupsEnabled[i]))<qs)) {

				return new Quota(qs,qs-queue);
			}
			if (groupManager.isUserInGroup(username, groupsEnabled[i])) {
				return new Quota(qs,1);
			}
		}

		return Quota.Empty;

	}
}
