package de.accxia.jira.addon.IUM.impl;

import javax.inject.Inject;
import javax.inject.Named;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;

import de.accxia.jira.addon.IUM.api.IntelligentUserManagerPluginComponent;

@ExportAsService ({IntelligentUserManagerPluginComponent.class})
@Named ("IntelligentUserManagerPluginComponent")
public class IntelligentUserManagerPluginComponentImpl implements IntelligentUserManagerPluginComponent
{
    @ComponentImport
    private final ApplicationProperties applicationProperties;

    @Inject
    public IntelligentUserManagerPluginComponentImpl(final ApplicationProperties applicationProperties)
    {
        this.applicationProperties = applicationProperties;
    }

    public String getName()
    {
        if(null != applicationProperties)
        {
            return "IUMComponent:" + applicationProperties.getDisplayName();
        }
        
        return "IUMComponent";
    }
}