package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Deprecated
public class IUMClusterJob2 implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob2.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static IUMClusterJob2 instance;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private JobSyncService jobSyncService;
    private IUMClusterJob2(){}

    //singleton pattern
    public static IUMClusterJob2 getInstance() {
        if (instance == null)
            instance = new IUMClusterJob2();

        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository){
        this.instance.pocketRepository=pocketRepository;
        this.instance.jobResultRepository=jobResultRepository;
        this.instance.jobSyncService=jobSyncService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Process #[" + SDF.format(new java.util.Date())+"] " );
        }
        List<ProcessResult> processResultList = new ArrayList<>();

        long inactivityInterval = (Long) parameters.get(JobData.USER_INACTIVITY_INTERVAL);
        if (inactivityInterval <= 0) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }

        String enableGroups = (String) parameters.get(JobData.ENABLE_GROUPS);
        //String disableGroups =(String) parameters.get(JobData.DISABLE_GROUPS);

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMClusterJob2 Process with groups={} interval={} at [ {} ] ",new Object[]{
                    enableGroups,
                    inactivityInterval,
                    SDF.format(new Date())
            });
        }

        ProcessResult processResult = new ProcessResult( Process.CLEAN_JOB, (String) parameters.get(JobData.ENABLE_GROUPS),(String) parameters.get(JobData.DISABLE_GROUPS));

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMClusterJob2 Process with groups={} interval={} at [ {} ] ", new Object[]{
                    enableGroups,
                    inactivityInterval,
                    SDF.format(new java.util.Date())
            });
        }

        GroupManager groupManager = ComponentAccessor.getGroupManager();
        UserManager userManager = ComponentAccessor.getUserManager();
        UserUtil userUtil = ComponentAccessor.getUserUtil();

        //all enabled users
        Map<String, List<IUMClusterJob2.UserActive>> usersEnabled = new HashMap<>();
        Map<String,List<String>> usersSession = new HashMap<>();

        if (!isEmpty(enableGroups)) {

            Arrays.stream(enableGroups.split(",")).forEach(group -> {
                groupManager.getUserNamesInGroup(group).stream().forEach(username -> {
                    doAddUserActive(username,group, usersEnabled);
                });
            });


            if (LOG.isDebugEnabled()) {
                LOG.debug("Verify enabled users count #" +usersEnabled.size());
                if(usersEnabled.size()>0){
                    LOG.debug("Verify " +usersEnabled.keySet().stream().collect(Collectors.joining(",")));
                }
            }

            processResult.setUserRemoved(0);
            if(usersEnabled.size()>0) {
                long now = new Date().getTime();
                for (String ukey : usersEnabled.keySet()) {
                    ApplicationUser user = userManager.getUserByName(ukey);
                    long lastViewByUser = IntelligentUserManagerHelper.getlastViewByUserPld(user);
                    if (lastViewByUser > 0 && (now - lastViewByUser < inactivityInterval)) {
                        usersEnabled.put(ukey, null);
                    }else{
                        List<IUMClusterJob2.UserActive> userActiveList = usersEnabled.get(ukey);

                        if(userActiveList!=null && userActiveList.size()>0){
                            for (IUMClusterJob2.UserActive userActive:userActiveList){
                                try {
                                    userUtil.removeUserFromGroup(groupManager.getGroup(userActive.group), userManager.getUserByName(ukey));
                                    processResult.setUserRemoved(processResult.getUserRemoved()+1);

                                    if (LOG.isInfoEnabled()) {
                                        LOG.info("IUMClusterJob2 removed user {} from group {} ", new Object[]{ukey, userActive.group});
                                    }
                                } catch (Exception e) {
                                    LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
            }


            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMClusterJob2 Processed #[" + SDF.format(new java.util.Date())+"] " );
            }
        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMClusterJob Processed #[" + SDF.format(new java.util.Date())+"] " );
        }

        processResultList.add(processResult);
        return processResultList;

    }

    private void doAddUserActive(String username, String group, Map<String, List<IUMClusterJob2.UserActive>> usersEnabled) {
        if(!usersEnabled.containsKey(username)){
            usersEnabled.put(username,new ArrayList<>());
        }
        List<IUMClusterJob2.UserActive> userActiveList = usersEnabled.get(username);
        userActiveList.add(new IUMClusterJob2.UserActive(group));
    }

    private static boolean isEmpty(String value){
        return value == null || value.length()==0;
    }

    class UserActive {
        String group;
        Boolean active = false;

        List<String> sessions = new ArrayList<>();

        public UserActive(String group) {
            this.group = group;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IUMClusterJob2.UserActive that = (IUMClusterJob2.UserActive) o;

            if (group != null ? !group.equals(that.group) : that.group != null) return false;
            return active != null ? active.equals(that.active) : that.active == null;
        }

        @Override
        public int hashCode() {
            int result = group != null ? group.hashCode() : 0;
            result = 31 * result + (active != null ? active.hashCode() : 0);
            return result;
        }
    }
}

