package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.config.DAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class JobDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JobDataUtils.class);

    public static JobData createJobData(String startingFrom, String repeatInterval,String userInactiveInterval, String enableGroups, String disableGroups) {
        JobData jobData = new JobData();
        try{
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setStartingFrom(JobData.DEFAULT_STARTING_FROM);
        }

        try{
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(JobData.DEFAULT_REPEAT_INTERVAL));
        }
        try{
            jobData.setUserInactivityInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(userInactiveInterval)));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setUserInactivityInterval(JobData.DEFAULT_USER_INACTIVITY_INTERVAL);
        }

        jobData.getParameters().put(JobData.REPEAT_INTERVAL,jobData.getRepeatInterval());
        jobData.getParameters().put(JobData.STARTING_FROM,jobData.getStartingFrom());

        jobData.getParameters().put(JobData.USER_INACTIVITY_INTERVAL,jobData.getUserInactivityInterval());
        jobData.getParameters().put(JobData.ENABLE_GROUPS,enableGroups);
        jobData.getParameters().put(JobData.DISABLE_GROUPS,disableGroups);

        return jobData;
    }

    public static JobData createSyncJobData(String startingFrom, String repeatInterval, String enableGroups, String disableGroups, String enableGroups2, String disableGroups2) {
        JobData jobData = new JobData();
        try{
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setStartingFrom(JobData.DEFAULT_STARTING_FROM);
        }

        try{
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(JobData.DEFAULT_REPEAT_INTERVAL));
        }


        jobData.getParameters().put(JobData.SYNC_REPEAT_INTERVAL,jobData.getRepeatInterval());
        jobData.getParameters().put(JobData.SYNC_STARTING_FROM,jobData.getStartingFrom());

        jobData.getParameters().put(JobData.SYNC_SOFTWARE_SRC_GROUP,enableGroups);
        jobData.getParameters().put(JobData.SYNC_SOFTWARE_TARGET_GROUP,disableGroups);
        jobData.getParameters().put(JobData.SYNC_SDESK_SRC_GROUP,enableGroups2);
        jobData.getParameters().put(JobData.SYNC_SDESK_TARGET_GROUP,disableGroups2);

        JiraAuthenticationContext jiraAuthenticationContext=  ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put(JobData.CURRENT_USER, jiraAuthenticationContext.getLoggedInUser() !=null ? jiraAuthenticationContext.getLoggedInUser().getUsername()  : "IUMPlugin");

        return jobData;
    }

    public static JobData createDailyJobData() {
        JobData jobData = new JobData();
        //    Date date = new Date();
        //    int startingFrom = date.getHours();
        //    long repeatInterval =2;

        int startingFrom =2;        //  02:00 AM
        long repeatInterval =60*24; // 24h

        try{
            jobData.setStartingFrom(startingFrom);
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setStartingFrom(JobData.DEFAULT_STARTING_FROM);
        }

        try{
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(JobData.DEFAULT_REPEAT_INTERVAL));
        }

        JiraAuthenticationContext jiraAuthenticationContext=  ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put(JobData.CURRENT_USER, jiraAuthenticationContext.getLoggedInUser() !=null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin");


        return jobData;

    }


    public static JobData createIUMJobData() {
        return createJobData(DAO.getStartingFrom(), DAO.getRepeatInterval(),DAO.getInactivityDuration(),DAO.getIUMGroups(),DAO.getIUMGroupsDisabled());
    }
    public static JobData createIUMSyncJobData() {
        return createSyncJobData(DAO.getSyncStartingFrom(), DAO.getSyncRepeatInterval(), DAO.getSyncSoftwareSrcGoups(),DAO.getSyncSoftwareTargetGoups()
                , DAO.getSyncSDeskSrcGoups(),DAO.getSyncSDeskTargetGoups());
    }

    public static JobData createFakeIUMJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10*1000);
        jobData.setUserInactivityInterval(30*1000);


        jobData.getParameters().put(JobData.REPEAT_INTERVAL,jobData.getRepeatInterval());
        jobData.getParameters().put(JobData.STARTING_FROM,jobData.getStartingFrom());

        jobData.getParameters().put(JobData.USER_INACTIVITY_INTERVAL,jobData.getUserInactivityInterval());
        jobData.getParameters().put(JobData.ENABLE_GROUPS,DAO.getIUMGroups());
        jobData.getParameters().put(JobData.DISABLE_GROUPS,DAO.getIUMGroupsDisabled());

        //jobData.getParameters().put(JobData.JOB_NEXT_RUN,new Date());
        return jobData;
    }

    public static JobData createFakeIUMSyncJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10*1000);
        jobData.setUserInactivityInterval(30*1000);


        jobData.getParameters().put(JobData.SYNC_REPEAT_INTERVAL,jobData.getRepeatInterval());
        jobData.getParameters().put(JobData.SYNC_STARTING_FROM,jobData.getStartingFrom());

        jobData.getParameters().put(JobData.SYNC_SOFTWARE_SRC_GROUP,"SrcGroup");
        jobData.getParameters().put(JobData.SYNC_SOFTWARE_TARGET_GROUP,"DestGroup");

        jobData.getParameters().put(JobData.SYNC_SDESK_SRC_GROUP,"SrcGroup2");
        jobData.getParameters().put(JobData.SYNC_SDESK_TARGET_GROUP,"DestGroup2");

        JiraAuthenticationContext jiraAuthenticationContext=  ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put(JobData.CURRENT_USER, jiraAuthenticationContext.getLoggedInUser() !=null ? jiraAuthenticationContext.getLoggedInUser().getUsername()  : "IUMPlugin");
        //jobData.getParameters().put(JobData.JOB_NEXT_RUN,new Date());
        return jobData;
    }

    public static JobData createIUMDailyJobData() {
        return createDailyJobData();
    }

    public static JobData createFakeIUMDailyJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval =1;

        try{
            jobData.setStartingFrom(startingFrom);
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setStartingFrom(JobData.DEFAULT_STARTING_FROM);
        }

        try{
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(JobData.DEFAULT_REPEAT_INTERVAL));
        }

        JiraAuthenticationContext jiraAuthenticationContext=  ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put(JobData.CURRENT_USER, jiraAuthenticationContext.getLoggedInUser() !=null ? jiraAuthenticationContext.getLoggedInUser().getUsername()  : "IUMPlugin");


        return jobData;
    }

    /*Convert hours --> mills */
    public static long hours2millis(long hours){
        try {
            return TimeUnit.HOURS.toMillis(hours);
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
        }
        return 0;
    }

    public static long hours2millis(String hours){
        try {
            return TimeUnit.HOURS.toMillis(Long.parseLong(hours));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
        }
        return 0;
    }

    /*Convert mills --> hours */
    public static long toHours(String mills){
        if(mills!=null){
            try {
                return TimeUnit.MILLISECONDS.toHours(Long.parseLong(mills));
            }catch (Exception e){
                LOG.error("Exception: "+e.getMessage(),e);
            }
        }
        return 0;
    }

    /*Convert minutes --> mills */
    public static long minutes2millis(long minutes){
        try {
            return TimeUnit.MINUTES.toMillis(minutes);
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
        }
        return 0;
    }

    public static long minutes2millis(String minutes){
        try {
            return TimeUnit.MINUTES.toMillis(Long.parseLong(minutes));
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
        }
        return 0;
    }


    /*Convert mills --> minutes */
    public static long toMinutes(String mills){
        if(mills!=null){
            try {
                return TimeUnit.MILLISECONDS.toMinutes(Long.parseLong(mills));
            }catch (Exception e){
                LOG.error("Exception: "+e.getMessage(),e);
            }
        }

        return 0;
    }

    /*Convert mills --> minutes */
    public static long toLong(String numbr){
        if(numbr!=null){
            try {
                return Long.parseLong(numbr);
            }catch (Exception e){
                LOG.error("Exception: "+e.getMessage(),e);
            }
        }

        return 0;
    }



}
