package de.accxia.jira.addon.IUM.job;

import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;

import javax.annotation.Nonnull;
import java.io.Serializable;
import java.util.Date;

public class RunDetailsBean implements Serializable {

    private Date startTime;
    private long durationInMillis;
    private RunOutcome runOutcome;
    private String message;

    public RunDetailsBean(RunDetails runDetails) {
        if(runDetails!=null){
            this.startTime=runDetails.getStartTime();
            this.durationInMillis=runDetails.getDurationInMillis();
            this.runOutcome=runDetails.getRunOutcome();
            this.message=runDetails.getMessage();
        }

    }

    public Date getStartTime() {
        return startTime;
    }

    public long getDurationInMillis() {
        return durationInMillis;
    }

    public RunOutcome getRunOutcome() {
        return runOutcome;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "RunDetailsBean{" +
                "startTime=" + startTime +
                ", durationInMillis=" + durationInMillis +
                ", runOutcome=" + runOutcome +
                ", message='" + message + '\'' +
                '}';
    }
}
