package de.accxia.jira.addon.IUM.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@ExportAsService({JobResultRepository.class})
@Named("JobResultRepository")
public class JobResultRepository {
    private static final Logger logger = LoggerFactory.getLogger(JobResultRepository.class);

    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public JobResultRepository(final ActiveObjects ao) {
        this.ao = ao;
    }

    public JobResult save(JobResultDTO jobResultDTO) {
        logger.debug("Called save for user {}", jobResultDTO.getUserName());
        final Map<String, Object> values = new HashMap<String, Object>();
        values.put(JobResult.USER_NAME,jobResultDTO.getUserName());
        values.put(JobResult.USER_COPIED,jobResultDTO.getUserCopied());
        values.put(JobResult.USER_REMOVED,jobResultDTO.getUserRemoved());
        values.put(JobResult.SOURCE_GROUPS,jobResultDTO.getSourceGroups());
        values.put(JobResult.TARGET_GROUP,jobResultDTO.getTargetGroup());
        values.put(JobResult.START_TIME,jobResultDTO.getStartTime());
        values.put(JobResult.END_TIME,jobResultDTO.getEndTime());
        values.put(JobResult.PROCESS,jobResultDTO.getProcess());
        JobResult response =  ao.create(JobResult.class, values);

        logger.debug("Successfully save for user {}",  jobResultDTO.getUserName());
        return response;
    }


    public JobResult[] getByUserName(String userName) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getByUserName for userName {} ", userName);
        }

        final JobResult[] queryResult = ao.find(
                JobResult.class, Query.select().where(JobResult.USER_NAME + " = ? ", userName)
                        .order(JobResult.ID +" DESC"));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for userName {} ", userName);
        }

        return queryResult;
    }

    public JobResult[] getByUserName(String userName,int idx,int ctx) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getByUserName for userName {} ", userName);
        }

        final JobResult[] queryResult = ao.find(
                JobResult.class, Query.select().where(JobResult.USER_NAME + " = ? ", userName)
                        .order(JobResult.ID +" DESC")
                        .offset(idx)
                        .limit(ctx));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for userName {} ", userName);
        }

        return queryResult;
    }

    public JobResult[] findAll(int idx,int ctx) {
        if(logger.isDebugEnabled()){
            logger.debug("Called findAll from  {} to {}", idx,ctx);
        }

        final JobResult[] queryResult = ao.find(
                JobResult.class, Query.select()
                        .order(JobResult.ID +" DESC")
                        .offset(idx)
                        .limit(ctx));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully findAll from  {} to {}", idx,ctx);
        }

        return queryResult;
    }

    public JobResult[] findAll(String process[], int idx,int ctx) {
        if(logger.isDebugEnabled()){
            logger.debug("Called findAll from  {} to {}", idx,ctx);
        }

        final JobResult[] queryResult = ao.find(
                JobResult.class, Query.select().where(JobResult.PROCESS + " in ( ? ) ",Arrays.stream(process).collect(Collectors.joining(",")))
                        .order(JobResult.ID +" DESC")
                        .offset(idx)
                        .limit(ctx));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully findAll from  {} to {}", idx,ctx);
        }

        return queryResult;
    }

}
