package de.accxia.jira.addon.IUM.search;


import com.atlassian.crowd.embedded.api.Group;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class GroupBean {

    String name;

    public GroupBean(String name) {
        this.name = name;
    }

    public GroupBean(Group group){
        this.name=group.getName();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static GroupBean convertToGroupBean(Group group){
        GroupBean groupBean= new GroupBean(group.getName());
        return groupBean;
    }
    public static List<GroupBean> convertToGroupBeans(List<Group> groups){
        List<GroupBean> groupBeanList = new ArrayList<>();
        for (Group group:groups){
            groupBeanList.add(convertToGroupBean(group));
        }
        return groupBeanList;
    }
}
