package de.accxia.jira.addon.IUM.search;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.JiraCollectionUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.*;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
/**
 * GET/POST
 * https://aurelian-jira.accxia.com/rest/IUM/latest/gsearch/groups?searchTerm=ium
 *
 * vs
 *
 * https://aurelian-jira.accxia.com/rest/api/2/groups/picker?query=ium&_=1706293657801
 */

@Path("/gsearch")
@Consumes({ MediaType.TEXT_HTML, MediaType.APPLICATION_JSON})
@Produces({ MediaType.APPLICATION_JSON })
@Scanned
public class SearchRestController {
    private static final Logger LOG = LoggerFactory.getLogger(SearchRestController.class);
    public static final String QUERY="searchTerm";

    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final GroupManager groupManager;
    //TODO GlobalPermissionGroupAssociationUtil
    //TODO GlobalPermissionManager

    public SearchRestController( CrowdService crowdService, GroupManager groupManager) {
        this.crowdService = crowdService;
        this.groupManager = groupManager;
        this.applicationRoleManager= ComponentLocator.getComponent(ApplicationRoleManager.class);
    }

    @Path("/groups")
    @GET
    @Produces({MediaType.APPLICATION_JSON})
    public Response searchByGroupName(@QueryParam(QUERY) String searchTerm) {
        List<Group> groups;
        try {
            //Groups with license
            Set<Group> groupSet = this.applicationRoleManager.getGroupsForLicensedRoles();
            if (StringUtils.isBlank(searchTerm)) {
                groups = new ArrayList<>(getAllGroups(groupSet.size() * 2));
            } else {
                groups = new ArrayList<>(getAllGroups(searchTerm, groupSet.size() * 2));
            }

            groups = filterNoAccessGroupName(groups, groupSet);
            return Response.ok(convertResultsToSelect2(groups)).build();
        } catch (Exception e) {
            LOG.info("Group search failed: " + e.getMessage(), e);
            return Response.status(Response.Status.BAD_REQUEST).entity(e.getMessage()).build();
        }
    }

    private GroupResults convertResultsToSelect2(List<Group> groups){
        GroupResults groupResults = new GroupResults(GroupBean.convertToGroupBeans(groups));
        return groupResults;
    }

    private List<Group> filterNoAccessGroupName(List<Group> groups,Set<Group> groupSet) {
        Map<String, String> mapJiraGroups= groupSet.stream().collect(Collectors.toMap(Group::getName, Group::getName));
        List<Group> filterGroups = groups.stream().filter(grp->!mapJiraGroups.containsKey(grp.getName())).limit(10).collect(Collectors.toList());
        return filterGroups;
    }

    public Collection<Group> getAllGroups(int maxResults) {
        SearchRestriction restriction = NullRestrictionImpl.INSTANCE;
        Query<Group> query = new GroupQuery(Group.class, GroupType.GROUP, restriction, 0, (maxResults<10 ? 10 : maxResults));
        return JiraCollectionUtils.convertIterableToCollection(this.crowdService.search(query));
    }

    public Collection<Group> getAllGroups(String searchTerm , int maxResults) {
        TermRestriction termRestriction= new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS,searchTerm);
        final Query<Group> groupQuery = new GroupQuery<Group>(Group.class,
                GroupType.GROUP, termRestriction, 0, (maxResults<10 ? 10 : maxResults));

        return JiraCollectionUtils.convertIterableToCollection(this.crowdService.search(groupQuery));
    }
}
