package de.accxia.jira.addon.IUM.side;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.Quota;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.side.VerifyMessage.License_Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * REST service for getting license for given project key.
 * 
 * @author Heiko Gerlach
 */
@Path("/")
@Consumes({ MediaType.TEXT_HTML})
@Produces({ MediaType.TEXT_PLAIN })
@Scanned
public class IUMRest {
	private static final Logger LOG = LoggerFactory.getLogger(IUMRest.class);

	public class LicenseDetails {
		
		public License_Result licenseStatus;
		public String expires;
		public int users;
		public String SSN;
		public String customer;
		public String licenseKey;
		
		public LicenseDetails(License_Result licenseStatus, String expires, int users, String SSN, String customer, String licenseKey) {
			this.licenseStatus = licenseStatus;
			this.expires = expires;
			this.users = users;
			this.SSN=SSN;
			this.customer=customer;
			this.licenseKey=licenseKey;
		}
		
	}	
	
	@ComponentImport
    private final UserManager userManager;


	private com.atlassian.jira.user.util.UserManager userManagerJira;

	@ComponentImport
	private final ApplicationRoleManager applicationRoleManager;

	@ComponentImport
	private final ApplicationAuthorizationService applicationAuthorizationService;
	@ComponentImport
	private final JiraAuthenticationContext jiraAuthenticationContext;
	private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final GroupManager groupManager = ComponentAccessor.getGroupManager();

	@Inject
	public IUMRest(UserManager userManager, ApplicationRoleManager applicationRoleManager,ApplicationAuthorizationService applicationAuthorizationService,JiraAuthenticationContext jiraAuthenticationContext) {
		this.userManager = userManager;
		this.userManagerJira=ComponentAccessor.getUserManager();
		this.applicationRoleManager=applicationRoleManager;
		this.jiraAuthenticationContext=jiraAuthenticationContext;
		this.applicationAuthorizationService=applicationAuthorizationService;
	}

	@Path("/sidelicense")
	@GET
	// @Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON })
	public Response getSideLicenseDetails(@Context HttpServletRequest request) {
		UserKey userkey = userManager.getRemoteUserKey();
		LicenseData ourSideLicense = ConditionEvaluatorImpl.getSideLicense();
		License_Result licenseStatus = VerifyMessage.getLicenseStatus(ourSideLicense);
		LicenseDetails licenseDetails = null;
		if (userkey == null || !userManager.isAdmin(userkey))
        {
        	licenseDetails = new LicenseDetails(licenseStatus, null, 0,"","","");
        } else {
        	if (ourSideLicense != null) {
        		licenseDetails = new LicenseDetails(licenseStatus, ourSideLicense.getDueDate().toString(),
					ourSideLicense.getUsers(),ourSideLicense.getSSN(), ourSideLicense.getCustomer(), DAO.getSideLicense()  );
        	} else {
        		licenseDetails = new LicenseDetails(licenseStatus, null, 0,"","","");
        	}
        }	

		return Response.ok(licenseDetails).build();
	}

	//https://aurelian-jira.accxia.com/rest/IUM/latest/retry
	@Path("/retry")
	@GET
	@Consumes({ MediaType.APPLICATION_JSON})
	@Produces({ MediaType.APPLICATION_JSON })
	public Response attemptToEnableUser(@Context HttpServletRequest request) {
		ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
		CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, request);
		String warningMessage =currentUser!=null ? currentUser.warningMessage : "";
		Map retVal= new HashMap<>();
		retVal.put("warningMessage", warningMessage);

		if ((user != null) && (warningMessage==null || warningMessage.length()<1)){
			boolean canUseSoftwareAccess =applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SOFTWARE);
			boolean canUseServiceDeskAccess =applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SERVICE_DESK);
			boolean canUseCoreAccess =	applicationAuthorizationService.canUseApplication(user,ApplicationKeys.CORE);

			retVal.put(ApplicationKeys.SOFTWARE.value(), canUseSoftwareAccess);
			retVal.put(ApplicationKeys.SERVICE_DESK.value(), canUseServiceDeskAccess);
			retVal.put(ApplicationKeys.CORE.value(), canUseCoreAccess);
		}

		return Response.ok(retVal).build();
	}

	//https://aurelian-jira.accxia.com/rest/IUM/latest/apps
	@Path("/apps")
	@GET
	@Consumes({ MediaType.APPLICATION_JSON})
	@Produces({ MediaType.APPLICATION_JSON })
	public Response computeApplicationRole(@Context HttpServletRequest request) {
		ApplicationUser user =null;
		String username = request.getParameter("username");
		if(username!=null){
			user= userManagerJira.getUserByName(username);
		}
		Map retVal= new HashMap<>();
		if(user != null) {
			addApplicationAccess(user,retVal);
			retVal.put("username", username);
		}

		return Response.ok(retVal).build();
	}


	@Path("/view")
	@GET
	@Consumes({ MediaType.APPLICATION_JSON})
	@Produces({ MediaType.APPLICATION_JSON })
	public Response getUserAction4Group(@Context HttpServletRequest request) {
		String group = request.getParameter("group");
		List<String> retVal = new ArrayList<>();

		PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

		if(pocketRepository!=null){
			List<NavUserDTO> navUsers=pocketRepository.getOldestUsers(group,0,10);
			for (NavUserDTO navUser:navUsers){
				retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
			}
		}

		return Response.ok(retVal).build();
	}

	@Path("/check")
	@GET
	@Consumes({ MediaType.APPLICATION_JSON})
	@Produces({ MediaType.APPLICATION_JSON })
	public Response checkCanGetFreeSlots(@QueryParam("username") String username) {
		Quota retVal = IntelligentUserManagerHelper.checkCanGetFreeSlots(username);

		return Response.ok(retVal).build();
	}


	private void addApplicationAccess(ApplicationUser user, Map retVal) {
		if (user != null) {
			boolean canUseSoftwareAccess = applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE);
			boolean canUseServiceDeskAccess = applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
			boolean canUseCoreAccess = applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE);

			retVal.put(ApplicationKeys.SOFTWARE.value(), canUseSoftwareAccess);
			retVal.put(ApplicationKeys.SERVICE_DESK.value(), canUseServiceDeskAccess);
			retVal.put(ApplicationKeys.CORE.value(), canUseCoreAccess);
			String IUMGroup = DAO.getIUMGroupsDisabled();
			if (IUMGroup != null && IUMGroup.length() > 0) {
				String[] IUMGroups = IUMGroup.split(",");
				retVal.put("could-has-software", (canUseSoftwareAccess || (IUMGroups.length > 0 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[0]))) ? true : false);
				retVal.put("could-has-service", (canUseServiceDeskAccess || (IUMGroups.length > 1 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[1]))) ? true : false);
				retVal.put("could-has-core", (canUseCoreAccess || (IUMGroups.length > 2 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[2]))) ? true : false);
			}
		}
	}


}

