package de.accxia.jira.addon.IUM.side;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.model.UserHistoryDTO;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Test REST service
 *
 */
@Path("/test")
@Consumes({ MediaType.TEXT_HTML})
@Produces({ MediaType.TEXT_PLAIN })
@Scanned
public class TestRest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRest.class);

    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final  UserService userService;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final ProjectManager projectManager;
    private com.atlassian.jira.user.util.UserManager userManagerJira;

    private final I18nHelper i18nHelper;
    @ComponentImport
    private final AvatarService avatarService;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final ApplicationAuthorizationService applicationAuthorizationService;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;

/*
    //Service
    private final UserSearchManager userSearchManager;
    private final UserFactory userFactory;
    private final IssueDataService issueDataService;
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
*/
/*
    @ComponentImport
    private final ServiceDeskService serviceDeskManager;

    @ComponentImport
    private final SearchRequestService searchRequestService;
    @ComponentImport
    private final SearchRequestManager searchRequestManager;
    @ComponentImport
    private final ServiceDeskProjectService serviceDeskProjectService;
    @ComponentImport
    private final AgentService agentService;
    @ComponentImport
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;

    private final WorklogManager worklogManager;

*/

    // Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService
    // private UserPickerResourceHelper userPickerResourceHelper;


    //Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService
    //@ComponentImport
    //private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;

    //java.lang.NoClassDefFoundError: com/atlassian/servicedesk/internal/web/pagedata/AgentEntityBuilder
    //@ComponentImport
    //private final AgentEntityBuilder agentEntityBuilder;

    //Caused by: java.lang.NoClassDefFoundError: com/atlassian/servicedesk/internal/permission/group/ServiceDeskAgentPermissionManager
    //@ComponentImport
    //private final ServiceDeskAgentPermissionManager serviceDeskAgentPermissionManager;

    ///Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.rest.reports.workload.WorkloadPageDataProvider
    //@ComponentImport
    //private final WorkloadPageDataProvider workloadPageDataProvider;

    //Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.feature.people.AgentWorkloadService
    //@ComponentImport
    //private final AgentWorkloadService agentWorkloadService;

    //NoSuchBeanDefinitionException: No qualifying bean of type 'com.atlassian.servicedesk.internal.api.rest.RestResponseHelper' available:
    // private final RestResponseHelper restResponseHelper;

    //Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.feature.usermanagement.ServiceDeskUserPickerManager not found
    //@ComponentImport
    //private final ServiceDeskUserPickerManager serviceDeskUserPickerManager;

    //Caused by: java.lang.ClassNotFoundException: com.atlassian.servicedesk.internal.feature.usermanagement.ServiceDeskUserPickerService
    //@ComponentImport
    //private ServiceDeskUserPickerService serviceDeskUserPickerService;

    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();


    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TestRest(UserManager userManager, UserService userService,
                    IssueManager issueManager, ProjectManager projectManager,
                    PermissionManager permissionManager, ApplicationRoleManager applicationRoleManager,
                    ApplicationAuthorizationService applicationAuthorizationService, JiraAuthenticationContext jiraAuthenticationContext, AvatarService avatarService) {
        this.userManager = userManager;
        this.userService = userService;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.i18nHelper = (I18nHelper) ComponentAccessor.getComponent(I18nHelper.class);
        this.permissionManager = permissionManager;
        this.applicationRoleManager = applicationRoleManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;

/*
        this.userSearchManager = ComponentAccessor.getOSGiComponentInstanceOfType(UserSearchManager.class);;
        this.userFactory = ComponentAccessor.getOSGiComponentInstanceOfType(UserFactory.class);;
        this.issueDataService =ComponentAccessor.getOSGiComponentInstanceOfType(IssueDataService.class); ;
        this.serviceDeskService =ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskService.class); ;
        this.serviceDeskIssueService =ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskIssueService.class); ;
        this.serviceDeskLicenseAndPermissionService = ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskLicenseAndPermissionService.class);;
*/
    }

    /*
    @Path("/agent")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getAgent4ServiceDeskService(@Context HttpServletRequest request) throws Exception {
        Project project = projectManager.getProjectByCurrentKey("TA");
        ServiceDesk  serviceDesk =this.serviceDeskService.getServiceDeskForProject(this.jiraAuthenticationContext.getLoggedInUser(), project);
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        CheckedUser checkedUser = userFactory.wrap(applicationUser);
        List  filterGroups ;
        if (ProjectTypeKeys.SERVICE_DESK.equals(project.getProjectTypeKey())){
            filterGroups=Arrays.asList(DAO.getIUMSDeskGroupsDisabled());
        }else{
            filterGroups=Arrays.asList(DAO.getIUMSoftGroupsDisabled());
        }

        List<String> groupList = this.applicationRoleManager.getRoles().stream()
                .filter(applicationRole -> applicationRole.getKey().equals(ApplicationKeys.SERVICE_DESK))
                .flatMap(applicationRole -> applicationRole.getGroups().stream().map(group -> group.getName())).collect(Collectors.toList());
        groupList.addAll(filterGroups);

        // project.getProjectTypeKey()== ProjectTypeKeys.SERVICE_DESK
        Long projectId = project.getId();
        UserSearchParams userSearchParams = new UserSearchParams.Builder()
            .filterByProjectIds(Arrays.asList(projectId))
            .filter(new UserFilter(true, null, filterGroups))
            .allowEmptyQuery(true).includeActive(true).includeInactive(false)
                .ignorePermissionCheck(true)
                .maxResults(10000)
                .build();


        Map<String, Long> mapUserKeyCount = serviceDeskIssueService.getAssignedAndUnresolvedIssueCountByUserKey(this.userFactory.wrap(applicationUser),project);
        Query query = JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).and().unresolved().and().not().assigneeIsEmpty().buildQuery();
        IssueCountByAssigneeDataCallback issueKeyCallback = new IssueCountByAssigneeDataCallback();

        this.issueDataService.find(applicationUser,query,issueKeyCallback);
        Map<String, Long> mapIssueKeyCallback = issueKeyCallback.getCounts();

        // UserPickerResourceHelper
        // UserPickerResultsBean userPickerResultsBean = userPickerResourceHelper.findUsersAsBean("xaccount", 50, true, null, userSearchParams);
        List<ApplicationUser> agentUserList= this.userSearchManager.search( "", userSearchParams).collect(Collectors.toList());

        List<CheckedUser> filterAgentUserList = agentUserList.stream().filter(aUser ->  mapIssueKeyCallback.containsKey(aUser.getKey()))
                .filter(aUser -> !groupManager.isUserInGroup(aUser.getName(),"ium_jsm_access"))
                .map(aUser -> userFactory.wrap(aUser)).collect(Collectors.toList());


        int currentPage = 0;
        List<Issue>  currentIssueBatch;
        Map<String, AgentWorkloadDetails> resultsMap = new HashMap();
        do {
            currentIssueBatch = this.serviceDeskIssueService.getPagedAssignedAndUnresolvedIssues(checkedUser, project, filterAgentUserList, currentPage);
            Map<String, List<Issue>> currentBatchGroupedByAssignee = this.groupBatchByAssignee(currentIssueBatch);
            this.addToResultMap(resultsMap,project,filterAgentUserList,currentBatchGroupedByAssignee);
            ++currentPage;
        } while(!currentIssueBatch.isEmpty());


        List<AgentResponse> agentResponses= filterAgentUserList.stream().map(this::buildAgentResponse).collect(Collectors.toList());
        AgentResultsResponse agentResultsResponse = new AgentResultsResponse(
                "",
                agentResponses.size(),
                agentResponses,
                resultsMap
        );

        return Response.ok(agentResultsResponse).build();
    }

    */
/*
    private void addToResultMap(Map<String, AgentWorkloadDetails> resultsMap, Project project, List<CheckedUser> filterAgentUserList, Map<String, List<Issue>> currentBatchGroupedByAssignee) {
        currentBatchGroupedByAssignee.forEach((userKey, issues) -> {
            if(!resultsMap.containsKey(userKey)){
                String username = filterAgentUserList.stream().filter(aUser -> userKey.equals(aUser.getKey())).findFirst().map(aUser->aUser.getName()).orElse("");
                //?jql=assignee+%3D+xaccount00001+AND+resolution+%3D+Unresolved+AND+project+%3D+TA
                String jql = String.format("assignee=%s AND resolution=Unresolved AND project=%s",username,project.getKey());
                resultsMap.put(userKey,new AgentWorkloadDetails(0,jql));
            }
            resultsMap.get(userKey).add2Totals(issues.size());
        });

    }

    private Map<String, List<Issue>> groupBatchByAssignee(List<Issue> issueList) {
        return (Map)issueList.stream().collect(Collectors.groupingBy(Issue::getAssigneeId));
    }


    private Query getAssignedAndUnresolvedIssuesForUsersQuery(Project project, List<ApplicationUser> users) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder clauseBuilder = builder.where();
        clauseBuilder.defaultAnd().project(new Long[]{project.getId()}).unresolved().sub();
        clauseBuilder.defaultOr();
        users.forEach((user) -> {
            clauseBuilder.assigneeUser(user.getName());
        });
        clauseBuilder.endsub();
        return builder.buildQuery();
    }

    private AgentResponse buildAgentResponse(CheckedUser applicationUser) {
        return AgentResponse.build(applicationUser, this.serviceDeskLicenseAndPermissionService.canAdministerJIRA(applicationUser),
                this.getAvatarUrls(applicationUser.forJIRA()));
    }

    private AgentResponse.AvatarUrls getAvatarUrls(ApplicationUser applicationUser) {
        return new AgentResponse.AvatarUrls(this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.SMALL).toString(),
                this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.MEDIUM).toString(),
                this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.LARGE).toString());
    }

    @Path("/serv2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getServiceDeskService(@Context HttpServletRequest request) throws Exception {
        Project project= projectManager.getProjectByCurrentKey("TA");
        Long projectId= project.getId();
        UserSearchParams userSearchParams = new UserSearchParams.Builder()
                .filterByProjectIds(Arrays.asList(project.getId()))
                .filter(new UserFilter(true,null,Arrays.asList(DAO.getIUMGroupsDisabled().split(","))))
                .allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(100000)
                .build();


        ServiceDesk serviceDesk= this.serviceDeskService.getServiceDeskForProject(this.jiraAuthenticationContext.getLoggedInUser(), this.projectManager.getProjectByCurrentKey("TA"));

        List<String> groupList = this.applicationRoleManager.getRoles().stream()
                .filter(applicationRole -> applicationRole.getKey().equals(ApplicationKeys.SERVICE_DESK))
                .flatMap(applicationRole -> applicationRole.getGroups().stream().map(group -> group.getName())).collect(Collectors.toList());


        Map<String, Long> mapUserKeyCount = serviceDeskIssueService.getAssignedAndUnresolvedIssueCountByUserKey(this.userFactory.wrap(this.jiraAuthenticationContext.getLoggedInUser()),project);
        Query query= JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).and().unresolved().and().not().assigneeIsEmpty().buildQuery();
        IssueCountByAssigneeDataCallback issueKeyCallback = new IssueCountByAssigneeDataCallback();

        this.issueDataService.find(this.jiraAuthenticationContext.getLoggedInUser(),query,issueKeyCallback);
        Map<String, Long> mapIssueKeyCallback = issueKeyCallback.getCounts();

        //Query query2= JqlQueryBuilder.newBuilder().where().assigneeUser(assigneeName).and().unresolved().and().project(new String[]{project.getKey()}).buildQuery();
        Set<ApplicationUser> applicationUsers = new HashSet<>();
        for(String group:groupList){
            applicationUsers.addAll(this.groupManager.getUsersInGroup(group).stream().filter(applicationUser -> mapIssueKeyCallback.containsKey(applicationUser.getKey())).collect(Collectors.toList()));
        }


        List<CheckedUser> agents = applicationUsers.stream().map(applicationUser -> userFactory.wrap(applicationUser)).collect(Collectors.toList());

        LOG.debug(issueKeyCallback.getCounts().toString());
        LOG.debug(mapUserKeyCount.toString());

        return Response.ok(agents).build();

    }

    */
    @Path("/role")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getApplicationRole4Group(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        List<List<String>> retVal = new ArrayList<>();

        List<OldestUser> users=IntelligentUserManagerHelper.getSortedUserListFromGroup(group, 0,1000, "");
        for (OldestUser ouser:users){
            List<String> uList = new ArrayList<>();
            uList.add(ouser.getUser().getName());
            uList.add(String.valueOf(ouser.ts));
            uList.add(String.valueOf(ouser.getUser().isActive()));
            uList.add(SDF.format(new Date(ouser.ts)));

            boolean canUseSoftwareAccess =applicationAuthorizationService.canUseApplication(ouser.getUser(),ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess =applicationAuthorizationService.canUseApplication(ouser.getUser(),ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess =	applicationAuthorizationService.canUseApplication(ouser.getUser(),ApplicationKeys.CORE);
            uList.add("canUseSoftwareAccess="+String.valueOf(canUseSoftwareAccess));
            uList.add("canUseServiceDeskAccess="+String.valueOf(canUseServiceDeskAccess));
            uList.add("canUseCoreAccess="+String.valueOf(canUseCoreAccess));

            retVal.add(uList);

        }
        return Response.ok(retVal).build();
    }


    //list all jira roles for given username
    @Path("/role2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getApplicationRole2(@Context HttpServletRequest request) {
        ApplicationUser user =null;
        String username = request.getParameter("username");
        if(username!=null){
            user= userManagerJira.getUserByName(username);
        }

        Map<String,List<String>> retVal= new HashMap<>();
        if(user != null){
            Set<ApplicationRole> applicationRoles =  applicationRoleManager.getOccupiedLicenseRolesForUser(user);

            for (ApplicationRole applicationRole : applicationRoles) {
                if(LOG.isDebugEnabled()){
                    LOG.debug("applicationRole["+username+"]= "+applicationRole.getKey() );
                }

                List<String> groups= applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retVal.put(applicationRole.getKey().value(),groups);
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/apps3?username=admin2
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/apps3?username=account1
    @Path("/role3")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getApplicationRole3(@Context HttpServletRequest request) {
        ApplicationUser user =null;
        String username = request.getParameter("username");
        Map retVal= new HashMap<>();
        retVal.put("username", username);

        Map retValCanUse= new HashMap<>();
        Map retValLic= new HashMap<>();
        Map retValRole= new HashMap<>();
        Map retValGroup= new HashMap<>();
        if(username!=null){
            user= userManagerJira.getUserByName(username);
        }
        if(user != null) {

            boolean canUseSoftwareAccess =applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess =applicationAuthorizationService.canUseApplication(user,ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess =	applicationAuthorizationService.canUseApplication(user,ApplicationKeys.CORE);

            retValCanUse.put("can-use-"+ApplicationKeys.SOFTWARE.value(), canUseSoftwareAccess);
            retValCanUse.put("can-use-"+ApplicationKeys.SERVICE_DESK.value(), canUseServiceDeskAccess);
            retValCanUse.put("can-use-"+ApplicationKeys.CORE.value(), canUseCoreAccess);
            retVal.put("can-use",retValCanUse);

            Set<ApplicationRole> applicationRoles =  applicationRoleManager.getOccupiedLicenseRolesForUser(user);

            for (ApplicationRole applicationRole : applicationRoles) {
                if(LOG.isDebugEnabled()){
                    LOG.debug("applicationRole["+username+"]= "+applicationRole.getKey() );
                }

                List<String> groups= applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retValLic.put("lic-role-"+applicationRole.getKey().value(),groups);
            }
            retVal.put("lic-role",retValLic);

            Set<ApplicationRole> applicationRoles2 =  applicationRoleManager.getRolesForUser(user);
            for (ApplicationRole applicationRole : applicationRoles2) {
                if(LOG.isDebugEnabled()){
                    LOG.debug("applicationRole["+username+"]= "+applicationRole.getKey() );
                }

                List<String> groups= applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retValRole.put("app-role-"+applicationRole.getKey().value(),groups);
            }
            retVal.put("app-role",retValRole);

            Collection<String>  groupNames= groupManager.getGroupNamesForUser(user);
            retVal.put("groupNames",groupNames);

            String group = DAO.getIUMGroups();
            String[] groups=null;
            if (group!=null) {
                groups = group.split(",");
                for (int i=0; i<groups.length;i++) {
                    int groupCount = groupManager.getUsersInGroupCount(groupManager.getGroup(groups[i]));
                    retValGroup.put(groups[i],groupCount);
                }
            }

            retVal.put("groups",retValGroup);
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav1?group=ium_disable&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav1?group=ium_enable&offset=0&cnt=10
    @Path("/nav1")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<NavUserDTO> navUsers=pocketRepository.getAllNavUserForGroup(group,offset,cnt);
            for (NavUserDTO navUser:navUsers){
                if(navUser.getID()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserNameEx(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav2?group=ium_disable&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav2?group=ium_enable&offset=0&cnt=10
    @Path("/nav2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getOldestUsers(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<NavUserDTO> navUsers=pocketRepository.getOldestUsers(group,offset,cnt);
            for (NavUserDTO navUser:navUsers){
                if(navUser.getID()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserNameEx(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav3?group=ium_disable&filtergroup=ium_enable&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav3?group=ium_enable&filtergroup=ium_disable&offset=0&cnt=10
    @Path("/nav3")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<NavUserDTO> navUsers=pocketRepository.getOldestUsers(group,filtergroup,offset,cnt);
            for (NavUserDTO navUser:navUsers){
                if(navUser.getID()!=null){
                    retVal.add(String.format("User %s %s %s - date %s",new Object[]{navUser.getUserName(),
                            navUser.getDisplayNameEx(),navUser.getUserEmailEx(),
                            SDF.format(navUser.getLastAccessTime())}));
                }else{
                    retVal.add(String.format("User %s %s %s - date %s",new Object[]{navUser.getUserNameEx(),
                            navUser.getDisplayNameEx(),navUser.getUserEmailEx(),
                            "NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav4?group=group=ium_enable&filtergroup=ium_disable
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav4?group=group=ium_disable&filtergroup=ium_enable
    @Path("/nav4")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            long countOldestUsers=pocketRepository.countOldestUsers(group,filtergroup);

            return Response.ok(countOldestUsers).build();
        }

        return Response.status(Response.Status.BAD_REQUEST).entity("Missing pocket").build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav5?group=ium_disable&time=10&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav5?group=ium_enable&time=10&offset=0&cnt=10
    @Path("/nav5")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time =safeParseToInt(request.getParameter("time"));
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));

        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        Timestamp ts = new Timestamp(new Date().getTime() - time*60*1000);
        if(pocketRepository!=null){
            List<NavUserDTO> navUsers = pocketRepository.getNavUserActiveForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser:navUsers){
                if(navUser.getID()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserNameEx(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav6?group=ium_disable&time=10&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav6?group=ium_enable&time=10&offset=0&cnt=10
    @Path("/nav6")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getNavUserForGroupLtTime2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time =safeParseToInt(request.getParameter("time"));
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));

        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        Timestamp ts = new Timestamp(new Date().getTime() - time*60*1000);
        if(pocketRepository!=null){
            List<NavUserDTO> navUsers = pocketRepository.getNavUserDisableForGroupLtTime(group,  ts, offset, cnt);
            for (NavUserDTO navUser:navUsers){
                if(navUser.getID()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserNameEx(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav7?group=ium_disable&filtergroup=ium_enable&offset=0&cnt=10
    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/nav7?group=ium_enable&filtergroup=ium_disable&offset=0&cnt=10
    @Path("/nav7")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        List<List<String>> retVal = new ArrayList<>();

        List<OldestUser> users=IntelligentUserManagerHelper.getSortedUserListFromGroup(group, offset,cnt, filtergroup);
        for (OldestUser ouser:users){
            List<String> uList = new ArrayList<>();
            uList.add(ouser.getUser().getName());
            uList.add(String.valueOf(ouser.ts));
            uList.add(String.valueOf(ouser.getUser().isActive()));
            uList.add(SDF.format(new Date(ouser.ts)));

            retVal.add(uList);

        }

        return Response.ok(retVal).build();
    }




    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist1?group=ium_disable&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist1?group=ium_enable&offset=0&cnt=10
    @Path("/hist1")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getAllUserHistoryForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<UserHistoryDTO> userHistories=pocketRepository.getAllUserHistoryForGroup(group,offset,cnt);
            for (UserHistoryDTO userHistory:userHistories){
                if(userHistory.getLastViewTime()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),SDF.format(userHistory.getLastViewTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist2?group=ium_disable&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist2?group=ium_enable&offset=0&cnt=10
    @Path("/hist2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getOldestUsersFromUserHistory(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<UserHistoryDTO> userHistories=pocketRepository.getOldestUsersFromUserHistory(group,offset,cnt);
            for (UserHistoryDTO userHistory:userHistories){
                if(userHistory.getLastViewTime()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),SDF.format(userHistory.getLastViewTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }


    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist3?group=ium_disable&time=10&&offset=0&cnt=10
    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/hist3?group=ium_enable&time=10&offset=0&cnt=10
    @Path("/hist3")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getUserHistoryForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time =safeParseToInt(request.getParameter("time"));
        int offset =safeParseToInt(request.getParameter("offset"));
        int cnt =safeParseToInt(request.getParameter("cnt"));
        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        long duration = time * 1000 * 60;
        Timestamp refTime = new Timestamp(System.currentTimeMillis()-duration);

        if(pocketRepository!=null){
            List<UserHistoryDTO> userHistories=pocketRepository.getUserHistoryForGroupLtTime(group,refTime,offset,cnt);
            for (UserHistoryDTO userHistory:userHistories){
                if(userHistory.getLastViewTime()!=null){
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),SDF.format(userHistory.getLastViewTime())}));
                }else{
                    retVal.add(String.format("User %s - date %s",new Object[]{userHistory.getUserName(),"NEVER"}));
                }
            }
        }

        return Response.ok(retVal).build();
    }


    @Deprecated
    @Path("/action2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getActionIUMEnableUsers(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        List<String> retVal = new ArrayList<>();

        Collection<ApplicationUser> users= groupManager.getUsersInGroup(group);
        String[] userNames = users.stream().map(user -> user.getUsername()).toArray(String[]::new);
        NavUserRepository navUserRepository = ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);

        if(navUserRepository!=null){
            NavUser[]  navUsers=navUserRepository.getOldestUsers(userNames,10);
            for (NavUser navUser:navUsers){
                retVal.add(String.format("User %s - date %s",new Object[]{navUser.getUserName(),SDF.format(navUser.getLastAccessTime())}));
            }
        }

        return Response.ok(retVal).build();
    }

    @Deprecated
    @Path("/action3")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getAllNav(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        List<String> retVal = new ArrayList<>();

        //Collection<ApplicationUser> users= groupManager.getUsersInGroup(group);
        //String[] userNames = users.stream().map(user -> user.getUsername()).toArray(String[]::new);
        NavUserRepository navUserRepository = ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);

        if(navUserRepository!=null){
            NavUser[]  navUsers=navUserRepository.getAll();
            for (NavUser navUser:navUsers){
                retVal.add(String.format("User %s %s- date %s",new Object[]{navUser.getUserName(),navUser.toString(), SDF.format(navUser.getLastAccessTime())}));
            }
        }

        return Response.ok(retVal).build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/member1?username=account1
    @Path("/member1")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getMmebershipForUser(@Context HttpServletRequest request) {
        String username = request.getParameter("username");

        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<String>  mmeberships =pocketRepository.getMmebershipForUser(username);

            return Response.ok(mmeberships).build();
        }

        return Response.status(Response.Status.BAD_REQUEST).entity("Missing pocket").build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/member2?group=ium_disable
    @Path("/member2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getMmebershipForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");

        List<String> retVal = new ArrayList<>();

        PocketRepository pocketRepository = ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);

        if(pocketRepository!=null){
            List<String>  mmeberships =pocketRepository.getMmebershipForGroup(group);

            return Response.ok(mmeberships).build();
        }

        return Response.status(Response.Status.BAD_REQUEST).entity("Missing pocket").build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/create?username=account&password=Account123$$&count=10&group=ium_disable
    @Path("/create")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response createUsers(@QueryParam("username") String username,@QueryParam("password") String password, @QueryParam("group") String group, @QueryParam("count") Integer count) {
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        if (username != null) {
            try {
                Group parentGroup= groupManager.getGroup(group);
                ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();

                for (int i=1;i<=count;i++){
                    String uname=String.format("%s%d",username, i);
                   /*
                    if(!userUtil.userExists(uname)){
                        //String username, String password, String emailAddress, String displayName
                        ApplicationUser usr=  userUtil.createUserNoNotification(uname, password, "aurelian.cruceru+"+uname+"@alten.com", uname);
                        groupManager.addUserToGroup(usr,parentGroup);

                        LOG.info("User is created successfully: "+uname);
                    }
                    */
                    UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(user,
                            uname, password, "aurelian.cruceru+"+uname+"@alten.com", uname).withNoApplicationAccess();
                    createUserRequest = createUserRequest.withNoApplicationAccess().sendNotification(false).skipValidation();
                    UserService.CreateUserValidationResult result = userService.validateCreateUser(createUserRequest);
                    if(result.isValid()){
                        try {
                            ApplicationUser usr= userService.createUser(result);

                            groupManager.addUserToGroup(usr,parentGroup);

                            LOG.info("User is created successfully: "+uname);
                        } catch (Exception e) {
                            LOG.error("Cannot create user '" + username + "'!", e);
                        }
                    }else{
                        LOG.info("Error: "+result.getErrorCollection());
                    }
                }
            } catch (Exception le) {
                LOG.error("Cannot create user '" + username + "'!", le);
                // if you're having licensing issues, this needs to bubble up.
                // see: https://github.com/chauth/confluence_http_authenticator/issues/33
                return Response.status(Response.Status.BAD_REQUEST).entity("Cannot create user '" + username + "'!").build();

            } catch (Throwable t) {
                LOG.error("Failed to create user '" + username + "'!", t);
                return Response.status(Response.Status.BAD_REQUEST).entity("Failed to create user '" + username + "'!").build();

            }

        } else {
            LOG.warn("Cannot add user with null username!");
        }

        return Response.ok().build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/log

    @Path("/log")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setLoggerDebug() {
        org.apache.log4j.Logger.getLogger("de.accxia.jira.addon.IUM").setLevel(Level.DEBUG);
        return Response.ok().build();
    }

    //https://aurelian-jira.accxia.com/rest/IUM/latest/test/log2
    @Path("/log2")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setLoggerInfo() {
        org.apache.log4j.Logger.getLogger("de.accxia.jira.addon.IUM").setLevel(Level.INFO);
        return Response.ok().build();
    }

    @Path("/property")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getProperty() {
        String iumGroups= DAO.getIUMGroups();
        return Response.ok(iumGroups).build();
    }

    @Path("/getx")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getValue4tProperty(@QueryParam("field") String field) {

        String fieldValue= DAO.getValueX(field);
        return Response.ok(fieldValue).build();
    }

    @Path("/setx")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setValue4tProperty(@QueryParam("field") String field,@QueryParam("value") String value) {

        DAO.setValueX(field,value);

        String fieldValue= DAO.getValueX(field);
        return Response.ok(fieldValue).build();
    }


    private int safeParseToInt(String time) {
        if(time == null || time.length()==0){
            return 0;
        }

        try{
            return Integer.parseInt(time);
        }catch (Exception e){
            LOG.error("Exception "+e.getMessage(),e);
        }

        return 0;
    }

    // https://aurelian-jira.accxia.com/rest/IUM/latest/test/empty
    @Path("/empty")
    @GET
    @Consumes({ MediaType.APPLICATION_JSON})
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setClearDAO() {
        DAO.cleanPluginSettings();
        ConditionEvaluatorImpl.setSideLicense(null);

        return Response.ok("OK").build();
    }

    /*

    private static class IssueCountByAssigneeDataCallback implements DataCallback {
        private Set<String> fields;
        private String assignee;
        private Map<String, Long> assigneeToIssueCount;

        private IssueCountByAssigneeDataCallback() {
            this.fields = ImmutableSet.of("issue_assignee");
            this.assigneeToIssueCount = Maps.newHashMap();
        }

        public Set<String> getFields() {
            return this.fields;
        }

        public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
            if ("issue_assignee".equals(fieldName)) {
                this.assignee = data;
            }

        }

        public void documentComplete(Long issueId, String issueKey) {
            if (this.assignee != null) {
                long count = (Long)this.assigneeToIssueCount.getOrDefault(this.assignee, 0L) + 1L;
                this.assigneeToIssueCount.put(this.assignee, count);
            }
        }

        public Map<String, Long> getCounts() {
            return this.assigneeToIssueCount;
        }
    }
    */
}





