package de.accxia.jira.addon.IUM.side;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Date;

import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import org.apache.commons.lang3.exception.ExceptionUtils;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.accxia.jira.addon.IUM.config.DAO;


public class VerifyMessage {

	private static String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIYrjQBEg6RPMYXJwS8FxE5E/s0I5XCpIlBP3yGi4zm3sGwiwyqck40MzMCBbb+3RoBZZkpfzNr99WYa3x+jme8CAwEAAQ==";
	private static ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();

	//deprecated private static LicenseCountService licenseCountService = ComponentAccessor.getComponentOfType(LicenseCountService.class);
	private static final ApplicationAuthorizationService applicationAuthorizationService = ComponentAccessor.getComponent(ApplicationAuthorizationService.class);

	private final static String OURAPPKEY = "de.accxia.jira.addon.IUM.IntelligentUserManager";
	private final static String OURAPPKEY2 = "de.accxia.jira.addon.IUM.Enhanced";

	public enum License_Result {
		LICENSE_MISSING, LICENSE_OK, LICENSE_EXPIRED, LICENSE_USERS_LIMIT, LICENSE_WRONG_SERVERID, LICENSE_WRONG_APPKEY
	}

	//private static Gson gson = new Gson();
	private static Gson gson = new GsonBuilder().setDateFormat("MMM dd, yyyy hh:mm:ss a").setPrettyPrinting().create();
	private static final Logger log = LoggerFactory.getLogger(VerifyMessage.class);

	// The constructor of VerifyMessage class retrieves the byte arrays from the
	// File and prints the message only if the signature is verified.
	public static LicenseData verifyMessageString(String theMessage) throws Exception {
		String[] msg = theMessage.split("\\$\\$");
		byte[] dmessage = Base64.getDecoder().decode(msg[0].getBytes());
		byte[] vmessage = Base64.getDecoder().decode(msg[1].getBytes());
		if (verifySignatureString(dmessage, vmessage)) {
			LicenseData res=null;
			try {
				res=gson.fromJson(new String(dmessage), LicenseData.class);
				return(res);
			} catch (JsonSyntaxException  e) {
				log.error("Error parsing license Data "+e.getMessage(),e);
			}
		}
		log.warn("HGTESTTEST CAN NOT Verify Signature");
		return (null);
	}

	public static LicenseData checkSideLicenses() {

		// get license from DAO
		String sideLicense = DAO.getSideLicense();
		if ((sideLicense == null) || ("".equals(sideLicense))) {
			return (null);
		}
		try {
			LicenseData res = verifyMessageString(sideLicense);
			// if (isSideLicenseValid(res)) {
			return (res);
			// }
		} catch (Exception e) {
			return (null);
		}

	}

	public static LicenseData checkSideLicenses(String sideLicense) {

		if ((sideLicense == null) || ("".equals(sideLicense))) {
			return (null);
		}
		try {
			LicenseData res = verifyMessageString(sideLicense);
			// if (isSideLicenseValid(res)) {
			return (res);
			// }
		} catch (Exception e) {
			return (null);
		}

	}
	// Method for signature verification that initializes with the Public Key,
	// updates the data to be verified and then verifies them using the signature
	private static boolean verifySignatureString(byte[] data, byte[] signature)  {
		try {
			Signature sig = Signature.getInstance("SHA1withRSA");
			sig.initVerify(getPublicFromString(publicKey));
			sig.update(data);
			return sig.verify(signature);
		} catch (Exception e) {
			// ignore
			return (false);
		}

	}

	private static int getNumberOfApplicationUsers() {
		int userNum=Math.max(applicationAuthorizationService.getUserCount(ApplicationKeys.SOFTWARE), applicationAuthorizationService.getUserCount(ApplicationKeys.CORE));
		userNum=Math.max(userNum,applicationAuthorizationService.getUserCount(ApplicationKeys.SERVICE_DESK));
		return(userNum);
	}
	
	public static License_Result getLicenseStatus(LicenseData sideLicense) {
		String ourServerID = applicationProperties.getString("jira.sid.key");
		if (sideLicense == null) {
			return (License_Result.LICENSE_MISSING);
		}
		if (sideLicense.getDueDate().compareTo(new Date()) < 0) {
			return (License_Result.LICENSE_EXPIRED);
		}
		if (!((OURAPPKEY.equals(sideLicense.getAppKey()) || OURAPPKEY2.equals(sideLicense.getAppKey()) || ("".equals(sideLicense.getAppKey()))))) {
			return (License_Result.LICENSE_WRONG_APPKEY);
		}
		if (!((ourServerID != null)
				&& ((ourServerID.equals(sideLicense.getSid()) || "".equals(sideLicense.getSid()))))) {
			return (License_Result.LICENSE_WRONG_SERVERID);
		}
		
		if (getNumberOfApplicationUsers() > sideLicense.getUsers()) {
			return (License_Result.LICENSE_USERS_LIMIT);
		}

		return (License_Result.LICENSE_OK);
	}

	/**
	 * Check the validity of our plugin's license.
	 * 
	 * @return true if the plugin's license is valid; false otherwise.
	 */
	public static boolean isSideLicenseValid(LicenseData sideLicense) // to be completed
	{
		return (getLicenseStatus(sideLicense) == License_Result.LICENSE_OK);
	}

	// Method to retrieve the Public Key from a Str
	public static PublicKey getPublicFromString(String publicKey) throws Exception {
		byte[] keyBytes0 = publicKey.getBytes();
		byte[] keyBytes = Base64.getDecoder().decode(keyBytes0);
		X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
		KeyFactory kf = KeyFactory.getInstance("RSA");
		return kf.generatePublic(spec);
	}
}
