package de.accxia.jira.addon.IUM.agents;


import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AgentWorkloadDetails {
    public static final String BREACHED = "breached";
    public static final String URGENT = "urgent";
    public static final String NORMAL = "normal";
    private long total;
    private long breachedCount;
    private long urgentCount;
    private long normalCount;
    private String jql;

    public AgentWorkloadDetails(long total,String jql) {
        this(total,0,0,0,jql);
    }
    public AgentWorkloadDetails(long total, long breachedCount, long urgentCount, long normalCount, String jql) {
        this.total = total;
        this.breachedCount = breachedCount;
        this.urgentCount = urgentCount;
        this.normalCount = normalCount;
        this.jql = jql;
    }

    public long getTotal() {
        return this.total;
    }

    public long getBreachedCount() {
        return this.breachedCount;
    }

    public long getUrgentCount() {
        return this.urgentCount;
    }

    public long getNormalCount() {
        return this.normalCount;
    }

    public String getJql() {
        return this.jql;
    }

    public static AgentWorkloadDetails convertSeveritiesAndJQLToWorkloadObject(Map<String, Long> severityCountMap, String jql) {
        return new AgentWorkloadDetails((Long)severityCountMap.values().stream().reduce(0L, Long::sum), (Long)severityCountMap.getOrDefault("breached", 0L), (Long)severityCountMap.getOrDefault("urgent", 0L), (Long)severityCountMap.getOrDefault("normal", 0L), jql);
    }

    public void add2Totals(int size) {
        this.total = this.total + size;
    }
}
