package de.accxia.jira.addon.IUM.cache;


import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import de.accxia.jira.addon.IUM.config.DAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * GET/POST
 * https://aurelian-jira.accxia.com/rest/IUM/latest/cache/property/list
 *
 * https://qa-jira-cluster.accxia.com/rest/IUM/latest/cache/property/list
 *
 */
@Path("/cache")
@Consumes({ MediaType.TEXT_HTML, MediaType.APPLICATION_JSON})
@Produces({ MediaType.APPLICATION_JSON })
@Scanned
public class InfoCacheController {
    private static final Logger LOG = LoggerFactory.getLogger(InfoCacheController.class);

    private AccxiaCacheComponent accxiaCacheComponent;
    private AccxiaCachePropertySet accxiaCachePropertySet;
    @Inject
    public InfoCacheController(AccxiaCacheComponent accxiaCacheComponent,AccxiaCachePropertySet accxiaCachePropertySet){
        this.accxiaCacheComponent=accxiaCacheComponent;
        this.accxiaCachePropertySet=accxiaCachePropertySet;
    }

    @Path("/property/list")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getCurrentConfig() {

        Map<String, Map<String,String>> map = new HashMap<>();

        Map<String,String> properties =  DAO.getValues();
        map.put("properties", properties);


        return Response.ok(map).build();
    }

    @Path("/list")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getCacheList() {
        Map<String,String> map = new HashMap<>();
        Collection<String>  keys=  accxiaCacheComponent.getCache().getKeys();

        for (String key : keys) {
            map.put(key, accxiaCacheComponent.getCache().get(key));
        }
        return Response.ok(map).build();
    }

    @Path("/get")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getCacheKey(@QueryParam("field") String field) {
        String value = accxiaCacheComponent.getValue(field);
        return Response.ok(value==null? "NULL" : value).build();
    }

    @Path("/set")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setCacheKey(@QueryParam("field") String field,@QueryParam("value") String value) {

        accxiaCacheComponent.setValue(field,value);
        String newValue = accxiaCacheComponent.getValue(field);
        return Response.ok(newValue==null? "NULL" : newValue).build();
    }

    @Path("/list2")
    @GET
    @Produces({MediaType.APPLICATION_JSON})
    public Response getCacheKey2() {
        Map<String, String> map = new HashMap<>();
        Collection<String> keys = accxiaCachePropertySet.getKeys();

        for (String key : keys) {
            map.put(key, accxiaCacheComponent.getCache().get(key));
        }

        return Response.ok(map).build();
    }

    @Path("/get2")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getPropertyKey(@QueryParam("field") String field) {
        String value = accxiaCachePropertySet.getValue(field);
        return Response.ok(value==null? "NULL" : value).build();
    }

    @Path("/set2")
    @GET
    @Produces({ MediaType.APPLICATION_JSON })
    public Response setPropertyKey(@QueryParam("field") String field,@QueryParam("value") String value) {

        accxiaCachePropertySet.setValue(field,value);
        String newValue = accxiaCachePropertySet.getValue(field);
        return Response.ok(newValue==null? "NULL" : newValue).build();
    }

}
