package de.accxia.jira.addon.IUM.conditions;

import java.util.Locale;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;

@Scanned
public class IsUserLoggedIn extends AbstractWebCondition {
	//private static final Logger log = LoggerFactory.getLogger(IsUserLoggedIn.class);

	
	private JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
	I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(Locale.getDefault());

	public IsUserLoggedIn() {
	}

	@Override
	public boolean shouldDisplay(ApplicationUser ignore, JiraHelper arg1) {
		// the user is not handed over properly 
		if (!ConditionEvaluatorImpl.isLicenseValid()) {
			return (true); //changed from true since otherwise users can not login anymore when license is expired
		}
		//this is why we retrieve the current user differently
		ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
		return user != null;
	}
}