package de.accxia.jira.addon.IUM.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.Date;

@ExportAsService({JobClusterService.class})
@Named("jobClusterService")
public class JobClusterService {
    private Logger LOG = LoggerFactory.getLogger(JobClusterService.class);


    private final MonitorJobRunner monitorJobRunner;

    @Inject
    public JobClusterService(MonitorJobRunner monitorJobRunner) {
        this.monitorJobRunner = monitorJobRunner;
    }

    public boolean start(){
        try {
            if(LOG.isDebugEnabled()){
                LOG.debug("JobClusterService call start" );
            }

            monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            monitorJobRunner.doSchedule(JobDataUtils.createIUMJobData(),IUMClusterJob.getInstance());

            return true;
        } catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, e);
        }
        return false;
    }
    public boolean restart(){
        try {
            if(LOG.isDebugEnabled()){
                LOG.debug("JobSyncService call restart" );
            }

            monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            JobData jobData= JobDataUtils.createIUMJobData();
            jobData.getParameters().put(JobData.RESTART,Boolean.TRUE);

            monitorJobRunner.doSchedule(jobData,IUMClusterJob.getInstance());

            return true;
        } catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, e);
        }
        return false;
    }

    public boolean stop(){
        try {
            if(LOG.isDebugEnabled()){
                LOG.debug("JobClusterService doStop" );
            }

            monitorJobRunner.doUnSchedule(IUMClusterJob.class);


            return true;
        } catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, e);
        }
        return false;
    }

    public boolean isWorking(){
        return monitorJobRunner.isWorking(IUMClusterJob.class);
    }

    public JobDetails getJobDetails(){
        return monitorJobRunner.getJobDetails(IUMClusterJob.class);
    }

    public Date getNextRunDate() {
        return monitorJobRunner.getNextRunDate(IUMClusterJob.class);
    }
    public RunDetails getLastSuccessfulRunForJob() {
        return monitorJobRunner.getLastSuccessfulRunForJob(IUMClusterJob.class);
    }

}
