package de.accxia.jira.addon.IUM.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.config.JobRunnerKey;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.job.JobClusterService;
import de.accxia.jira.addon.IUM.job.JobDailyService;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.Date;

@ExportAsService({ IUMListener.class })
@Named("IUMListener")
@EventComponent
public class IUMListener implements InitializingBean, DisposableBean, ClusterMessageConsumer {
	private static final Logger LOG = LoggerFactory.getLogger(IUMListener.class);
	private final static String PLUGIN_KEY  = "de.accxia.jira.addon.IUM.IntelligentUserManager";
	public static Boolean PLUGIN_ENABLED=false;
	@ComponentImport
	private final EventPublisher eventPublisher;
	@ComponentImport
	private final ClusterManager clusterManager;
	@ComponentImport
	private final JiraAuthenticationContext jiraAuthenticationContext;

	@ComponentImport
	private final ClusterMessagingService clusterMessagingService;

	//TODO find better solution for injection
	private final DAO dao;
	private final NavUserRepository navUserRepository;
	@ComponentImport
	private final LoggingManager loggingManager;
	private final JobClusterService jobClusterService;
	private final JobSyncService jobSyncService;
	private final JobDailyService jobDailyService;
	@Inject
	public IUMListener(EventPublisher eventPublisher, ClusterManager clusterManager, ClusterMessagingService clusterMessagingService,
					   JiraAuthenticationContext jiraAuthenticationContext, LoggingManager loggingManager,
					   JobClusterService jobClusterService,JobSyncService jobSyncService,JobDailyService jobDailyService, NavUserRepository navUserRepository, DAO dao) {
		this.eventPublisher = eventPublisher;
		this.clusterManager = clusterManager;
		this.jiraAuthenticationContext=jiraAuthenticationContext;
		this.jobClusterService = jobClusterService;
		this.jobSyncService=jobSyncService;
		this.jobDailyService=jobDailyService;
		this.navUserRepository=navUserRepository;
		this.dao=dao;
		this.clusterMessagingService=clusterMessagingService;
		this.loggingManager=loggingManager;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		eventPublisher.register(this);
		clusterMessagingService.registerListener("IUMChannel",this);
		IUMListener.PLUGIN_ENABLED =true;

		ConditionEvaluatorImpl.setSideLicense();

		if("on".equalsIgnoreCase(DAO.getSyncWorkingJob())){
			if (!this.jobSyncService.isWorking()) {
				this.jobSyncService.restart();
			}
		};

		if("on".equalsIgnoreCase(DAO.getWorkingJob())){
			if (!this.jobClusterService.isWorking()) {
				this.jobClusterService.restart();
			}
		};

		if(DAO.getLoggerLevel()){
			LOG.warn("setLoggerLevel=TRUE");
			this.loggingManager.setLogLevel(DAO.LOGGER_KEY, "DEBUG");
		};


		if (!this.jobDailyService.isWorking()) {
			this.jobDailyService.start();
		}

	}

	@Override
	public void destroy() throws Exception {
		//DAO.propertyCachedManager.cleanup();
		eventPublisher.unregister(this);
		clusterMessagingService.unregisterListener("IUMChannel",this);

		//CLEANUP ALL JOBS
		try {
			if (this.jobSyncService.isWorking()) {
				this.jobSyncService.stop();
			}

		} catch (Exception e) {
			LOG.error("Exception " + e.getMessage(), e);
		}

		try {
			if (this.jobClusterService.isWorking()) {
				this.jobClusterService.stop();
			}

		} catch (Exception e) {
			LOG.error("Exception " + e.getMessage(), e);
		}

		try {
			this.jobDailyService.stop();

		} catch (Exception e) {
			LOG.error("Exception " + e.getMessage(), e);
		}
		IUMListener.PLUGIN_ENABLED =false;
	}

	@PluginEventListener
	public void onPluginEnabled(PluginEnabledEvent event) {
		String pluginKey = event.getPlugin().getKey();
		// Check if the installed plugin is your target plugin
		if (PLUGIN_KEY.equals(pluginKey)) {
			IUMListener.PLUGIN_ENABLED =true;
		}
	}

	@PluginEventListener
	public void onPluginDisabling(PluginDisablingEvent event) {
		String pluginKey = event.getPlugin().getKey();
		// Check if the installed plugin is your target plugin
		if (PLUGIN_KEY.equals(pluginKey)) {
			IUMListener.PLUGIN_ENABLED =false;
		}
	}
	public void publishJobNotification(boolean isStarted){
		if(LOG.isWarnEnabled()){
			LOG.warn("IUMListener publishJobNotification isStarted=" + isStarted);
		}

		clusterMessagingService.sendRemote("IUMChannel", DAO.WORKING_JOB+";"+isStarted);
	}

	public void publishSyncJobNotification(boolean isStarted){
		if(LOG.isWarnEnabled()){
			LOG.warn("IUMListener publishJobNotification isStarted=" + isStarted);
		}

		clusterMessagingService.sendRemote("IUMChannel", DAO.WORKING_SYNC_JOB+";"+isStarted);
	}


	private static org.apache.log4j.Logger getLogger(String loggerName) {
		return "root".equals(loggerName) ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger(loggerName);
	}



	@EventListener
	public void onLogoutEvent(LogoutEvent logoutEvent) {
		// Move the user to disabled group
		if (ConditionEvaluatorImpl.isLicenseValid()) {
			ApplicationUser user = logoutEvent.getUser();
			if (user != null) {
				IntelligentUserManagerHelper.moveUserToDisabled(user);
			}
		}

	}

	@Override
	public void receive(String channel, String message, String senderId) {
		LOG.warn("IUMListener receive" + channel + "=" + message + ": " +senderId);
		LOG.warn("IUMListener getNodeId=" + clusterManager.getNodeId());
		if(message!=null && !senderId.equals(clusterManager.getNodeId())){
			if(message.startsWith(DAO.WORKING_JOB)){
				String[] parts =message.split(";");
				Boolean isStarted = Boolean.valueOf(parts[1]);
				if (isStarted) {
					jobClusterService.start();
					LOG.warn("IUMListener Job isStarted = " + isStarted);
				} else {
					jobClusterService.stop();
					LOG.warn("IUMListener Job isStopped = " + isStarted);
				}
				return;
			}

			if(message.startsWith(DAO.WORKING_SYNC_JOB)){
				String[] parts =message.split(";");
				Boolean isStarted = Boolean.valueOf(parts[1]);
				if (isStarted) {
					jobSyncService.start();
					LOG.warn("IUMListener Sync isStarted = " + isStarted);
				} else {
					jobSyncService.stop();
					LOG.warn("IUMListener Sync isStopped = " + isStarted);
				}
				return;
			}
		}
	}

	class JobRunnerKeyDetail {
		public JobRunnerKey jobRunnerKey;
		public Date nextRunDate = null;

		public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date nextRunDate) {
			this.jobRunnerKey = jobRunnerKey;
			this.nextRunDate = nextRunDate;
		}

		public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
			this(jobRunnerKey, null);
		}

		public JobRunnerKeyDetail(String className) {
			this.jobRunnerKey = JobRunnerKey.of(className);
			this.nextRunDate=null;
		}

	}
}
