package de.accxia.jira.addon.IUM.model;

import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.Index;
import net.java.ao.schema.Indexes;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.Table;

import java.util.Date;

/**
 * SELECT "ASESSION_ID", "CREATION_TIME", "ID", "INVALIDATE_SESSION_FLAG", "LAST_ACCESS_TIME", "REQUEST_COUNT", "SESSION_ID", "USER_NAME"
 * FROM public."AO_B12B14_NAV_USER";
 */
@Preload
@Table("NAV_USER")
@Indexes({
        @Index(name = "lookupUserName", methodNames = {"getUserName"}),
        @Index(name = "lookupSession", methodNames = {"getSessionId","getASessionId"})
})
public interface NavUser extends Entity {
    public static final String ID = "ID";
    public static final String REQUEST_COUNT = "REQUEST_COUNT";
    public static final String USER_NAME = "USER_NAME";
    public static final String LAST_ACCESS_TIME = "LAST_ACCESS_TIME";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String INVALIDATE_SESSION_FLAG = "INVALIDATE_SESSION_FLAG";
    public static final String ASESSION_ID = "ASESSION_ID";
    public static final String SESSION_ID = "SESSION_ID";

    //requestCount
    public Long getRequestCount();
    public void setRequestCount(Long requestCount);

    //userName
    public String getUserName();
    public void setUserName(String userName);

    //lastAccessTime
    public Date getLastAccessTime();
    public void setLastAccessTime(Date lastAccessTime);

    //creationTime
    public Date getCreationTime();
    public  void setCreationTime(Date creationTime);

    //invalidateSessionFlag
    public Boolean getInvalidateSessionFlag();
    public void setInvalidateSessionFlag(Boolean invalidateSessionFlag);

    //asessionId
    public String getASessionId();
    public void setASessionId(String  asessionId);

    //sessionId
    public String getSessionId();
    public void setSessionId(String  sessionId);
}
