package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.agents.AgentResultsResponse;
import de.accxia.jira.addon.IUM.agents.AgentWorkload;
import de.accxia.jira.addon.IUM.agents.AgentWorkloadImpl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;

import javax.inject.Inject;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Scanned
public class IUMRestSDFilter implements Filter {

    private static final Logger LOG = LoggerFactory.getLogger(IUMRestSDFilter.class);
    private AgentWorkload agentWorkload;

    public static final String  AGENTS = "/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search";
    public static final Pattern PATTERN_AGENTS = Pattern.compile(AGENTS);

    /**
     * Does nothing but prints INFO log message
     *
     * @param filterConfig not used
     * @throws ServletException not thrown
     */
    public void init(final FilterConfig filterConfig) throws ServletException    {
        LOG.info("IUMRestSDFilter initialized.");
    }

    @Inject
    public IUMRestSDFilter(ApplicationProperties applicationProperties, ProjectManager projectManager, IssueManager issueManager) {
//        this.issueManager = issueManager;
//        this.userManager= ComponentAccessor.getUserManager();
//        this.userSearchService = ComponentLocator.getComponent(UserSearchService.class);
//        this.applicationProperties = applicationProperties;
//        this.projectManager = projectManager;

        try{
            //1.attept to load from ComponentManager
            this.agentWorkload =(AgentWorkload) ComponentLocator.getComponent(AgentWorkload.class);
            //Workaround for ServiceDesk
            if(this.agentWorkload==null){
                ComponentManager.getInstance().registerComponent(AgentWorkload.class, AgentWorkloadImpl.class);
                this.agentWorkload =(AgentWorkload) ComponentLocator.getComponent(AgentWorkload.class);
            }
        }catch (Exception e){
            LOG.error("Exception " +e.getMessage(),e);

        }

    }
    // https://aurelian-jira.accxia.com/rest/internal/2/users/assignee?issueKey=TS-3&maxResults=100&query=cr&_=1714397430190

    // https://aurelian-jira.accxia.com/rest/api/2/user/assignable/search?username=ac&project=TA&maxResults=50&startAt=0
    // https://aurelian-jira.accxia.com/rest/api/latest/user/assignable/multiProjectSearch?username=xa&projectKeys=TA&maxResults=100&_=1714298078606
    // https://aurelian-jira.accxia.com/rest/api/latest/user/assignable/search?username=ac&project=TA&maxResults=50&startAt=0
    // https://aurelian-jira.accxia.com/rest/servicedesk/1/pages/people/agents/TA/search?query=&_=1714113447736
    //
    // https://aurelian-jira.accxia.com/rest/servicedesk/automation/1/components/then/TA/validate
    // https://aurelian-jira.accxia.com/rest/servicedesk/automation/1/ruleset/91/expectedRevisionId/91
    // https://aurelian-jira.accxia.com/rest/servicedesk/automation/1/ruleset/91/expectedRevisionId/91/validate
    /**
     *
     * @param servletRequest request
     * @param servletResponse response
     * @param filterChain filter chain
     * @throws IOException if another filter in the filter chain throws it
     * @throws ServletException if another filter in the filter chain throws it
     */
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain)
            throws IOException, ServletException{

        // now look into the request and log it
        final HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        final HttpServletResponse httpServletResponse = (HttpServletResponse) servletResponse;

        try {

            if(StringUtils.isEmpty(httpServletRequest.getRequestURI())){
                filterChain.doFilter(httpServletRequest, httpServletResponse);
                return;
            }

            //4.  request like : /pages/people/agents/TA/search
            Matcher matcherAgents = PATTERN_AGENTS.matcher(httpServletRequest.getRequestURI());
            if (matcherAgents.matches()){
                String projectKey =  matcherAgents.groupCount()>=2 ? matcherAgents.group(2):"";
                String query = httpServletRequest.getParameter("query");
                final ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper((HttpServletResponse) servletResponse);

                filterChain.doFilter(servletRequest, responseWrapper);
                doAddAgents(projectKey,query,responseWrapper,servletResponse);
                return;
            }


            filterChain.doFilter(httpServletRequest, httpServletResponse);

        } catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), e);
        }

    }


    private void doAddAgents(String projectKey, String query, ContentCachingResponseWrapper responseWrapper, ServletResponse servletResponse) throws IOException {

        //atempt to intercept
        final byte[] originalData = responseWrapper.getContentAsByteArray();

        // Modify the original data
        String newData = new String(originalData);
        AgentResultsResponse disableAgents = agentWorkload.searchAgentWorkloadForProject(query,projectKey);
        AgentResultsResponse enabledAgents = agentWorkload.fromString(newData);
        agentWorkload.mergeAgentResultsResponse(enabledAgents,disableAgents);

        newData= agentWorkload.toString(enabledAgents);

        // Write the data into the output stream
        servletResponse.setContentLength(newData.length());
        servletResponse.getOutputStream().write(newData.getBytes());

        // Commit the written data
        servletResponse.getOutputStream().flush();
    }


    @Override
    public void destroy() {

    }
}
