package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.config.RestRoute;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.Quota;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Scanned
public class IntelligentUserManagerCerberosFilter implements Filter{
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);

	public static final String ORIGIN="origin";
	public static final String URI_RESTORE="secure/restore";
	public static final String URI_DISABLE="secure/disable";

	@ComponentImport
	private final JiraAuthenticationContext jiraAuthenticationContext;
	@ComponentImport
	private final ApplicationProperties applicationProperties;
	@ComponentImport
	private final ApplicationAuthorizationService applicationAuthorizationService;
	@ComponentImport
	private final IssueSecurityLevelManager issueSecurityLevelManager;
	@ComponentImport
	private final PermissionManager permissionManager;
	@ComponentImport
	private final IssueManager  issueManager;
	@ComponentImport
	private final ProjectManager projectManager;
	@ComponentImport
	private PageBuilderService pageBuilderService;
	@ComponentImport
	private final TemplateRenderer renderer;

	@Inject
	public IntelligentUserManagerCerberosFilter(TemplateRenderer renderer, PageBuilderService pageBuilderService,
                                                IssueSecurityLevelManager issueSecurityLevelManager, IssueManager issueManager,
                                                ApplicationAuthorizationService applicationAuthorizationService, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager, ProjectManager projectManager) {

		this.jiraAuthenticationContext = jiraAuthenticationContext;
		this.renderer = renderer;
		this.applicationProperties = applicationProperties;
		this.pageBuilderService = pageBuilderService;
		this.issueSecurityLevelManager = issueSecurityLevelManager;
		this.issueManager = issueManager;
		this.applicationAuthorizationService = applicationAuthorizationService;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
    }


	public void init(FilterConfig filterConfig) throws ServletException {
	}

	public void destroy() {
	}


    public void doFilter(ServletRequest request,ServletResponse response,FilterChain chain)throws IOException,ServletException{

		HttpServletRequest httpServletRequest = (HttpServletRequest) request;
		if(log.isDebugEnabled()){
			log.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") +
					", servletPath=" +
					(httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") +
					", pathInfo=" +
					(httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A")+
					", user=" +
					(httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
		}

		//is necessary ??
		if (!jiraAuthenticationContext.isLoggedInUser()) {
			chain.doFilter(request, response); // no vaild user -->  do nothing
			return;
		}
		ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
		if(user==null ||!user.isActive()){
			chain.doFilter(request, response); // inacBrtive --> do nothing
			return;
		}

		//TODO add  httpServletRequest.getContentType()!=null && xssRequest.getContentType().contains("application/json")
		if( httpServletRequest.getRequestURI() !=null && (
				httpServletRequest.getRequestURI().contains("/rest/IUM/latest/apps") ||
						httpServletRequest.getRequestURI().contains("/rest/IUM/latest/check") ||
						httpServletRequest.getRequestURI().contains("/rest/IUM/latest/retry") ||
						httpServletRequest.getRequestURI().contains("/rest/lastlog") ||
						httpServletRequest.getRequestURI().contains("/rest/projects") ||
						httpServletRequest.getRequestURI().contains("/rest/plugins/") ||
						httpServletRequest.getRequestURI().contains("/rest/wrm") ||
						httpServletRequest.getRequestURI().contains("/rest/bamboo") ||
						httpServletRequest.getRequestURI().contains("/rest/analytics") ||
						httpServletRequest.getRequestURI().contains("/rest/gadget/1.0/login"))){

			if(log.isDebugEnabled()){
				log.debug("NonWatchedRestRequest="+ httpServletRequest.getRequestURI() +
						" ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}

			chain.doFilter(request, response);
			return;
		}

		if( httpServletRequest.getRequestURI() !=null && (
				httpServletRequest.getRequestURI().contains("/secure/viewavatar"))){

			if(log.isDebugEnabled()){
				log.debug("NonWatchedRestRequest="+ httpServletRequest.getRequestURI() +
						" ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}

			chain.doFilter(request, response);
			return;
		}

		if( httpServletRequest.getRequestURI() !=null &&
				httpServletRequest.getRequestURI().contains("/rest/")&&
				!shouldInterceptRestRequest(httpServletRequest)){
			if(log.isDebugEnabled()){
				log.debug("NonWatchedRestRequest="+ httpServletRequest.getRequestURI() +
						" ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}

			chain.doFilter(request, response);
			return;
		}

    	if (!ConditionEvaluatorImpl.isLicenseValid()) {
			chain.doFilter(request, response); // no vaild license  --> do nothing
			return;
		}
		if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains("/login.jsp")){
			chain.doFilter(request, response); // login  -->  do nothing
			return;
		}

		if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains("/logout.action")){
			chain.doFilter(request, response); // logout  -->  do nothing
			return;
		}

		if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains("/secure/Logout")){
			chain.doFilter(request, response);
			return;
		}

		// test whether user does not belong to the disabled group
		if (!IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())){
			if(log.isDebugEnabled()){
				log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " is not belong to IUM Disable :" + DAO.getIUMGroupsDisabled() + "  ==> forward doFilter ");
			}
			chain.doFilter(request,response);
			return;
		}

		//special case for xhr request for ServiceDesk
		if (httpServletRequest.getServletPath() != null && httpServletRequest.getServletPath().contains("/servicedesk") && "POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
			if (log.isDebugEnabled()) {
				log.debug("special case for servletPath/xhr request for ServiceDesk " + httpServletRequest.getServletPath());
			}
			//special case for xhr request for ServiceDesk
			chain.doFilter(httpServletRequest, response);
			return;
		}

		//===============================================================================

		//request disable | move to waiting queue ?
		if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains(URI_DISABLE)){
			if(log.isDebugEnabled()){
				log.debug("Received disable url="+ URI_DISABLE + " " + httpServletRequest.getRequestURI()+ " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}

			String username = request.getParameter("username");
			if (username==null || username.length()==0){
				//should never happen
				if(log.isDebugEnabled()){
					log.debug("Empty username for "+ URI_DISABLE + " redirect '/' ");
				}

				((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");

				return;
			}

			//1. the user now belongs to the group ium_enable
			if (username!=null && username.length()>0 && IntelligentUserManagerHelper.isUserInGroups(username, DAO.getIUMGroups())){
				if(log.isDebugEnabled()){
					log.debug("Redirect to the saved url | referrer | base url "+ this.applicationProperties.getBaseUrl());
				}

				doGlobalRedirect(httpServletRequest,(HttpServletResponse)response);
				return;
			}

			//2.the user still belongs to the group ium_disable
			if(log.isDebugEnabled()){
				log.debug("Redirect user " + username + " to the queue ");
			}

			renderQueueVM(username,IntelligentUserManagerHelper.getQuotaForGroupOfUsername(username), httpServletRequest, (HttpServletResponse) response); //need to add function for failed login

			return;
		}

		/* here the user is :
		 * 1. valid && active
		 * 2. belongs to the disable group
		 *
		*/

		// test whether user already has been reenabled and is in the enabled group
		if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroups())){
			if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains(URI_RESTORE)){
				if(log.isDebugEnabled()){
					log.debug("Received restore url=" + URI_RESTORE + "  " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
				}

				doGlobalRedirect(httpServletRequest,(HttpServletResponse)response);
				return;
			}

			if(log.isDebugEnabled()){
				log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " belong to IUM Enable :" + DAO.getIUMGroups() + "  ==> forward doFilter ");
			}

			/*
			// test whether user has jira access
			if (applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE) ||
					applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK) ||
					applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE)){
				if(log.isDebugEnabled()){
					log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " has jira access  ==> forward doFilter ");
				}

				if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains(URI_RESTORE)){
					doGlobalRedirect(httpServletRequest,(HttpServletResponse)response);
					return;
				}

				chain.doFilter(request,response);
				return;
			}
			*/
			chain.doFilter(request, response);
			return;
		}

		XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper((HttpServletRequest) request);
		if(shouldInterceptRestRequest(xssRequest)){
			if(log.isDebugEnabled()){
				log.debug("InterceptRestRequest="+ httpServletRequest.getRequestURI() +
						" ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}
			// let normally flow for user request and then logout
			IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
			chain.doFilter(xssRequest,response);
			// logout !!!
			// IntelligentUserManagerHelper.logOutUser(user, xssRequest, jiraAuthenticationContext);

			return;
		}

		if( xssRequest.getRequestURI() !=null && xssRequest.getRequestURI().contains("/rest/")){
			if(log.isDebugEnabled()){
				log.debug("RestRequest="+ httpServletRequest.getRequestURI() +
						" ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
			}

			chain.doFilter(request, response);
			return;
		}

		//authorization
		if(log.isDebugEnabled()){
			log.debug("Attempt to enable route=" + xssRequest.getRequestURI() + " for user " + user.getUsername());
		}
		CurrentUser currentUser =IntelligentUserManagerHelper.enableUserFromGroup(user, xssRequest);

		if (currentUser!=null && currentUser.user!=null){
			IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
			xssRequest.getSession().setAttribute("IUMUSER", user.getUsername());

			// 1. Jira issue link
			// https://aurelian-jira.accxia.com/browse/TA-1
			// 2. Jira issue link
			// https://aurelian-jira.accxia.com/projects/TA/issues/TA-1
			// https://aurelian-jira.accxia.com/projects/TA/issues/TA-1?filter=allopenissues


			String issueKey=getIssueLinkWithoutPermission(httpServletRequest,(HttpServletResponse)response);
			if ((issueKey!=null) &&
				(httpServletRequest.getSession().getAttribute("IUMREDIRECT") ==null  || (!(Boolean) httpServletRequest.getSession().getAttribute("IUMREDIRECT")))){

				/*
				// Strange but not work anymore
				 List<IssueSecurityLevel> issueSecurityLevelList = issueSecurityLevelManager.getUsersSecurityLevels(issueManager.getIssueByCurrentKey(projectKey),user);
				 if(issueSecurityLevelList.size()==0) {
					if(log.isDebugEnabled()){
						log.debug("Redirect =" + xssRequest.getRequestURI() + " for issueSecurityLevelList " + issueSecurityLevelList.size());
					}
					//redirect
				 }
				 */

				if(this.permissionManager.hasPermission(Permissions.BROWSE, issueManager.getIssueByCurrentKey(issueKey),user)){
					if(log.isDebugEnabled()){
						log.debug("Redirect =" + xssRequest.getRequestURI() + " for user " + user.getUsername());
					}

					xssRequest.getSession().setAttribute("IUMREDIRECT",Boolean.TRUE);
					((HttpServletResponse)response).setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
					((HttpServletResponse)response).setHeader("Location", httpServletRequest.getRequestURI());
					((HttpServletResponse)response).sendRedirect(httpServletRequest.getRequestURI());
					((HttpServletResponse)response).flushBuffer();
					return;
				}
			}


			// 2. Service desk
			// https://aurelian-jira.accxia.com/projects/TA/queues/custom/72/TA-1
			String projectKey=getProkectLinkWithoutPermission(httpServletRequest,(HttpServletResponse)response);
			if ((projectKey!=null) &&
					(httpServletRequest.getSession().getAttribute("IUMREDIRECT") ==null  || (!(Boolean) httpServletRequest.getSession().getAttribute("IUMREDIRECT")))){
				/*
				// Strange but not work anymore
				 List<IssueSecurityLevel> issueSecurityLevelList = issueSecurityLevelManager.getUsersSecurityLevels(issueManager.getIssueByCurrentKey(projectKey),user);
				 if(issueSecurityLevelList.size()==0) {

				 }
				 */
				if(this.permissionManager.hasPermission(Permissions.BROWSE, projectManager.getProjectObjByKey(projectKey),user)){

					xssRequest.getSession().setAttribute("IUMREDIRECT",Boolean.TRUE);
					((HttpServletResponse)response).setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
					((HttpServletResponse)response).setHeader("Location", httpServletRequest.getRequestURI());
					((HttpServletResponse)response).sendRedirect(httpServletRequest.getRequestURI());
					((HttpServletResponse)response).flushBuffer();
					return;

				}


			}


			httpServletRequest.getSession().setAttribute("IUMREDIRECT",null);

			HttpServletResponse httpServletResponse = (HttpServletResponse) response;
			if(!StringUtils.isEmpty(currentUser.warningMessage)){
				addWarnMessage2Response(httpServletRequest, httpServletResponse,"login_info_cookie",currentUser.warningMessage);
			}else{
				removeWarnMessage2Response(httpServletRequest, httpServletResponse,"login_info_cookie",currentUser.warningMessage);
			}

			if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains(URI_RESTORE) && httpServletRequest.getMethod().equalsIgnoreCase("POST")){
				if(log.isDebugEnabled()){
					log.debug("Received restore " + URI_RESTORE + " " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
				}

				doGlobalRedirect(httpServletRequest,(HttpServletResponse)response);
				return;

			}

			chain.doFilter(xssRequest,response);
			return;
		}else{

			if(log.isDebugEnabled()){
				log.debug("Unable to enabled route  " + xssRequest.getRequestURI() + " for user " + user.getUsername());
			}

			if(httpServletRequest.getRequestURI() !=null && httpServletRequest.getRequestURI().contains(URI_RESTORE)){
				if(log.isDebugEnabled()){
					log.debug("Redirect to waiting page " + URI_RESTORE );
				}

				renderQueueVM(user.getUsername(), (currentUser!=null ? currentUser.noOfUsers:0), xssRequest, (HttpServletResponse) response); //need to add function for failed login
				return;
			}

			//queue full
			if (xssRequest.getServletPath() != null && xssRequest.getServletPath().contains("/servicedesk") && "POST".equalsIgnoreCase(xssRequest.getMethod())) {
				//special case for xhr request for ServiceDesk
				chain.doFilter(xssRequest, response);
			} else {
				//chain.doFilter(request,response);
				renderQueueVM(user.getUsername(), (currentUser!=null ? currentUser.noOfUsers:0), xssRequest, (HttpServletResponse) response); //need to add function for failed login

			}
			return;
		}


		//chain.doFilter(request,response);
    }

	private static final String ISSUE_KEY_PATTERN = ".*/browse/([\\w\\-\\d]+)$";
	private static final String ISSUE_KEY_PATTERN_2 =".*/projects/([\\w\\-\\d]+)/issues/([\\w\\-\\d]+)";

	private static final Pattern ISSUE_PATTERN = Pattern.compile(ISSUE_KEY_PATTERN);
	private static final Pattern ISSUE_PATTERN_2 = Pattern.compile(ISSUE_KEY_PATTERN);

	private String getIssueLinkWithoutPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {

		String strURI = httpServletRequest.getRequestURI();
		Matcher matcher = ISSUE_PATTERN.matcher(strURI);

		// using Matcher find(), group(), start() and end() methods
		if (matcher.matches()) {
			return matcher.group(1);
		}

		Matcher matcher2 = ISSUE_PATTERN_2.matcher(strURI);

		// using Matcher find(), group(), start() and end() methods
		if (matcher2.matches() && matcher2.groupCount() > 1) {
			return matcher2.group(2);
		}
		return null;
	}



	private static final String PROJECTS_KEY_PATTERN = ".*/projects/([\\w\\-\\d]+)/queues/(.*)/([\\w\\-\\d]+)$";
	private static final Pattern PROJECTS_PATTERN = Pattern.compile(PROJECTS_KEY_PATTERN);

	private String getProkectLinkWithoutPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {

		String strURI = httpServletRequest.getRequestURI();
		Matcher matcher = PROJECTS_PATTERN.matcher(strURI);

		// using Matcher find(), group(), start() and end() methods
		if (matcher.matches() && matcher.groupCount() > 2) {
			return matcher.group(3);
		}

		return null;
	}

	private void doGlobalRedirect(HttpServletRequest httpServletRequest,HttpServletResponse httpServletResponse) throws IOException {
		//from request
		String origin = httpServletRequest.getParameter(ORIGIN);
		if(origin!=null && origin.length()>0){
			if(log.isDebugEnabled()){
				log.debug("doGlobalRedirect  ==> " + origin
						+  " , baseUrl=" +this.applicationProperties.getBaseUrl()
						+  " , referer=" + (httpServletRequest.getHeader("referer")!= null ? httpServletRequest.getHeader("referer") : "N/A"));
			}

			//scenario with external auth server like crawd/azure
			if(origin.toLowerCase().startsWith("http") && (!origin.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase()))){

				String referer = httpServletRequest.getHeader("referer");
				if(log.isDebugEnabled()){
					log.debug("doGlobalRedirect auth ==> "  + this.applicationProperties.getBaseUrl()+
							" , referer=" + (referer!= null ? referer : "N/A"));
				}


				if(referer!=null && referer.toLowerCase().startsWith("http") && referer.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase())){
					//baseUrl=https://qa-jira-latest-crowd.accxia.com
					//referer=https://qa-jira-latest-crowd.accxia.com/browse/SP-24
					httpServletResponse.sendRedirect(referer);
					return;
				}


				httpServletResponse.sendRedirect(this.applicationProperties.getBaseUrl());
				return;
			}

			httpServletResponse.sendRedirect(origin);
			return;
		}
		//this.applicationProperties.getBaseUrl()
		//logged as warning
		if(log.isDebugEnabled()){
			log.debug("IntelligentUserManagerCerberosFilter doGlobalRedirect requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") +
					", servletPath=" +
					(httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") +
					", pathInfo=" +
					(httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") +
					", referer=" +
					(httpServletRequest.getHeader("referer")!= null ? httpServletRequest.getHeader("referer") : "N/A") +
					", user=" +
					(httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));

			doDebugRequestData(httpServletRequest,httpServletResponse);
		}

		String referrer = httpServletRequest.getHeader("referer");
		if( referrer!=null && referrer.length()>0
				&& (httpServletRequest.getRequestURI() !=null &&(httpServletRequest.getRequestURI().contains(URI_DISABLE) ||httpServletRequest.getRequestURI().contains(URI_RESTORE)))
				&& (!referrer.contains(URI_DISABLE) ||!referrer.contains(URI_RESTORE))
		){
			if(log.isDebugEnabled()){
				log.debug("doGlobalRedirect  ==> referrer " + referrer );
			}

			httpServletResponse.sendRedirect(referrer);
			return;
		}


		//home page
		if(log.isWarnEnabled()){
			log.warn("doGlobalRedirect  ==> /" );
		}
		httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/");
		return;

	}


	public static Cookie addWarnMessage2Response(HttpServletRequest request, HttpServletResponse response, String name, String value) {

		int maxAge = 60 * 60 ; // 20sec
		String path = request.getContextPath();
		if (StringUtils.isEmpty(path)) {
			path = "/";
		}

		boolean isInsecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
		if (log.isDebugEnabled()) {
			log.debug("setCookie " + name + ":" + value + " path : " + path + " maxAge : " + maxAge + (isInsecureCookie ? " insecure" : " secure"));
		}

		Cookie cookie = new Cookie(name, value);
		cookie.setMaxAge(maxAge);
		cookie.setPath(path);
		if (!isInsecureCookie) {
			cookie.setSecure(request.isSecure());
		}

		response.addCookie(cookie);
		return cookie;
	}

	private void removeWarnMessage2Response(HttpServletRequest request, HttpServletResponse response, String name, String value) {
		Cookie[] cookies= request.getCookies();
		if(cookies!=null){
			for(Cookie cookie:cookies){
				if(cookie.getName().equals(name)){
					cookie.setValue("");
					cookie.setMaxAge(0);
					response.addCookie(cookie);
					break;
				}
			}
		}

	}


	private void renderLoginVM(HttpServletRequest request, HttpServletResponse response) throws IOException {
    	String user=request.getParameter("os_username");
		String pass=request.getParameter("os_password");
		String dest=request.getParameter("os_destination");

		Map<String, Object> context = new HashMap<String, Object>();
		context.put("user", user);
		context.put("pass", pass);
		context.put("dest", dest); // fixed typo desr instead of dest
		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/login_IUM.vm", context, response.getWriter());
	}

	private void renderQueueVM(String username,Quota quota, HttpServletRequest request, HttpServletResponse response) throws IOException {
		if(log.isDebugEnabled()){
			log.debug("quota= "+quota);
		}
		renderQueueVM(username,quota.getQueueSizes(),quota.getFreeSlots(),request,response);
	}
	private void renderQueueVM(String username,int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
		renderQueueVM(username,noOfUsers,-1,request,response);
	}
    private void renderQueueVM(String username,int noOfUsers,int freeSlots, HttpServletRequest request, HttpServletResponse response) throws IOException {
		// log.warn("IntelligentUserManagerCerberosFilter , no of users=" + noOfUsers);
		String baseurl=this.applicationProperties.getBaseUrl();
		String origin = request.getParameter(ORIGIN);
		if(origin==null || origin.length()==0){

			String referrer = request.getHeader("referer");
			if(referrer!=null && !referrer.contains(URI_DISABLE) && !referrer.contains("/login.jsp")){
				if(log.isDebugEnabled()){
					log.debug("Retrive referrer from request: "+referrer + " update latest ref");
				}
				origin = referrer;

			}
		}

		Boolean isServiceDesk = (request.getServletPath() != null && request.getServletPath().contains("/servicedesk") ) ? Boolean.TRUE : Boolean.FALSE;

		Map<String, Object> context = new HashMap<String, Object>();
		//add origin
		context.put(ORIGIN, origin);
		context.put("baseurl", baseurl );
		if (isServiceDesk) {
			context.put("isServiceDesk", "YES");
			context.put("redirUrl", baseurl + "/servicedesk/");
		} else{
			context.put("redirUrl", baseurl+ "/secure/Dashboard.jspa");
		}
		context.put("queueSize",noOfUsers);
		if(freeSlots>0){
			context.put("freeSlots",freeSlots);
		}
		context.put("duration",DAO.getDuration());
		context.put("urlLogo",DAO.getUrlLogo());
		context.put("queueMessage",DAO.getQueueMessage());
		context.put("username",username);
		if(log.isDebugEnabled()){
			log.debug("context= "+context.toString());
		}

		response.setContentType("text/html;charset=utf-8");
		pageBuilderService.assembler().resources().requireWebResource("de.accxia.jira.addon.IUM.IntelligentUserManager:IUM-Check-resources");
		pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags(response.getWriter(), UrlMode.RELATIVE);
		renderer.render("templates/queue_IUM.vm", context, response.getWriter());
	}

	private boolean shouldInterceptRestRequest(HttpServletRequest request){
		//empty route
		if(RestRoute.getInstance().isEmpty()) {
			return false;
		}
		String referrer = request.getHeader("referer"); // Yes, with the legendary misspelling.
		String path =request.getRequestURI();

		boolean contain  = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s -> {return path.indexOf(s)!=-1;});
		return contain;
	}

	private void doDebugRequestData(ServletRequest request, ServletResponse response) {
		// Headers
		try{
			HttpServletRequest httpRequest = (HttpServletRequest) request;

			if(httpRequest.getQueryString()!=null){
				log.warn("QueryString="+httpRequest.getQueryString());
			}

			Cookie[] cookies= httpRequest.getCookies();
			for (Cookie cookie:cookies){
				log.warn(cookie.getName() + " "+ cookie.getValue());
			}

			Enumeration<String> headerNames = httpRequest.getHeaderNames();
			if (headerNames != null) {
				while (headerNames.hasMoreElements()) {
					String headerName = (String) headerNames.nextElement();
					log.warn(headerName+"="+httpRequest.getHeader(headerName));
				}
			}

			Enumeration parameterNames = httpRequest.getParameterNames();
			while (parameterNames.hasMoreElements()) {
				String parameterName = (String) parameterNames.nextElement();
				log.warn(parameterName+"="+httpRequest.getParameter(parameterName));
			}

			Enumeration attributeNames = httpRequest.getAttributeNames();
			while (attributeNames.hasMoreElements()) {
				String attributeName = (String) attributeNames.nextElement();
				log.warn(attributeName+"="+httpRequest.getParameter(attributeName));
			}

		}catch (Exception e){
			log.error("Exception: "+e.getMessage(),e);
		}
	}


	//private String createRedirectURL
}