package de.accxia.jira.addon.IUM.servlet.session;


import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SnapshotAccxiaUserSession implements JiraUserSession {
    private final String sessionId;
    private final String userName;
    private final String ipAddress;
    private final long requestCount;
    private final Date creationTime;
    private final Date lastAccessTime;
    private final HttpRequestType type;
    private final String asessionId;

    public SnapshotAccxiaUserSession(AccxiaMutableJiraUserSession accxiaMutableJiraUserSession) {
        this.sessionId = accxiaMutableJiraUserSession.getId();
        this.asessionId = accxiaMutableJiraUserSession.getASessionId();
        this.userName = accxiaMutableJiraUserSession.getUserName();
        this.ipAddress = accxiaMutableJiraUserSession.getIpAddress();
        this.requestCount = accxiaMutableJiraUserSession.getRequestCount();
        this.creationTime = accxiaMutableJiraUserSession.getCreationTime();
        this.lastAccessTime = accxiaMutableJiraUserSession.getLastAccessTime();
        this.type = accxiaMutableJiraUserSession.getType();
    }

    public String getId() {
        return this.sessionId;
    }

    public String getASessionId() {
        return this.asessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public HttpRequestType getType() {
        return this.type;
    }

    public String toString() {
        return this.sessionId + " AS:" + this.asessionId + " lat:" + (this.lastAccessTime == null ? null : this.lastAccessTime.getTime());
    }
}