package de.accxia.jira.addon.IUM.side;


import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.rest.v2.issue.users.UserPickerResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.google.common.base.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.*;
import javax.ws.rs.core.Response.Status;
import org.apache.commons.lang3.StringUtils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.*;
import java.util.stream.Collectors;


// https://aurelian-jira.accxia.com/rest/IUM/latest/search/user?username=&projectKeys=AD&issueKey=AD-1&actionDescriptorId=21&maxResults=100&_=1710537120543
@Deprecated
@Scanned
@Path("/search")
public class SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);
    public static final int LIMIT = 100;

    private final UserSearchService userSearchService;
    //@ComponentImport
    //private final CrowdService crowdService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final EmailFormatter emailFormatter;
    @ComponentImport
    private final I18nHelper.BeanFactory beanFactory;
    private final UserManager userManager;

    //private final UserPickerResourceHelper userPickerHelper;
    public SearchService(JiraAuthenticationContext jiraAuthenticationContext,
                         ApplicationProperties applicationProperties, EmailFormatter emailFormatter,
                         I18nHelper.BeanFactory beanFactory) {
        this.applicationProperties = applicationProperties;
        this.emailFormatter = emailFormatter;
        this.beanFactory = beanFactory;
        this.userManager = ComponentAccessor.getUserManager();
        this.userSearchService = ComponentLocator.getComponent(UserSearchService.class);
        //this.userPickerHelper=ComponentLocator.getComponent(UserPickerResourceHelper.class);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        com.atlassian.jira.util.ErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, errorCollection);
    }

    // https://aurelian-jira.accxia.com/rest/api/latest/user/assignable/search?username=acc&projectKeys=AD&issueKey=AD-25&actionDescriptorId=21&maxResults=100&_=1710532214245
    // https://aurelian-jira.accxia.com/rest/IUM/latest/search/user?username=&projectKeys=AD&issueKey=AD-1&actionDescriptorId=21&maxResults=100&_=1710537120543
    // https://aurelian-jira.accxia.com/rest/IUM/latest/search/user?username=&projectKeys=AD&issueKey=AD-1&actionDescriptorId=21&maxResults=100&_=1710537120543
    // https://aurelian-jira.accxia.com/rest/IUM/latest/search/user?username=xaccount0001&projectKeys=AD&issueKey=AD-1&maxResults=100&_=1713705446140
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/user")
    public Response searchUser(@QueryParam("username") String username, @QueryParam("projectKeys") String projectKeys,
                               @QueryParam("actionDescriptorId") int actionDescriptorId, @QueryParam("maxResults") int maxResults) {

        try {
            com.google.common.base.Predicate<User> userFilter = null;
            UserSearchParams userSearchParams = UserSearchParams.builder()
                    .includeActive(true)
                    .includeInactive(false)
                    .allowEmptyQuery(true)
                    // .filter(userFilter)
                    .maxResults(maxResults)
                    .build();
            Collection<ApplicationUser> users = this.userSearchService.findUsers(this.getContext(), username, userSearchParams);
            return Response.ok(this.convertUsersToUserBeans(Locale.getDefault(), users))
                    .build();


        } catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), e);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
    }

    private List<UserBean> convertUsersToUserBeans(Locale aDefault, Collection<ApplicationUser> users) throws URISyntaxException {
        List<UserBean> userBeanList = new ArrayList<>();
        for (ApplicationUser user:users){
            userBeanList.add(new UserBean(
                    createSelfLink(user),
                    user.getKey(),
                    user.getName(),
                    user.getDisplayName(),
                    true,
                    user.getEmailAddress(),
                    null,
                    getAvatarURLs(user),
                    null
            ));
        }

        return userBeanList;
    }

    private static Map<String, URI> getAvatarURLs(ApplicationUser forUser) {
        Avatar avatar = ComponentAccessor.getAvatarService().getAvatar(forUser, forUser);
        return avatar != null ? AvatarUrls.getAvatarURLs(forUser, avatar) : null;
    }
    private URI createSelfLink(ApplicationUser forUser) {
        UriBuilder urlBuilder = UriBuilder.fromPath(this.applicationProperties.getBaseUrl())
                .path("rest")
                .path(UserResource.class).queryParam("username", new Object[]{"{0}"});

        return urlBuilder.build(new Object[]{forUser.getUsername()});
    }

}

//
//    private List<User> findUserStartingWith(String  startingWith) {
//        BooleanRestriction booleanRestriction= Combine.allOf(
//                Combine.anyOf(new SearchRestriction[]{
//                        Restriction.on(UserTermKeys.USERNAME).startingWith(startingWith),
//                        Restriction.on(UserTermKeys.DISPLAY_NAME).startingWith(startingWith),
//                        Restriction.on(UserTermKeys.FIRST_NAME).containing(startingWith),
//                        Restriction.on(UserTermKeys.LAST_NAME).containing(startingWith)
//                }),
//                Restriction.on(UserTermKeys.ACTIVE).containing(true)
//        );
//
//        Query<User> findUsersQuery = QueryBuilder.queryFor(User.class, EntityDescriptor.user())
//                .with(booleanRestriction)
//                .returningAtMost(LIMIT);
//
//        return StreamSupport.stream(crowdService.search(findUsersQuery).spliterator(), false)
//                .map(u -> crowdService.getUser(u.getName()))
//                .collect(Collectors.toList());
//
//    }
//}
