package de.accxia.jira.addon.IUM.conditions;

import java.sql.Timestamp;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;

import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;

@Scanned
public class AlwaysTrue extends AbstractWebCondition {
	private static final Logger log = LoggerFactory.getLogger(AlwaysTrue.class);

	
	private JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
	I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(Locale.getDefault());

	public AlwaysTrue() {
	}

	@Override
	public boolean shouldDisplay(ApplicationUser ignore, JiraHelper jiraHelper) {
		// the user is not handed over properly 
		ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
		if (user==null) {
			return(true);
		}	
		Timestamp now = new Timestamp(System.currentTimeMillis());
		IntelligentUserManagerHelper.setUserTS(user.getName(), now.getTime());
		return(true);
	}
}