package de.accxia.jira.addon.IUM.conditions;

import java.sql.Timestamp;
import java.util.Calendar;

import javax.inject.Inject;
import javax.inject.Named;

import de.accxia.jira.addon.IUM.listener.IUMListener;
import org.slf4j.LoggerFactory;

import org.slf4j.Logger;


import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;

import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.side.LicenseData;
import de.accxia.jira.addon.IUM.side.VerifyMessage;


@ExportAsService({ ConditionEvaluator.class })
@Named("IUMIsPluginLicensedCondition")
public class ConditionEvaluatorImpl implements ConditionEvaluator {
	@ComponentImport
	private static PluginLicenseManager licenseManager;
	@ComponentImport
	private static LicenseCountService licenseCountService;

	private static final Logger log = LoggerFactory.getLogger(ConditionEvaluatorImpl.class);
	private static LicenseData sideLicense = null;

	public static LicenseData getSideLicense() {
		return sideLicense;
	}

	public static void setSideLicense() {
		if(IUMListener.PLUGIN_ENABLED){
			ConditionEvaluatorImpl.sideLicense = VerifyMessage.checkSideLicenses();
		}
	}
	public static void setSideLicense(String sideLicense) {
		ConditionEvaluatorImpl.sideLicense = VerifyMessage.checkSideLicenses(sideLicense);
	}
	public static void deleteSideLicense() {
		ConditionEvaluatorImpl.sideLicense = null;
	}

	@Inject
	public ConditionEvaluatorImpl(final PluginLicenseManager licenseManager,
			final LicenseCountService licenseCountService) {
		ConditionEvaluatorImpl.licenseManager = licenseManager;
		ConditionEvaluatorImpl.licenseCountService = licenseCountService;
		ConditionEvaluatorImpl.setSideLicense();
	}

	@Override
	public boolean evaluate(final ConditionType type) {
		switch (type) {
		case LICENSED:
			return isLicenseValid();
		case SIDELICENSED:
			return VerifyMessage.isSideLicenseValid(sideLicense);
		case WRONGSIDELICENSE:
			if ("".equals(DAO.getSideLicense())){
				return false;
			}
			@SuppressWarnings("unused") 
			boolean ignoreResult=isLicenseValid(); // just used to trigger the refresh in license view
			
			// must return true to become triggered
			return true;
		default:
			return false;
		}
	}

	/**
	 * Check the validity of our plugin's license.
	 *
	 * @return true if the plugin's license is valid; false otherwise.
	 */
	public static boolean isAtlassianLicenseValid() {
		// if(true) return true; //shortcut

		// You should replace the logic here with more
		// appropriate logic, depending on how you license your plugin.
		boolean isLicensed = false; // do not miss to replace with false before golive

		boolean hasErrors = false;
		for (PluginLicense pluginLicense : licenseManager.getLicense()) {
			isLicensed = true;
			hasErrors = hasErrors || pluginLicense.getError().isDefined();
		}
		return isLicensed && !hasErrors;
	}

	/**
	 * Check the validity of our plugin's license.
	 * 
	 * @return true if the plugin's license is valid; false otherwise.
	 */
	public static boolean isLicenseValid() {
		// if(true) return true; //shortcut

		// You should replace the logic here with more
		// appropriate logic, depending on how you license your plugin.
		boolean isDebugging = false; // do not miss to replace with false before golive

		boolean isLicensed = isDebugging || isAtlassianLicenseValid();
		if (isLicensed) {
			return (true);
		} else {
			if (VerifyMessage.isSideLicenseValid(sideLicense)) {
				return (true);
			}
		}
		return false;
	}
	
	public static boolean isEvaluation() {
		boolean isEval = false;
		for (PluginLicense pluginLicense : licenseManager.getLicense()) {
				if (pluginLicense.isEvaluation()) return true;
		}
		return isEval;
	}
	
	/*
     * Test whether the 1st date is older than x days from now
     */
	public static boolean isToOldEval(String timestampStr) {
    	if ((timestampStr!=null) && ("".equals(timestampStr)==false)) {
    		Timestamp timestamp = new Timestamp( Long.parseLong(timestampStr));
    		    	Timestamp now = new Timestamp(System.currentTimeMillis());
    		    	Calendar cal = Calendar.getInstance();
    		    	
		    		cal.setTimeInMillis(timestamp.getTime());
		    		cal.add(Calendar.DAY_OF_MONTH, +45); // adjust here to change eval period
		    		//for testing 
		    		//cal.add(Calendar.SECOND, +30); // adjust here to change eval period
		    		Timestamp newtimestamp = new Timestamp(cal.getTime().getTime());
		    		
		    		if (newtimestamp.before(now)) {
		        		return(true);
		    		} 
    	}
    	return(false);
    }

}

