package de.accxia.jira.addon.IUM.conditions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class IsUserInGroupsCondition  extends SimpleUrlReadingCondition implements Condition {

    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    private final JiraAuthenticationContext jiraAuthenticationContext ;

    public IsUserInGroupsCondition(){
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    }

    @Override
    protected boolean isConditionTrue() {
        ApplicationUser applicationUser = jiraAuthenticationContext.getLoggedInUser();
        if (applicationUser == null) {
            return (false);
        }

        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())){
            return true;
        }
        return false;
    }

    @Override
    protected String queryKey() {
        // This string will be appended to URLs as a GET parameter
        // whenever 'isConditionTrue' returns true.
        // You should make the string short, but unique to your plugin.
        return "IUM-UserInGroupsCondition";
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> context) {
        return isConditionTrue();
    }
}
