package de.accxia.jira.addon.IUM.config;

import java.util.Arrays;
import java.util.stream.Collectors;

public class RestRoute {
    // Static variable reference of instance of type RestRoute
    private static RestRoute instance = null;
    private static final String REGEX = "[\r][\n]";

    public static final String[] REST_ROUTE_DEFAULT =new String[] {
            //JReq
            "/rest/api"
    };
    public static final String[] REST_ROUTE =new String[] {
            //JReq
            "/rest/greenhopper",

            //JReq -Confluence
            "/rest/restresource",
            "/rest/capabilities"
    };
    private String[] restRoutes;

    private RestRoute() {
       String tmp =DAO.getValue(DAO.REST_ROUTE);
       String init =DAO.getValue(DAO.REST_INIT);
       if((init==null || init.length()==0) && (tmp==null ||tmp.length()==0)){
            //made our initialization
            tmp=String.join(", ",RestRoute.REST_ROUTE);
            DAO.setValue(DAO.REST_INIT,"true");
       }
       updateRestRoute(tmp);

    }

    public static String removeDefaultRoute(String urlRest) {
        if(!urlRest.isEmpty()){
            urlRest =  Arrays.stream(urlRest.split(REGEX)).filter(route -> !RestRoute.isDefaultRestRoute(route)).collect(Collectors.joining("\r\n"));
        }
        return urlRest;
    }

    private static boolean isDefaultRestRoute(String route) {
        boolean found = false;
        for (int i = 0; i < REST_ROUTE_DEFAULT.length; i++) {
            if (REST_ROUTE_DEFAULT[i].equalsIgnoreCase(route)) {
                found = true;
                break;
            }
        }
        return found;
    }

    public void updateRestRoute(String tmpRestRoutes) {
        restRoutes=(tmpRestRoutes==null || tmpRestRoutes.length()==0) ? new String[0] : tmpRestRoutes.split(REGEX);
    }
    public String[] getRestRoutes() {
        return restRoutes;
    }
    public String[] getAllRestRoutes() {
        if(isEmpty()){
            return REST_ROUTE_DEFAULT;
        }

        return concatWithArrayCopy(REST_ROUTE_DEFAULT, restRoutes);
    }
    public boolean isEmpty() {
        return (restRoutes==null || restRoutes.length==0);
    }
    public static RestRoute getInstance() {
        if (instance == null) {
            instance = new RestRoute();
        }
        return instance;
    }

    private static <T> T[] concatWithArrayCopy(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }
}
