package de.accxia.jira.addon.IUM.model;

import de.accxia.jira.addon.IUM.job.ProcessResult;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class JobResultDTO  implements Serializable {
    //id
    private Integer ID;
    private String process;

    String userName;
    long userCopied;
    long userRemoved;
    String sourceGroups;
    String targetGroup;
    String shortSourceGroups;
    String shortTargetGroup;

    Date startTime;
    Date endTime;


    //========================================================================

    public static JobResultDTO fromAO(JobResult jobResult) {
        JobResultDTO jobResultDTO = new JobResultDTO();
        if(jobResult !=null){
            jobResultDTO.setID(jobResult.getID());
            jobResultDTO.setProcess(jobResult.getProcess());
            jobResultDTO.setUserName(jobResult.getUserName());
            jobResultDTO.setUserCopied(jobResult.getUserCopied());
            jobResultDTO.setUserRemoved(jobResult.getUserRemoved());
            jobResultDTO.setSourceGroups(jobResult.getSourceGroups());
            jobResultDTO.setTargetGroup(jobResult.getTargetGroup());
            jobResultDTO.setStartTime(jobResult.getStartTime());
            jobResultDTO.setEndTime(jobResult.getEndTime());
        }
        return jobResultDTO;
    }

    public static JobResultDTO createJobResult(ProcessResult processResult , String currentUser,long elapsedTime){
        JobResultDTO jobResultDTO = new JobResultDTO();
        Date startTime =new Date(System.currentTimeMillis()-elapsedTime);
        Date endTime = new Date(System.currentTimeMillis());
        if(processResult!=null){
            jobResultDTO.setUserName(currentUser);
            jobResultDTO.setProcess(processResult.getProcess());
            jobResultDTO.setUserCopied(processResult.getUserCopied());
            jobResultDTO.setUserRemoved(processResult.getUserRemoved());
            jobResultDTO.setSourceGroups(processResult.getSourceGroups());
            jobResultDTO.setTargetGroup(processResult.getTargetGroup());
            jobResultDTO.setStartTime(startTime);
            jobResultDTO.setEndTime(endTime);
        }

        return jobResultDTO;
    }

    //========================================================================


    public Integer getID() {
        return ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getUserCopied() {
        return userCopied;
    }

    public void setUserCopied(long userCopied) {
        this.userCopied = userCopied;
    }

    public long getUserRemoved() {
        return userRemoved;
    }

    public void setUserRemoved(long userRemoved) {
        this.userRemoved = userRemoved;
    }

    public String getSourceGroups() {
        return sourceGroups;
    }

    public void setSourceGroups(String sourceGroups) {
        this.sourceGroups = sourceGroups;
    }

    public String getTargetGroup() {
        return targetGroup;
    }

    public void setTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getShortSourceGroups() {
        return shortSourceGroups;
    }

    public void setShortSourceGroups(String shortSourceGroups) {
        this.shortSourceGroups = shortSourceGroups;
    }

    public String getShortTargetGroup() {
        return shortTargetGroup;
    }

    public void setShortTargetGroup(String shortTargetGroup) {
        this.shortTargetGroup = shortTargetGroup;
    }
//========================================================================


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JobResultDTO that = (JobResultDTO) o;
        return userCopied == that.userCopied && userRemoved == that.userRemoved && Objects.equals(ID, that.ID) && Objects.equals(userName, that.userName) && Objects.equals(sourceGroups, that.sourceGroups) && Objects.equals(targetGroup, that.targetGroup) && Objects.equals(startTime, that.startTime) && Objects.equals(endTime, that.endTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ID, userName, userCopied, userRemoved, sourceGroups, targetGroup, startTime, endTime);
    }

    //========================================================================


    @Override
    public String toString() {
        return "JobResultDTO{" +
                "ID=" + ID +
                ", userName='" + userName + '\'' +
                ", userCopied=" + userCopied +
                ", userRemoved=" + userRemoved +
                ", sourceGroups='" + sourceGroups + '\'' +
                ", targetGroup='" + targetGroup + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                '}';
    }
}
